/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.toolkit.uei.DeviceDefinitionManager;
import org.eclipse.mtj.internal.toolkit.uei.Messages;
import org.eclipse.mtj.internal.toolkit.uei.UEIDeviceInternal;
import org.eclipse.mtj.internal.toolkit.uei.UEIPropertiesReader;
import org.eclipse.mtj.internal.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.internal.toolkit.uei.properties.DeviceSpecificProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.DevicesProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinition;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UEIDeviceImporter
implements IDeviceImporter {
    public static final String PROP_TOOLKIT_NAME = "org.eclipse.mtj.toolkit.name";
    private static final String UNSUPORTED_CONFIGURATION = "CDC";

    public List<IDevice> importDevices(File directory, IProgressMonitor monitor) throws CoreException, InterruptedException {
        return this.importDevices(directory, null, monitor);
    }

    public List<IDevice> importDevices(File directory, Map<Class<? extends IDeviceImporter>, Map<File, Object>> importersCollectedData, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ArrayList<IDevice> deviceList = null;
        UEIImporterCollectedData collectedData = null;
        if (importersCollectedData != null) {
            Object data;
            Map<File, Object> collectedDataByDirs = importersCollectedData.get(UEIDeviceImporter.class);
            if (collectedDataByDirs == null) {
                collectedDataByDirs = new HashMap<File, Object>();
                importersCollectedData.put(UEIDeviceImporter.class, collectedDataByDirs);
            }
            if ((data = collectedDataByDirs.get(directory)) == null) {
                collectedData = new UEIImporterCollectedData();
                collectedDataByDirs.put(directory, collectedData);
            } else if (data instanceof UEIImporterCollectedData) {
                collectedData = (UEIImporterCollectedData)data;
            }
        }
        try {
            monitor.beginTask(Messages.UEIDeviceImporter_0, 4);
            UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_begin, (Object)directory));
            File emulator = this.getEmulatorInDirectory(directory, collectedData);
            monitor.worked(1);
            if (emulator != null) {
                UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_emulator, (Object)emulator));
                try {
                    Properties ueiProperties = this.getUEIEmulatorProperties(emulator, collectedData);
                    monitor.worked(1);
                    if (this.isValidUEIProperties(ueiProperties)) {
                        UeiPlugin.debugLog(Messages.UEIDeviceImporter_getMatchingDevices_invalid_props);
                        UEIDeviceDefinition definition = this.getDeviceDefinition(ueiProperties, collectedData);
                        monitor.worked(1);
                        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_device_def, (Object)definition));
                        if (definition != null) {
                            deviceList = new ArrayList<IDevice>();
                            this.addUEIDevices(deviceList, emulator, definition, ueiProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            monitor.worked(1);
                        }
                    }
                }
                catch (CoreException e) {
                    MTJLogger.log((int)4, (String)Messages.UEIDeviceImporter_getMatchingDevices_failed, (Throwable)e);
                }
                catch (IOException e) {
                    MTJLogger.log((int)4, (String)Messages.UEIDeviceImporter_getMatchingDevices_failed, (Throwable)e);
                }
            }
            UeiPlugin.debugLog(String.valueOf(Messages.UEIDeviceImporter_getMatchingDevices_end) + directory);
        }
        finally {
            monitor.done();
        }
        return deviceList;
    }

    private void addUEIDevices(ArrayList<IDevice> devices, File emulator, UEIDeviceDefinition definition, Properties ueiProperties, IProgressMonitor monitor) throws CoreException, InterruptedException {
        UeiPlugin.debugLog(Messages.UEIDeviceImporter_addUEIDevices_begin);
        String devicesProp = ueiProperties.getProperty(DevicesProperties.DEVICE_LIST.toString());
        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_addUEIDevices_devices, (Object)devicesProp));
        if (devicesProp != null) {
            StringTokenizer st = new StringTokenizer(devicesProp, ",");
            monitor.beginTask(Messages.UEIDeviceImporter_1, st.countTokens());
            while (st.hasMoreTokens()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                try {
                    IMIDPAPI api;
                    String deviceName = st.nextToken().trim();
                    IMIDPDevice device = this.createDevice(emulator, definition, ueiProperties, deviceName);
                    if (device == null || (api = device.getCLDCAPI()) == null || api.getIdentifier().equals(UNSUPORTED_CONFIGURATION)) continue;
                    monitor.subTask(NLS.bind((String)Messages.UEIDeviceImporter_2, (Object[])new String[]{device.getName(), device.getSDKName()}));
                    devices.add((IDevice)device);
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
            }
        }
        UeiPlugin.debugLog(Messages.UEIDeviceImporter_addUEIDevices_end);
    }

    protected IMIDPDevice createDevice(File emulatorExecutable, UEIDeviceDefinition definition, Properties ueiProperties, String deviceName) throws CoreException {
        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_createDevice, (Object)deviceName));
        Properties deviceProperties = this.filterDeviceProperties(ueiProperties, deviceName);
        UEIDeviceInternal device = new UEIDeviceInternal(deviceName, ueiProperties.getProperty(PROP_TOOLKIT_NAME, "Unknown"), this.getDeviceDescription(deviceProperties, deviceName), deviceProperties, definition, emulatorExecutable, this.getPreverifier(emulatorExecutable));
        return device;
    }

    protected Properties filterDeviceProperties(Properties ueiProperties, String deviceName) {
        Properties deviceProperties = new Properties();
        String prefix = String.valueOf(deviceName) + ".";
        int substringStart = prefix.length();
        for (String string : ueiProperties.keySet()) {
            if (!string.startsWith(prefix)) continue;
            String propName = string.substring(substringStart);
            String value = ueiProperties.getProperty(string);
            deviceProperties.setProperty(propName, value);
        }
        return deviceProperties;
    }

    private UEIDeviceDefinition getDeviceDefinition(Properties ueiProperties, UEIImporterCollectedData collectedData) throws IOException {
        UEIDeviceDefinition definition;
        UEIDeviceDefinition uEIDeviceDefinition = definition = collectedData == null ? null : collectedData.getDefinition();
        if (definition == null) {
            String toolkitName = ueiProperties.getProperty(PROP_TOOLKIT_NAME, "");
            definition = DeviceDefinitionManager.getInstance().getDeviceDefinition(toolkitName);
            if (collectedData != null) {
                collectedData.setDefinition(definition);
            }
        }
        return definition;
    }

    protected String getDeviceDescription(Properties deviceProperties, String deviceName) {
        return deviceProperties.getProperty(DeviceSpecificProperties.DESCRIPTION.toString(), deviceName).trim();
    }

    private File getEmulatorInDirectory(File directory, UEIImporterCollectedData collectedData) {
        File emulator;
        File file = emulator = collectedData == null ? null : collectedData.getEmulator();
        if (emulator == null) {
            File[] files = null;
            try {
                files = directory.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().equalsIgnoreCase("emulator.exe") || pathname.getName().equals("emulator");
                    }
                });
            }
            catch (SecurityException se) {
                MTJLogger.log((int)4, (String)NLS.bind((String)Messages.UEIDeviceImporter_readAccessDenied, (Object)directory), (Throwable)se);
            }
            if (files != null && files.length > 0) {
                emulator = files[0];
                if (collectedData != null) {
                    collectedData.setEmulator(emulator);
                }
            }
        }
        return emulator;
    }

    protected IPreverifier getPreverifier(File emulatorExecutable) throws CoreException {
        File preverifierExecutable = new File(emulatorExecutable.getParentFile(), "preverify");
        IPreverifier preverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)preverifierExecutable);
        return preverifier;
    }

    private Properties getUEIEmulatorProperties(File emulator, UEIImporterCollectedData collectedData) throws CoreException {
        Properties result;
        Properties properties = result = collectedData == null ? null : collectedData.getEmulatorProperties();
        if (result == null) {
            result = UEIPropertiesReader.getInstance().getUEIProperties(emulator);
            if (collectedData != null) {
                collectedData.setEmulatorProperties(result);
            }
        }
        return result;
    }

    private boolean isValidUEIProperties(Properties ueiProperties) {
        return ueiProperties != null && ueiProperties.containsKey(DevicesProperties.DEVICE_LIST.toString());
    }

    private static class UEIImporterCollectedData {
        private File emulator;
        private Properties emulatorProperties;
        private UEIDeviceDefinition definition;

        private UEIImporterCollectedData() {
        }

        public File getEmulator() {
            return this.emulator;
        }

        public void setEmulator(File emulator) {
            this.emulator = emulator;
        }

        public Properties getEmulatorProperties() {
            return this.emulatorProperties;
        }

        public void setEmulatorProperties(Properties emulatorProperties) {
            this.emulatorProperties = emulatorProperties;
        }

        public UEIDeviceDefinition getDefinition() {
            return this.definition;
        }

        public void setDefinition(UEIDeviceDefinition definition) {
            this.definition = definition;
        }
    }
}

