/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.configurations;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.symbol.Symbol;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.devices.DeviceSelector;
import org.eclipse.mtj.internal.ui.editor.text.TextCellEditor;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConfigAddAndEditWizardPage
extends WizardPage {
    public static final String NAME = "configurationAddPage";
    private static final String CONFIG_WIZARD_SETTINGS = "ConfigWizardSettings";
    private static final String PROP_SYMBOL = "symbol";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"symbol", "value"};
    private List<ISymbol> addedSymbols;
    private Button addSymbolButton;
    private Text configNameText;
    private MTJRuntime configuration;
    private MTJRuntimeList configurations;
    private DeviceSelector deviceSelector;
    private boolean inEditMode;
    private IMTJProject midletSuiteProject;
    private boolean needChangeConfigName = true;
    private List<ISymbol> removedSymbols;
    private Button removeSymbolButton;
    private ISymbolSet symbolSet;
    private boolean symbolSetChanged;
    private TableViewer symbolsTableViewer;
    private CheckboxTableViewer workSpaceSymbolSetViewer;

    public ConfigAddAndEditWizardPage(MTJRuntimeList configurations, MTJRuntime currentConfig) {
        super(NAME);
        this.configurations = configurations;
        this.init(currentConfig);
    }

    public void createControl(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.addConfigurationNameSection(composite);
        this.addDeviceSelectorSection(composite);
        this.addSymbolSetSection(composite);
        this.addWorkSpaceScopeSymbolSetChooseSection(composite);
        this.initializeControls();
        this.setControl((Control)composite);
    }

    public MTJRuntime getConfiguration() {
        return this.configuration;
    }

    public void performCancel() {
        this.restoreSymbolSet();
    }

    public void performFinish() {
        String configName = this.configNameText.getText().trim();
        if (this.inEditMode) {
            this.configuration.setName(configName);
            this.configuration.setDevice(this.deviceSelector.getSelectedDevice());
        } else {
            this.configuration = MTJRuntimeListUtils.createMTJRuntime((String)configName);
            this.configuration.setDevice(this.deviceSelector.getSelectedDevice());
            this.configuration.setSymbolSet(this.symbolSet);
            this.configurations.add(this.configuration);
        }
        this.setWorkspaceSymbolSets();
        if (this.symbolSetChanged) {
            this.configuration.fireSymbolSetChanged();
        }
    }

    public void setMidletSuiteProject(IMTJProject midletSuiteProject) {
        this.midletSuiteProject = midletSuiteProject;
    }

    private void addConfigurationNameSection(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.Configuration_ConfigurationAddWizardPage_NewConfigurationName);
        this.configNameText = new Text(composite, 2048);
        this.configNameText.setLayoutData((Object)new GridData(768));
        this.configNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConfigAddAndEditWizardPage.this.needChangeConfigName) {
                    ConfigAddAndEditWizardPage.this.needChangeConfigName = false;
                }
                ConfigAddAndEditWizardPage.this.validateControls();
            }
        });
    }

    private void addDeviceSelectorSection(Composite composite) {
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.createContents(composite, true, true);
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDevice device = ConfigAddAndEditWizardPage.this.deviceSelector.getSelectedDevice();
                if (device == null) {
                    return;
                }
                if (!ConfigAddAndEditWizardPage.this.inEditMode && ConfigAddAndEditWizardPage.this.needChangeConfigName) {
                    ConfigAddAndEditWizardPage.this.configNameText.setText(device.getName());
                    ConfigAddAndEditWizardPage.this.needChangeConfigName = true;
                }
                SymbolSet deviceSymbolSet = (SymbolSet)device.getSymbolSet();
                try {
                    ConfigAddAndEditWizardPage.this.symbolSet = (ISymbolSet)deviceSymbolSet.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    ConfigAddAndEditWizardPage.this.symbolSet = (ISymbolSet)new SymbolSet();
                    ConfigAddAndEditWizardPage.this.symbolSet.setName(device.getName());
                }
                ConfigAddAndEditWizardPage.this.symbolsTableViewer.setInput((Object)ConfigAddAndEditWizardPage.this.symbolSet);
                ConfigAddAndEditWizardPage.this.validateControls();
            }
        });
    }

    private void addSymbol() {
        if (this.symbolSet == null) {
            return;
        }
        String symbolName = "NewSymbol";
        Symbol symbol = null;
        int i = 1;
        while (i < 100) {
            symbolName = "NewSymbol" + i;
            symbol = new Symbol(symbolName, "true");
            if (!this.symbolSet.contains(symbol.getName())) {
                this.symbolSet.add((ISymbol)symbol);
                this.recordAddedSymbols((ISymbol)symbol);
                break;
            }
            ++i;
        }
        this.symbolsTableViewer.refresh();
        this.makeAddedSymbolSelected((ISymbol)symbol);
        this.symbolSetChanged = true;
    }

    private void addSymbolButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.addSymbolButton = new Button(composite, 8);
        this.addSymbolButton.setText("Add");
        this.addSymbolButton.setLayoutData((Object)new GridData(768));
        this.addSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigAddAndEditWizardPage.this.addSymbol();
            }
        });
        this.removeSymbolButton = new Button(composite, 8);
        this.removeSymbolButton.setText("Remove");
        this.removeSymbolButton.setLayoutData((Object)new GridData(768));
        this.removeSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigAddAndEditWizardPage.this.removeSymbol();
            }
        });
    }

    private void addSymbolSetSection(Composite composite) {
        Group symbolSetGroup = new Group(composite, 4);
        symbolSetGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        symbolSetGroup.setLayoutData((Object)gd);
        symbolSetGroup.setText(MTJUIMessages.Configuration_Symbols);
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 400;
        gridData.heightHint = 300;
        this.symbolsTableViewer = this.createSymbolSetTableViewer((Composite)symbolSetGroup);
        this.symbolsTableViewer.getTable().setLayoutData((Object)gridData);
        this.addSymbolButtons((Composite)symbolSetGroup);
    }

    private void addWorkSpaceScopeSymbolSetChooseSection(Composite composite) {
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setText(MTJUIMessages.Configuration_WorkspaceSymbolSetViewer_GroupText);
        gd = new GridData();
        int styles = 68130;
        Table table = new Table((Composite)group, styles);
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 400;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.workSpaceSymbolSetViewer = new CheckboxTableViewer(table);
        this.workSpaceSymbolSetViewer.setContentProvider((IContentProvider)new WorkSpaceSymbolSetTableContentProvider());
        this.workSpaceSymbolSetViewer.setLabelProvider((IBaseLabelProvider)new WorkSpaceSymbolSetTableLabelProvider());
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings(CONFIG_WIZARD_SETTINGS);
        TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.Configuration_WorkspaceSymbolSetViewer_ColumnTitle_Choose, 20.0f, null), new TableColumnInfo(MTJUIMessages.Configuration_WorkspaceSymbolSetViewer_ColumnTitle_SymbolSet, 80.0f, null)};
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, 400, COLUMN_INFO, 1);
        viewerConfiguration.configure((TableViewer)this.workSpaceSymbolSetViewer);
        Button workspaceSymbolSetManageButton = new Button((Composite)group, 8);
        workspaceSymbolSetManageButton.setText(MTJUIMessages.Configuration_WorkspaceSymbolSetViewer_ManageButton);
        workspaceSymbolSetManageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.widget.getDisplay().getActiveShell();
                PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
                PreferenceDialog dialog = new PreferenceDialog(shell, manager);
                dialog.setSelectedNode("org.eclipse.mtj.ui.preferences.symbolDefinitionsPreferencePage");
                if (dialog.open() == 0) {
                    ConfigAddAndEditWizardPage.this.initWorkspaceSymbolSetViewer();
                }
            }
        });
    }

    private TableViewer createSymbolSetTableViewer(Composite composite) {
        int styles = 68098;
        Table table = new Table(composite, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new SymbolsTableContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SymbolsLabelProvider());
        viewer.setSorter(new ViewerSorter());
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings(CONFIG_WIZARD_SETTINGS);
        int DEFAULT_TABLE_WIDTH = 650;
        TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo("Symbol", 40.0f, null), new TableColumnInfo("Value", 60.0f, null)};
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, DEFAULT_TABLE_WIDTH, COLUMN_INFO, 0);
        viewerConfiguration.configure(viewer);
        viewer.setCellModifier((ICellModifier)new CellModifier());
        viewer.setColumnProperties(PROPERTIES);
        viewer.setCellEditors(new CellEditor[]{new SymbolNameCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigAddAndEditWizardPage.this.validateControls();
            }
        });
        return viewer;
    }

    private int getDeviceCount() {
        int count = 0;
        IDeviceRegistry registry = MTJCore.getDeviceRegistry();
        try {
            count = registry.getDeviceCount();
        }
        catch (PersistenceException e) {
            MTJLogger.log((int)2, (String)"Error retrieving device count", (Throwable)e);
        }
        return count;
    }

    private void init(MTJRuntime currentConfig) {
        this.configuration = currentConfig;
        if (currentConfig != null) {
            this.inEditMode = true;
        }
        if (this.inEditMode) {
            this.setTitle(MTJUIMessages.Configuration_EditConfiguration);
            this.setDescription(MTJUIMessages.Configuration_ConfigAddAndEditWizardPage_EditConfigDescription);
        } else {
            this.setTitle(MTJUIMessages.Configuration_AddConfiguration);
            this.setDescription(MTJUIMessages.Configuration_ConfigAddAndEditWizardPage_AddConfigDescription);
        }
    }

    private void initializeControls() {
        if (this.configuration == null) {
            this.deviceSelector.setSelectedDevice(null);
        } else {
            this.deviceSelector.setSelectedDevice(this.configuration.getDevice());
            this.configNameText.setText(this.configuration.getName());
            this.symbolSet = this.configuration.getSymbolSet();
            this.symbolsTableViewer.setInput((Object)this.symbolSet);
        }
        this.initWorkspaceSymbolSetViewer();
        this.validateControls();
        this.setErrorMessage(null);
    }

    private void initWorkspaceSymbolSetViewer() {
        try {
            this.workSpaceSymbolSetViewer.setInput((Object)MTJCore.getSymbolSetRegistry().getAllSymbolSets());
        }
        catch (PersistenceException e) {
            MTJLogger.log((int)4, (Throwable)e);
            return;
        }
        if (this.configuration != null) {
            List symbolSets = this.configuration.getWorkspaceScopeSymbolSets();
            this.workSpaceSymbolSetViewer.setCheckedElements(symbolSets.toArray());
        }
    }

    private boolean isValidSymbol(String symbol) {
        boolean valid = false;
        Pattern WHITESPACE_PATTERN = Pattern.compile(".*\\s+.*");
        if (symbol != null) {
            Matcher matcher = WHITESPACE_PATTERN.matcher(symbol);
            valid = !matcher.matches();
        }
        return valid;
    }

    private void makeAddedSymbolSelected(ISymbol addedSymbol) {
        TableItem[] items = this.symbolsTableViewer.getTable().getItems();
        int pos = 0;
        while (pos < items.length) {
            if (addedSymbol.equals(items[pos].getData())) break;
            ++pos;
        }
        this.symbolsTableViewer.getTable().select(pos);
        this.symbolsTableViewer.getTable().forceFocus();
    }

    private void recordAddedSymbols(ISymbol symbol) {
        if (this.addedSymbols == null) {
            this.addedSymbols = new ArrayList<ISymbol>();
        }
        this.addedSymbols.add(symbol);
    }

    private void recordRemovedSymbols(ISymbol symbol) {
        if (this.removedSymbols == null) {
            this.removedSymbols = new ArrayList<ISymbol>();
        }
        this.removedSymbols.add(symbol);
    }

    private void removeSymbol() {
        TableItem[] selected;
        if (this.symbolSet == null) {
            return;
        }
        Table table = this.symbolsTableViewer.getTable();
        TableItem[] tableItemArray = selected = table.getSelection();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            ISymbol symbol = (ISymbol)tableItem.getData();
            this.symbolSet.remove(symbol.getName());
            this.recordRemovedSymbols(symbol);
            ++n2;
        }
        this.symbolsTableViewer.refresh();
        this.symbolSetChanged = true;
    }

    private void restoreSymbolSet() {
        if (!this.inEditMode) {
            return;
        }
        if (!this.symbolSetChanged) {
            return;
        }
        if (this.midletSuiteProject != null) {
            MTJRuntimeList configsInMetadataFile = MTJCore.createMetaData((IProject)this.midletSuiteProject.getProject(), (ProjectType)ProjectType.MIDLET_SUITE).getRuntimeList();
            MTJRuntime toRestore = (MTJRuntime)configsInMetadataFile.get(configsInMetadataFile.indexOf((Object)this.configuration));
            this.configurations.remove((Object)this.configuration);
            this.configurations.add(toRestore);
            if (this.configuration.isActive()) {
                this.configurations.switchActiveMTJRuntime(toRestore);
            }
            return;
        }
        if (this.removedSymbols != null) {
            this.symbolSet.add(this.removedSymbols);
            this.removedSymbols.clear();
        }
        if (this.addedSymbols != null) {
            this.symbolSet.remove(this.addedSymbols);
            this.addedSymbols.clear();
        }
    }

    private void setWorkspaceSymbolSets() {
        Object[] objects = this.workSpaceSymbolSetViewer.getCheckedElements();
        ArrayList<ISymbolSet> symbolSets = new ArrayList<ISymbolSet>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            symbolSets.add((ISymbolSet)o);
            ++n2;
        }
        this.configuration.setWorkspaceScopeSymbolSets(symbolSets);
    }

    private void validateControls() {
        this.validateRemoveSymbolButton();
        boolean canFinish = this.validConfigName() && this.validDevice();
        this.setPageComplete(canFinish);
    }

    private void validateRemoveSymbolButton() {
        boolean isRemoveSymbolButtonEnable = this.symbolsTableViewer.getTable().getSelection().length > 0;
        this.removeSymbolButton.setEnabled(isRemoveSymbolButtonEnable);
        this.addSymbolButton.setEnabled(this.symbolSet != null);
    }

    private boolean validConfigName() {
        String newConfigName = this.configNameText.getText();
        boolean uniqueConfigName = !this.configurations.contains((Object)MTJRuntimeListUtils.createMTJRuntime((String)newConfigName));
        IStatus result = MTJCore.getWorkspace().validateName(newConfigName, 1);
        boolean ifValidConfigName = !result.isOK() ? false : (this.inEditMode ? (this.configuration.getName().equals(newConfigName) ? true : uniqueConfigName) : uniqueConfigName);
        if (!ifValidConfigName) {
            this.setErrorMessage(MTJUIMessages.Configuration_ErrorMessage_InvalidConfigName);
        } else {
            this.setErrorMessage(null);
        }
        return ifValidConfigName;
    }

    private boolean validDevice() {
        IDevice device = this.deviceSelector.getSelectedDevice();
        if (this.getDeviceCount() <= 0) {
            this.setErrorMessage(MTJUIMessages.Configuration_ErrorMessage_NoDeviceAvailable);
            return false;
        }
        if (device == null) {
            this.setErrorMessage(MTJUIMessages.Configuration_ErrorMessage_NoDeviceSelected);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class CellModifier
    implements ICellModifier {
        private ISymbol symbol;

        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            ISymbol symbol;
            String value = null;
            this.symbol = symbol = (ISymbol)element;
            value = property.equals(ConfigAddAndEditWizardPage.PROP_SYMBOL) ? symbol.getName() : symbol.getValue();
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (this.symbol != null) {
                if (property.equals(ConfigAddAndEditWizardPage.PROP_SYMBOL)) {
                    String newSymbolName = (String)value;
                    if (this.symbol.getName().equals(newSymbolName)) {
                        return;
                    }
                    if (ConfigAddAndEditWizardPage.this.isValidSymbol(newSymbolName)) {
                        ConfigAddAndEditWizardPage.this.symbolSet.remove(this.symbol.getName());
                        this.symbol.setName(newSymbolName);
                        ConfigAddAndEditWizardPage.this.symbolSet.add(this.symbol);
                        ConfigAddAndEditWizardPage.this.symbolSetChanged = true;
                    }
                } else {
                    if (this.symbol.getValue().equals(value)) {
                        return;
                    }
                    this.symbol.setValue(String.valueOf(value));
                    ConfigAddAndEditWizardPage.this.symbolSetChanged = true;
                }
                ConfigAddAndEditWizardPage.this.symbolsTableViewer.refresh();
            }
        }
    }

    private class SymbolNameCellEditor
    extends TextCellEditor {
        public SymbolNameCellEditor(Composite parent) {
            super(parent);
            this.setValidator(new SymbolNameCellEditorValidator());
            this.addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                }

                public void cancelEditor() {
                }

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (!newValidState) {
                        SymbolNameCellEditor.this.setErrorMessage(SymbolNameCellEditor.this.getErrorMessage());
                    } else {
                        SymbolNameCellEditor.this.setErrorMessage(null);
                    }
                }
            });
        }

        protected void doSetValue(Object value) {
            if (this.isValueValid()) {
                super.doSetValue(value);
            }
        }
    }

    private class SymbolNameCellEditorValidator
    implements ICellEditorValidator {
        private SymbolNameCellEditorValidator() {
        }

        public String isValid(Object value) {
            String symbol = (String)value;
            return ConfigAddAndEditWizardPage.this.isValidSymbol(symbol) ? null : "Whitespace not allowed in symbol names.";
        }
    }

    private class SymbolsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SymbolsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ISymbol def = (ISymbol)element;
            switch (columnIndex) {
                case 0: {
                    return def.getName();
                }
                case 1: {
                    return def.getValue();
                }
            }
            return "";
        }
    }

    private class SymbolsTableContentProvider
    implements IStructuredContentProvider {
        private SymbolsTableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            ISymbolSet symbolSet = (ISymbolSet)inputElement;
            return symbolSet.toArray((Object[])new Symbol[symbolSet.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class WorkSpaceSymbolSetTableContentProvider
    implements IStructuredContentProvider {
        private WorkSpaceSymbolSetTableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (ISymbolSet[])inputElement;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class WorkSpaceSymbolSetTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COL_CHECKBOX = 0;
        private static final int COL_STMBOLSET_NAME = 1;

        private WorkSpaceSymbolSetTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ISymbolSet symbolSet = (ISymbolSet)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return symbolSet.getName();
                }
            }
            return "";
        }
    }
}

