/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import java.util.List;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.viewers.LabelProviderViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeviceSelector {
    private String deviceGroupComentLabel = null;
    private String deviceGroupLabel = MTJUIMessages.DeviceSelector_deviceGroupLabel;
    private ComboViewer deviceNamesViewer;
    private ComboViewer deviceViewer;
    private boolean fireSelectionChangedListener = true;
    private ComboViewer groupViewer;
    private Button manageDevicesButton;
    private final Object[] NO_ELEMENTS = new Object[0];
    private IDeviceRegistryListener registryListener;
    private ISelectionChangedListener selectionChangedListener;
    private ComboViewer viewer;

    public void createContents(Composite parent, boolean includeGroup, boolean includeManageButton) {
        Composite composite = null;
        if (includeGroup) {
            Group group = new Group(parent, 0);
            group.setText(this.deviceGroupLabel);
            composite = group;
        } else {
            composite = new Composite(parent, 0);
        }
        this.setCompositeLayout(parent, composite);
        if (this.deviceGroupComentLabel != null) {
            new Label(composite, 0).setText(this.deviceGroupComentLabel);
            new Label(composite, 0);
        }
        this.createSelectionControls(composite);
        if (includeManageButton) {
            this.createDeviceManagementControls(composite);
        }
        this.addRegistryListener();
        this.enableFireSelectionChanged(false);
        this.setInitialState();
        this.enableFireSelectionChanged(true);
    }

    public void dispose() {
        MTJCore.getDeviceRegistry().removeRegistryListener(this.registryListener);
    }

    public void enableFireSelectionChanged(boolean fireSelectionChangedListener) {
        this.fireSelectionChangedListener = fireSelectionChangedListener;
    }

    public String getDeviceGroupComentLabel() {
        return this.deviceGroupComentLabel;
    }

    public String getDeviceGroupLabel() {
        return this.deviceGroupLabel;
    }

    public IDevice getSelectedDevice() {
        IStructuredSelection selection = (IStructuredSelection)this.deviceViewer.getSelection();
        return (IDevice)selection.getFirstElement();
    }

    public boolean isFireSelectionChangedEnabled() {
        return this.fireSelectionChangedListener;
    }

    public void setDeviceGroupComentLabel(String deviceGroupComentLabel) {
        this.deviceGroupComentLabel = deviceGroupComentLabel;
    }

    public void setDeviceGroupLabel(String deviceGroupLabel) {
        this.deviceGroupLabel = deviceGroupLabel;
    }

    public void setEnabled(boolean enabled) {
        this.manageDevicesButton.setEnabled(enabled);
        this.groupViewer.getCombo().setEnabled(enabled);
        this.deviceViewer.getCombo().setEnabled(enabled);
    }

    public void setSelectedDevice(IDevice device) {
        IDevice currentlySelected = this.getSelectedDevice();
        if (!this.areDevicesEqual(device, currentlySelected)) {
            if (device != null) {
                this.setViewerSelection((Viewer)this.groupViewer, device.getSDKName());
                this.setViewerSelection((Viewer)this.deviceViewer, device);
            } else {
                this.groupViewer.setSelection(null);
                this.deviceViewer.setSelection(null);
            }
        }
    }

    public void setSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListener = listener;
    }

    private void addRegistryListener() {
        this.registryListener = new IDeviceRegistryListener(){

            public void deviceAdded(IDevice device) {
                DeviceSelector.this.setInitialState();
                if (DeviceSelector.this.viewer != null && !DeviceSelector.this.viewer.getControl().isDisposed()) {
                    DeviceSelector.this.viewer.refresh();
                }
                if (DeviceSelector.this.deviceNamesViewer != null && !DeviceSelector.this.deviceNamesViewer.getControl().isDisposed()) {
                    DeviceSelector.this.deviceNamesViewer.refresh();
                }
            }

            public void deviceRemoved(IDevice device) {
                IMIDPDevice current = (IMIDPDevice)DeviceSelector.this.getSelectedDevice();
                if (current != null && current == device) {
                    DeviceSelector.this.setInitialState();
                }
                if (DeviceSelector.this.viewer != null && !DeviceSelector.this.viewer.getControl().isDisposed()) {
                    DeviceSelector.this.viewer.refresh();
                }
                if (DeviceSelector.this.deviceNamesViewer != null && !DeviceSelector.this.deviceNamesViewer.getControl().isDisposed()) {
                    DeviceSelector.this.deviceNamesViewer.refresh();
                }
            }
        };
        MTJCore.getDeviceRegistry().addRegistryListener(this.registryListener);
    }

    private boolean areDevicesEqual(IDevice device1, IDevice device2) {
        boolean equal = false;
        if (device1 == null && device2 == null) {
            equal = true;
        } else if (device1 != null && device2 != null) {
            equal = device1.equals(device2);
        }
        return equal;
    }

    private boolean areDevicesRegistered() throws PersistenceException {
        return MTJCore.getDeviceRegistry().getDeviceCount() > 0;
    }

    private ComboViewer createDeviceGroupsViewer(Composite parent, int styles) {
        this.viewer = new ComboViewer(parent, styles);
        this.viewer.setContentProvider((IContentProvider)new DeviceGroupsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DeviceGroupNameLabelProvider());
        this.viewer.setSorter((ViewerSorter)new LabelProviderViewerSorter());
        this.viewer.setInput(new Object());
        return this.viewer;
    }

    private void createDeviceManagementControls(Composite composite) {
        Composite manageComposite = new Composite(composite, 0);
        manageComposite.setLayout((Layout)new GridLayout(1, true));
        GridData compositeData = new GridData();
        compositeData.verticalAlignment = 0x1000000;
        manageComposite.setLayoutData((Object)compositeData);
        this.manageDevicesButton = new Button(manageComposite, 8);
        this.manageDevicesButton.setText(MTJUIMessages.DeviceSelector_manageDevicesButton_label);
        this.manageDevicesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.widget.getDisplay().getActiveShell();
                PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
                PreferenceDialog dialog = new PreferenceDialog(shell, manager);
                dialog.setSelectedNode("org.eclipse.mtj.ui.preferences.deviceManagementPreferencePage");
                dialog.open();
            }
        });
    }

    private ComboViewer createDeviceNamesViewer(Composite parent, int styles) {
        this.deviceNamesViewer = new ComboViewer(parent, styles);
        this.deviceNamesViewer.setContentProvider((IContentProvider)new DeviceContentProvider());
        this.deviceNamesViewer.setLabelProvider((IBaseLabelProvider)new DeviceLabelProvider());
        this.deviceNamesViewer.setSorter((ViewerSorter)new LabelProviderViewerSorter());
        return this.deviceNamesViewer;
    }

    private void createSelectionControls(Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        comboComposite.setLayout((Layout)new GridLayout(2, false));
        comboComposite.setLayoutData((Object)new GridData(1808));
        new Label(comboComposite, 0).setText(MTJUIMessages.DeviceSelector_4);
        this.groupViewer = this.createDeviceGroupsViewer(comboComposite, 8);
        this.groupViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.groupViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeviceSelector.this.deviceGroupChanged();
                if (DeviceSelector.this.selectionChangedListener != null && DeviceSelector.this.fireSelectionChangedListener) {
                    DeviceSelector.this.selectionChangedListener.selectionChanged(event);
                }
            }
        });
        new Label(comboComposite, 0).setText(MTJUIMessages.DeviceSelector_device_label);
        this.deviceViewer = this.createDeviceNamesViewer(comboComposite, 8);
        this.deviceViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.deviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DeviceSelector.this.selectionChangedListener != null && DeviceSelector.this.fireSelectionChangedListener) {
                    DeviceSelector.this.selectionChangedListener.selectionChanged(event);
                }
            }
        });
    }

    private void deviceGroupChanged() {
        this.groupViewer.refresh();
        IStructuredSelection selection = (IStructuredSelection)this.groupViewer.getSelection();
        String groupName = (String)selection.getFirstElement();
        if (groupName == null) {
            return;
        }
        this.deviceViewer.setInput((Object)groupName);
        try {
            List groupDevices = MTJCore.getDeviceRegistry().getDevices(groupName);
            if (groupDevices != null && groupDevices.size() > 0) {
                this.deviceViewer.getCombo().select(0);
            }
        }
        catch (PersistenceException e) {
            MTJLogger.log((int)2, (String)(String.valueOf(MTJUIMessages.DeviceSelector_deviceGroupChanged_error_retrieving_devices) + groupName), (Throwable)e);
        }
    }

    private IDevice getDeviceToSelect() throws PersistenceException {
        IDevice device = null;
        if (this.areDevicesRegistered()) {
            device = this.getSelectedDevice();
            if (device == null) {
                device = MTJCore.getDeviceRegistry().getDefaultDevice();
            }
            if (device == null) {
                List allDevices = MTJCore.getDeviceRegistry().getAllDevices();
                device = (IDevice)allDevices.get(0);
            }
        }
        return device;
    }

    private void setCompositeLayout(Composite parent, Composite child) {
        int columns = 1;
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            columns = ((GridLayout)layout).numColumns;
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = columns;
        child.setLayoutData((Object)gd);
        child.setLayout((Layout)new GridLayout(2, false));
    }

    private void setInitialState() {
        try {
            IDevice device = this.getDeviceToSelect();
            this.setSelectedDevice(device);
        }
        catch (PersistenceException e) {
            MTJLogger.log((int)2, (String)MTJUIMessages.DeviceSelector_setInitialState_error_retrieving_devices, (Throwable)e);
        }
    }

    private void setViewerSelection(Viewer viewer, Object selectedObject) {
        StructuredSelection selection = new StructuredSelection(selectedObject);
        viewer.setSelection((ISelection)selection, true);
    }

    private class DeviceContentProvider
    implements IStructuredContentProvider {
        private DeviceContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = DeviceSelector.this.NO_ELEMENTS;
            if (inputElement != null) {
                String groupName = (String)inputElement;
                try {
                    List deviceList = MTJCore.getDeviceRegistry().getDevices(groupName);
                    if (deviceList != null) {
                        elements = deviceList.toArray(new Object[0]);
                    }
                }
                catch (PersistenceException e) {
                    MTJLogger.log((int)2, (String)MTJUIMessages.DeviceSelector_DeviceContentProvider_error_getElements, (Throwable)e);
                }
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DeviceGroupNameLabelProvider
    extends LabelProvider {
        private DeviceGroupNameLabelProvider() {
        }

        public String getText(Object element) {
            return (String)element;
        }
    }

    private class DeviceGroupsContentProvider
    implements IStructuredContentProvider {
        private DeviceGroupsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = DeviceSelector.this.NO_ELEMENTS;
            try {
                List groups = MTJCore.getDeviceRegistry().getSDKNames();
                elements = groups.toArray(new Object[groups.size()]);
            }
            catch (PersistenceException e) {
                MTJLogger.log((int)2, (String)MTJUIMessages.DeviceSelector_DeviceGroupsContentProvider_error_getElements, (Throwable)e);
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DeviceLabelProvider
    extends LabelProvider {
        private DeviceLabelProvider() {
        }

        public String getText(Object element) {
            IDevice device = (IDevice)element;
            return device.getName();
        }
    }
}

