/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.ui.dialog.CodeSampleData;
import org.eclipse.mtj.internal.ui.dialog.CodeSampleProjectImport;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeSamplesDialog
extends TitleAreaDialog {
    private static final String ERROR_MSG_TYPE = "Error";
    private static final String ERROR_NO_SDK_FOUND = "No SDK found. Please import SDK through Device Management.";
    private static final String ERROR_COULD_NOT_LOAD_SDK = "Could not load default SDK. Please select right SDK.";
    private static final String NO_EXAMPLES_FOUND = "No examples found. Check if examples are available for the selected SDK.";
    private static final String ERROR_WHILE_IMPORTING_PROJECT = "Error while importing selected examples.";
    private TableItem item;
    private Text descriptionWindow;
    private int selectedIndex = -1;
    boolean Selected = false;
    private IPath locPath;
    private TableViewer tableViewer;
    private Color paintColorWhite;
    private Color paintColorBlue;
    private Color paintColorBlack;
    private ArrayList<Hyperlink> hyperLinks = new ArrayList();
    private ArrayList<CodeSampleData> examples = new ArrayList();
    private String exampleFoldername;
    private String title = "Example Projects";
    private String selectedExampleDir;
    private boolean errUI = false;
    private String errMsg = "";
    private String strSelectedSDK = "";

    public CodeSamplesDialog(Shell parentShell, String message) {
        super(parentShell);
        this.initializeSamplesDialog();
    }

    private void initializeSamplesDialog() {
        try {
            List deviceList = MTJCore.getDeviceRegistry().getAllDevices();
            if (deviceList.size() > 0) {
                IDevice defaultDevice = MTJCore.getDeviceRegistry().getDefaultDevice();
                if (defaultDevice == null) {
                    this.setErrMsg(ERROR_COULD_NOT_LOAD_SDK);
                } else {
                    AbstractMIDPDevice advice = (AbstractMIDPDevice)defaultDevice;
                    File[] exampleFolders = this.getAbsoluteExampleFolder(advice);
                    if (exampleFolders == null || exampleFolders.length <= 0) {
                        this.setErrMsg(NO_EXAMPLES_FOUND);
                    } else {
                        this.examples = this.loadExamples(exampleFolders);
                        if (this.examples == null || this.examples.size() <= 0) {
                            this.setErrMsg(NO_EXAMPLES_FOUND);
                        }
                    }
                }
            } else {
                this.setErrMsg(ERROR_NO_SDK_FOUND);
            }
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            this.setErrMsg("Error while looking for imported SDKs.");
        }
    }

    public void create() {
        super.create();
        if (this.isErrUI()) {
            this.setMessage(" Problem while loading example applications.", 2);
        } else {
            this.setMessage("Click on the '" + this.title + "' to see the description of the code example.\n" + " Click on the 'Load Project' button to load example into your workspace.", 1);
        }
    }

    public ArrayList<CodeSampleData> loadExamples(File[] exampleFolders) {
        try {
            ArrayList<CodeSampleData> examples = new ArrayList<CodeSampleData>();
            int i = 0;
            while (i < exampleFolders.length) {
                File node = exampleFolders[i];
                if (node != null && node.isDirectory()) {
                    boolean validExample = false;
                    boolean bl = validExample = new File(node.getAbsoluteFile() + "\\.project").exists() || new File(node.getAbsoluteFile() + "\\nbproject\\genfiles.properties").exists();
                    if (validExample) {
                        CodeSampleData exampleData = new CodeSampleData();
                        exampleData.setExampleName(node.getName());
                        exampleData.setExamplePath(node.getAbsolutePath());
                        exampleData.setExampledDscription("Resource Location: " + node.getCanonicalPath());
                        examples.add(exampleData);
                    }
                }
                ++i;
            }
            return examples;
        }
        catch (Exception exception) {
            System.out.println("Examples loading failed!");
            return null;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        if (this.examples.size() == 0) {
            this.setErrUI(true);
            Label label3 = new Label(parent, 0);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 60;
            label3.setLayoutData((Object)gridData);
            String msg = "\n\n Reason:\n " + this.getErrMsg();
            if (!this.getStrSelectedSDK().equals("")) {
                msg = String.valueOf(msg) + "\n Selected SDK: " + this.getStrSelectedSDK();
            }
            label3.setText(msg);
        } else {
            try {
                GridLayout layout = new GridLayout();
                layout.numColumns = 3;
                parent.setLayout((Layout)layout);
                Label label1 = new Label(parent, 0);
                GridData gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 3;
                label1.setLayoutData((Object)gridData);
                Composite composite = new Composite(parent, 0);
                gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 3;
                gridData.heightHint = 220;
                composite.setLayoutData((Object)gridData);
                TableColumnLayout Tlayout = new TableColumnLayout();
                composite.setLayout((Layout)Tlayout);
                this.tableViewer = new TableViewer(composite, 67584);
                Table table = this.tableViewer.getTable();
                table.setHeaderVisible(true);
                table.setLinesVisible(true);
                TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
                TableColumn tblclmnFirst = tableViewerColumn.getColumn();
                Tlayout.setColumnData((Widget)tblclmnFirst, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
                tblclmnFirst.setText("Sl. No.");
                TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 64);
                TableColumn tblclmnLast = tableViewerColumn_1.getColumn();
                Tlayout.setColumnData((Widget)tblclmnLast, (ColumnLayoutData)new ColumnWeightData(6, 20, true));
                tblclmnLast.setText(this.title);
                int i = 1;
                while (i <= this.examples.size()) {
                    this.item = new TableItem(table, 0);
                    this.item.setText(0, String.valueOf(i));
                    ++i;
                }
                TableItem[] items = table.getItems();
                Label label2 = new Label(parent, 0);
                gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 3;
                label2.setLayoutData((Object)gridData);
                Label label3 = new Label(parent, 0);
                gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 3;
                label3.setLayoutData((Object)gridData);
                label3.setText("Description:");
                this.descriptionWindow = new Text(parent, 2632);
                gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 3;
                gridData.heightHint = 150;
                this.descriptionWindow.setLayoutData((Object)gridData);
                Label label_allign = new Label(parent, 0);
                gridData = new GridData(1, 3, false, false);
                gridData.horizontalSpan = 2;
                label_allign.setLayoutData((Object)gridData);
                Display display = composite.getDisplay();
                this.paintColorWhite = new Color((Device)display, 255, 255, 255);
                this.paintColorBlue = new Color((Device)display, 0, 0, 255);
                this.paintColorBlack = new Color((Device)display, 0, 0, 0);
                this.hyperLinks.clear();
                int i2 = 0;
                while (i2 < this.examples.size()) {
                    TableEditor editor = new TableEditor(table);
                    Hyperlink link = new Hyperlink((Composite)table, 64);
                    link.setText(this.examples.get(i2).getExampleName());
                    link.setBackground(this.paintColorWhite);
                    editor.grabHorizontal = true;
                    editor.setEditor((Control)link, items[i2], 1);
                    this.hyperLinks.add(link);
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            Hyperlink clickedLink = (Hyperlink)e.getSource();
                            for (Hyperlink tmplink : CodeSamplesDialog.this.hyperLinks) {
                                if (tmplink == clickedLink) continue;
                                tmplink.setForeground(CodeSamplesDialog.this.paintColorBlack);
                            }
                            clickedLink.setForeground(CodeSamplesDialog.this.paintColorBlue);
                            int i = 0;
                            while (i < CodeSamplesDialog.this.examples.size()) {
                                if (((CodeSampleData)CodeSamplesDialog.this.examples.get(i)).getExampleName().equals(e.getLabel())) {
                                    CodeSamplesDialog.this.selectedIndex = i;
                                    CodeSamplesDialog.this.descriptionWindow.setText(((CodeSampleData)CodeSamplesDialog.this.examples.get(i)).getExampledDscription());
                                    break;
                                }
                                ++i;
                            }
                        }
                    });
                    ++i2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.toString());
            }
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData(3, 2, false, false);
        parent.setLayoutData((Object)gridData);
        this.createOkButton(parent, 0, "Load Project", true);
        Button cancelButton = this.createButton(parent, 1, "Cancel", false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeSamplesDialog.this.setReturnCode(1);
                CodeSamplesDialog.this.close();
            }
        });
    }

    protected Button createOkButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        if (this.isErrUI()) {
            button.setEnabled(!this.isErrUI());
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CodeSamplesDialog.this.loadExample();
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    private void loadExample() {
        ProgressMonitorDialog dialog;
        if (this.selectedIndex == -1) {
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_MSG_TYPE, (String)"Please select example and try again.");
            return;
        }
        final String workSpacepath = this.getWorkspacePath();
        this.selectedExampleDir = this.examples.get(this.selectedIndex).getExamplePath();
        this.exampleFoldername = this.examples.get(this.selectedIndex).getExampleName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.exampleFoldername);
        if (project != null && project.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_MSG_TYPE, (String)("Project '" + this.exampleFoldername + "' cannot be imported because already exist in the workspace"));
            this.okPressed();
            return;
        }
        final File destpath = new File(String.valueOf(workSpacepath) + "\\" + this.exampleFoldername);
        if (destpath.exists()) {
            dialog = new MessageBox(this.getShell(), 292);
            dialog.setText("Import info");
            dialog.setMessage("Project folder '" + this.exampleFoldername + "' already exist in the workspace.\nDo you want to clean and import?");
            int returnCode = dialog.open();
            if (returnCode == 256) {
                return;
            }
        }
        dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Importing project " + CodeSamplesDialog.this.exampleFoldername + "...", -1);
                    try {
                        if (destpath.exists()) {
                            CodeSamplesDialog.this.recursiveDelete(destpath);
                        }
                        File srcPath = new File(CodeSamplesDialog.this.selectedExampleDir);
                        CodeSamplesDialog.copyFolder(srcPath, destpath);
                        CodeSamplesDialog.this.locPath = (IPath)new Path(String.valueOf(workSpacepath) + "\\" + CodeSamplesDialog.this.exampleFoldername);
                        CodeSamplesDialog.this.loadProjectToWorkspace(CodeSamplesDialog.this.locPath, monitor);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)CodeSamplesDialog.this.getShell(), (String)CodeSamplesDialog.ERROR_MSG_TYPE, (String)CodeSamplesDialog.ERROR_WHILE_IMPORTING_PROJECT);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)CodeSamplesDialog.this.getShell(), (String)CodeSamplesDialog.ERROR_MSG_TYPE, (String)CodeSamplesDialog.ERROR_WHILE_IMPORTING_PROJECT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)CodeSamplesDialog.this.getShell(), (String)CodeSamplesDialog.ERROR_MSG_TYPE, (String)CodeSamplesDialog.ERROR_WHILE_IMPORTING_PROJECT);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_MSG_TYPE, (String)ERROR_WHILE_IMPORTING_PROJECT);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_MSG_TYPE, (String)ERROR_WHILE_IMPORTING_PROJECT);
        }
        this.okPressed();
    }

    private void recursiveDelete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.recursiveDelete(f);
                ++n2;
            }
        }
        file.delete();
    }

    private File[] getAbsoluteExampleFolder(AbstractMIDPDevice advice) {
        File[] exampleFolders;
        String examplePath;
        String executablePath = advice.getExecutable().getAbsolutePath();
        String path = null;
        if (executablePath != null && executablePath.indexOf("bin") != -1) {
            path = executablePath.substring(0, executablePath.lastIndexOf("bin") - 1);
            this.setStrSelectedSDK(path);
        }
        if ((examplePath = advice.getExamplePath()) == null || examplePath.equals("")) {
            return null;
        }
        File exPath = new File(examplePath);
        if (exPath != null && exPath.exists() && (exampleFolders = exPath.listFiles()) != null && exampleFolders.length > 0) {
            return exampleFolders;
        }
        return null;
    }

    private String getWorkspacePath() {
        String workSpacepath = null;
        URL workspace = Platform.getInstanceLocation().getURL();
        try {
            File file = new File(FileLocator.resolve((URL)workspace).toURI());
            workSpacepath = file.getAbsolutePath();
            workSpacepath = workSpacepath.substring(0, workSpacepath.length());
            if (workSpacepath.indexOf("file:") != -1) {
                workSpacepath = workSpacepath.substring(6, workSpacepath.length());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return workSpacepath;
    }

    protected void loadProjectToWorkspace(IPath projectPath, IProgressMonitor monitor) throws CoreException {
        try {
            CodeSampleProjectImport.loadEclipseProjectToWorkSpace(projectPath);
        }
        catch (Exception exception) {
            System.out.println("Try loading netbeans project");
            System.out.println(projectPath.toFile().getName());
            CodeSampleProjectImport.importNetbeansProject(projectPath, monitor);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            String[] stringArray = files = src.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                CodeSamplesDialog.copyFolder(srcFile, destFile);
                ++n2;
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public boolean isErrUI() {
        return this.errUI;
    }

    public void setErrUI(boolean errUI) {
        this.errUI = errUI;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getStrSelectedSDK() {
        return this.strSelectedSDK;
    }

    public void setStrSelectedSDK(String strSelectedSDK) {
        this.strSelectedSDK = strSelectedSDK;
    }
}

