/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.devices.DeviceSelector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceMatchDialog
extends MessageDialogWithToggle {
    private DeviceSelector deviceSelector;
    private IDevice matchedDevice;
    private String deviceGroup;
    private String deviceName;
    private Set<String> existingConfigNames;
    private String previousConfigName;
    private String configurationName = null;
    private Text configurationNameText;

    public DeviceMatchDialog(Shell parentShell) {
        super(parentShell, MTJUIMessages.DeviceMatchDialog_DialogTitle, null, null, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, MTJUIMessages.DeviceMatchDialog_ToggleButton, false);
        this.setShellStyle(67616);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.matchedDevice = this.deviceSelector.getSelectedDevice();
            if (this.configurationNameText != null) {
                this.configurationName = this.configurationNameText.getText();
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        Composite configCombo = new Composite(composite, 0);
        configCombo.setLayoutData((Object)new GridData(1808));
        configCombo.setLayout((Layout)new GridLayout(2, false));
        if (this.configurationName != null) {
            Label label = new Label(configCombo, 0);
            label.setText(MTJUIMessages.Configuration_ConfigurationAddWizardPage_NewConfigurationName);
            this.configurationNameText = new Text(configCombo, 2048);
            this.configurationNameText.setLayoutData((Object)new GridData(1808));
            this.configurationNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Button okButton;
                    String text = DeviceMatchDialog.this.configurationNameText.getText();
                    if (text != null) {
                        text = text.trim();
                    }
                    if ((okButton = DeviceMatchDialog.this.getButton(0)) != null) {
                        okButton.setEnabled(text != null && (DeviceMatchDialog.this.existingConfigNames == null || !DeviceMatchDialog.this.existingConfigNames.contains(text)));
                    }
                    if (text != null) {
                        DeviceMatchDialog.this.previousConfigName = text;
                    }
                }
            });
        }
        Group group = new Group(composite, 0);
        group.setText(MTJUIMessages.DeviceMatchDialog_GroupToMatch);
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)group, 0).setText(MTJUIMessages.DeviceMatchDialog_GroupToMatchDesc);
        new Label((Composite)group, 0);
        Composite comboComposite = new Composite((Composite)group, 0);
        comboComposite.setLayout((Layout)new GridLayout(2, false));
        new Label(comboComposite, 0).setText(MTJUIMessages.DeviceSelector_4);
        Label deviceGroupLabel = new Label(comboComposite, 0);
        deviceGroupLabel.setText(this.getDeviceGroup());
        new Label(comboComposite, 0).setText(MTJUIMessages.DeviceSelector_device_label);
        Label deviceNameLabel = new Label(comboComposite, 0);
        deviceNameLabel.setText(this.getDeviceName());
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.setDeviceGroupLabel(MTJUIMessages.DeviceMatchDialog_GroupInstalled);
        this.deviceSelector.setDeviceGroupComentLabel(MTJUIMessages.DeviceMatchDialog_GroupInstalledDesc);
        this.deviceSelector.createContents(composite, true, true);
        this.previousConfigName = this.getDeviceName();
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DeviceMatchDialog.this.configurationNameText != null && DeviceMatchDialog.this.previousConfigName.equals(DeviceMatchDialog.this.configurationNameText.getText())) {
                    DeviceMatchDialog.this.previousConfigName = DeviceMatchDialog.this.createUniqueConfigurationName(DeviceMatchDialog.this.deviceSelector.getSelectedDevice().getName());
                    DeviceMatchDialog.this.configurationNameText.setText(DeviceMatchDialog.this.previousConfigName);
                }
            }
        });
        if (this.configurationNameText != null) {
            this.configurationNameText.setText(this.configurationName);
        }
        return composite;
    }

    private String createUniqueConfigurationName(String template) {
        if (this.existingConfigNames == null || !this.existingConfigNames.contains(template)) {
            return template;
        }
        int idx = 1;
        while (this.existingConfigNames.contains(String.valueOf(template) + "_" + idx)) {
            ++idx;
        }
        return String.valueOf(template) + "_" + idx;
    }

    private String getDeviceName() {
        return this.deviceName;
    }

    private String getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(String deviceGroup) {
        this.deviceGroup = deviceGroup;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public IDevice getSelectedDevice() {
        return this.matchedDevice;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setExistingConfigNames(Set<String> existingConfigNames) {
        this.existingConfigNames = existingConfigNames;
    }
}

