/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.StructuredViewerSection;
import org.eclipse.mtj.internal.ui.parts.StructuredViewerPart;
import org.eclipse.mtj.internal.ui.parts.TreePart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class TreeSection
extends StructuredViewerSection {
    protected boolean fHandleDefaultButton = true;

    public TreeSection(MTJFormPage formPage, Composite parent, int style, String[] buttonLabels) {
        super(formPage, parent, style, buttonLabels);
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        return new TreeViewer(parent, style);
    }

    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        return new PartAdapter(buttonLabels);
    }

    protected void enableButtons() {
    }

    protected TreePart getTreePart() {
        return (TreePart)this.fViewerPart;
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        TreeViewer viewer = (TreeViewer)this.fViewerPart.getViewer();
        boolean expandedState = viewer.getExpandedState(selection.getFirstElement());
        viewer.setExpandedState(selection.getFirstElement(), !expandedState);
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    class PartAdapter
    extends TreePart {
        public PartAdapter(String[] buttonLabels) {
            super(buttonLabels);
        }

        public void buttonSelected(Button button, int index) {
            TreeSection.this.buttonSelected(index);
            if (TreeSection.this.fHandleDefaultButton) {
                button.getShell().setDefaultButton(null);
            }
        }

        public void handleDoubleClick(IStructuredSelection selection) {
            TreeSection.this.handleDoubleClick(selection);
        }

        public void selectionChanged(IStructuredSelection selection) {
            TreeSection.this.getManagedForm().fireSelectionChanged((IFormPart)TreeSection.this, (ISelection)selection);
            TreeSection.this.selectionChanged(selection);
        }

        protected void createButtons(Composite parent, FormToolkit toolkit) {
            super.createButtons(parent, toolkit);
            TreeSection.this.enableButtons();
            if (parent.getData("filtered") != null) {
                GridLayout layout = (GridLayout)this.fButtonContainer.getLayout();
                layout.marginHeight = 28;
            }
        }

        protected TreeViewer createTreeViewer(Composite parent, int style) {
            return TreeSection.this.createTreeViewer(parent, style);
        }
    }
}

