/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.mtj.internal.ui.editor.text.IControlHoverContentProvider;
import org.eclipse.mtj.internal.ui.editor.text.MTJDefaultInformationControl;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class MTJTextHover
implements ITextHoverExtension,
ITextHover {
    public static void addHoverListenerToControl(final IInformationControl infoControl, final Control control, final IControlHoverContentProvider provider) {
        control.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (infoControl instanceof MTJDefaultInformationControl && ((MTJDefaultInformationControl)infoControl).isDisposed()) {
                    return;
                }
                infoControl.setVisible(false);
            }

            public void mouseHover(MouseEvent e) {
                if (infoControl instanceof MTJDefaultInformationControl && ((MTJDefaultInformationControl)infoControl).isDisposed()) {
                    return;
                }
                String text = provider.getHoverContent(control);
                if (text == null || text.trim().length() == 0) {
                    return;
                }
                MTJTextHover.updateHover(infoControl, text);
                infoControl.setLocation(control.toDisplay(new Point(10, 25)));
                infoControl.setVisible(true);
            }
        });
    }

    public static IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new MTJDefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public static void updateHover(IInformationControl infoControl, String text) {
        infoControl.setInformation(text);
        Point p = infoControl.computeSizeHint();
        infoControl.setSize(p.x, p.y);
        if (text == null || text.trim().length() == 0) {
            infoControl.setVisible(false);
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return MTJTextHover.getInformationControlCreator();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }
}

