/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ResourceMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private IWorkspace fWorkspace;

    public ResourceMarkerAnnotationModel(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fResource = resource;
        this.fWorkspace = resource.getWorkspace();
    }

    private void batchedUpdate(IMarkerDelta[] markerDeltas) {
        HashSet<IMarker> removedMarkers = new HashSet<IMarker>(markerDeltas.length);
        HashSet<IMarker> modifiedMarkers = new HashSet<IMarker>(markerDeltas.length);
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    removedMarkers.add(delta.getMarker());
                    break;
                }
                case 4: {
                    modifiedMarkers.add(delta.getMarker());
                }
            }
            ++n2;
        }
        if (modifiedMarkers.isEmpty() && removedMarkers.isEmpty()) {
            return;
        }
        Iterator e = this.getAnnotationIterator(false);
        while (e.hasNext()) {
            Position p;
            Object o = e.next();
            if (!(o instanceof MarkerAnnotation)) continue;
            MarkerAnnotation a = (MarkerAnnotation)o;
            IMarker marker = a.getMarker();
            if (removedMarkers.remove(marker)) {
                this.removeAnnotation((Annotation)a, false);
            }
            if (modifiedMarkers.remove(marker) && (p = this.createPositionFromMarker(marker)) != null) {
                a.update();
                this.modifyAnnotationPosition((Annotation)a, p, false);
            }
            if (!modifiedMarkers.isEmpty() || !removedMarkers.isEmpty()) continue;
            return;
        }
        Iterator iter = modifiedMarkers.iterator();
        while (iter.hasNext()) {
            this.addMarkerAnnotation((IMarker)iter.next());
        }
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null, 1, null);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    protected boolean isAcceptable(IMarker marker) {
        return marker != null && this.fResource.equals((Object)marker.getResource());
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        return this.fResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
    }

    protected void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        if (markerDeltas.length == 1) {
            IMarkerDelta delta = markerDeltas[0];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                }
            }
        } else {
            this.batchedUpdate(markerDeltas);
        }
        this.fireModelChanged();
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta child;
            IResourceDelta delta = e.getDelta();
            if (delta != null && ResourceMarkerAnnotationModel.this.fResource != null && (child = delta.findMember(ResourceMarkerAnnotationModel.this.fResource.getFullPath())) != null) {
                ResourceMarkerAnnotationModel.this.update(child.getMarkerDeltas());
            }
        }
    }
}

