/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesPage;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesSourcePage;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADEditorPageConfigElement;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.JADSourceEditorPage;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.OverviewEditorPage;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.SigningJADEditorPage;
import org.eclipse.mtj.internal.ui.util.ManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IInPlaceEditor;
import org.eclipse.ui.IInPlaceEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.FileInPlaceEditorInput;
import org.osgi.framework.Version;

public class JADFormEditor
extends FormEditor
implements IInPlaceEditor,
IRegistryChangeListener,
IGotoMarker {
    private static JADFormEditor registryChangeListener;
    private static JADEditorPageConfigElement[] jadEditorPageConfigElements;
    private boolean cleanRequired;
    private List<AbstractJADEditorPage> configPages = new ArrayList<AbstractJADEditorPage>();
    private IFile jadFile;
    private long modificationStamp;
    private ManifestPreferenceStore preferenceStore;
    private JADSourceEditorPage sourceEditor;
    private OverviewEditorPage overviewPage;
    private IFormPage[] buildPropertiesPages;
    private static final String EXT_JAD_EDITOR_PAGE = "jadeditorpage";

    public void doSave(IProgressMonitor monitor) {
        Version newConfiguration;
        monitor.beginTask(MTJUIMessages.JADFormEditor_save_jad_task_name, this.getPageCount() + 1);
        Version oldConfiguration = MidletSuiteProject.extractConfigurationVersion((String)this.getPreferenceStore().getString("MicroEdition-Configuration"));
        boolean sourceEditorDirty = this.sourceEditor.isDirty();
        int i = 0;
        for (AbstractJADEditorPage part : this.configPages) {
            AbstractJADEditorPage formPage;
            if (part instanceof IFormPage && (formPage = part) != null && formPage.getPartControl() != null) {
                if (formPage.isDirty() && !sourceEditorDirty) {
                    formPage.doSave(monitor);
                    monitor.subTask(NLS.bind((String)MTJUIMessages.JADFormEditor_save_jad_subtask_name, (Object)formPage.getTitle()));
                } else {
                    monitor.subTask(NLS.bind((String)MTJUIMessages.JADFormEditor_ignore_save_jad_subtask_name, (Object)formPage.getTitle()));
                    formPage.setDirty(false);
                }
            }
            monitor.worked(i + 1);
        }
        if (this.buildPropertiesPages != null) {
            IFormPage[] iFormPageArray = this.buildPropertiesPages;
            int n = this.buildPropertiesPages.length;
            int formPage = 0;
            while (formPage < n) {
                IFormPage page = iFormPageArray[formPage];
                page.doSave(monitor);
                ++formPage;
            }
        }
        if (sourceEditorDirty) {
            this.sourceEditor.doSave(monitor);
            this.updateEditorInput();
            monitor.subTask(NLS.bind((String)MTJUIMessages.JADFormEditor_save_jad_subtask_name, (Object)this.sourceEditor.getTitle()));
            monitor.worked(i + 1);
            try {
                MidletSuiteFactory.getMidletSuiteProject((IJavaProject)JavaCore.create((IProject)this.getJadFile().getProject())).refreshClasspath(monitor);
            }
            catch (CoreException ex) {
                MTJLogger.log((int)4, (Throwable)ex);
            }
        }
        try {
            if (this.jadFile.exists() && this.jadFile.isReadOnly()) {
                ResourceAttributes attributes = this.jadFile.getResourceAttributes();
                attributes.setReadOnly(false);
                this.jadFile.setResourceAttributes(attributes);
            }
            this.preferenceStore.save();
            if (this.jadFile != null && this.jadFile.exists()) {
                this.jadFile.refreshLocal(0, monitor);
            }
        }
        catch (IOException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        this.editorDirtyStateChanged();
        this.reloadLocalFile();
        if (this.overviewPage.isDirty()) {
            this.overviewPage.doSave(monitor);
            try {
                this.preferenceStore.save();
                if (this.jadFile != null && this.jadFile.exists()) {
                    this.jadFile.refreshLocal(0, monitor);
                }
            }
            catch (IOException ex) {
                MTJLogger.log((int)4, (Throwable)ex);
            }
            catch (CoreException ex) {
                MTJLogger.log((int)4, (Throwable)ex);
            }
            this.editorDirtyStateChanged();
            this.reloadLocalFile();
        }
        if ((newConfiguration = MidletSuiteProject.extractConfigurationVersion((String)this.getPreferenceStore().getString("MicroEdition-Configuration"))) == null || oldConfiguration == null) {
            this.cleanRequired = true;
        } else {
            boolean isNewConfigurationLess18;
            boolean isOldConfigurationLess18 = oldConfiguration.compareTo(Configuration.CLDC_18.getVersion()) < 0;
            boolean bl = isNewConfigurationLess18 = newConfiguration.compareTo(Configuration.CLDC_18.getVersion()) < 0;
            if (isOldConfigurationLess18 != isNewConfigurationLess18) {
                this.cleanRequired = true;
            }
        }
        if (this.jadFile != null && this.cleanRequired) {
            try {
                this.jadFile.getProject().build(15, monitor);
                this.setCleanRequired(false);
            }
            catch (CoreException ex) {
                MTJLogger.log((int)4, (Throwable)ex);
            }
        }
        monitor.done();
    }

    public void doSaveAs() {
    }

    public IFile getJadFile() {
        return this.jadFile;
    }

    public ManifestPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public boolean isDirty() {
        boolean dirty = false;
        if (this.pages != null) {
            for (Object part : this.pages) {
                IFormPage formPage;
                if (!(part instanceof IFormPage) || (formPage = (IFormPage)part) == null || formPage.getPartControl() == null || !formPage.isDirty()) continue;
                dirty = true;
                break;
            }
        }
        return dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isUserDefinedPropertyKey(String key) {
        for (AbstractJADEditorPage jadEditorPage : this.configPages) {
            if (jadEditorPage == null || !jadEditorPage.isManagingProperty(key)) continue;
            return false;
        }
        return true;
    }

    public void setCleanRequired(boolean value) {
        this.cleanRequired = value;
    }

    public void setFocus() {
        File localFile = this.getLocalFile();
        if (localFile != null && localFile.lastModified() > this.modificationStamp && this.shouldReloadLocalFile()) {
            this.reloadLocalFile();
        }
        super.setFocus();
    }

    public void sourceChanged(IInPlaceEditorInput input) {
        this.getSite().getPage().closeEditor((IEditorPart)this, true);
    }

    public void sourceDeleted() {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    private JADEditorPageConfigElement[] getAllEditorPageConfigElements() {
        if (jadEditorPageConfigElements == null) {
            jadEditorPageConfigElements = this.readAllVendorSpecJADAttributes();
            registryChangeListener = new JADFormEditor();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)registryChangeListener);
        }
        return jadEditorPageConfigElements;
    }

    private File getLocalFile() {
        File localfile = null;
        try {
            localfile = this.jadFile.getLocation().toFile();
        }
        catch (Exception e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        return localfile;
    }

    private JADEditorPageConfigElement[] readAllVendorSpecJADAttributes() {
        String plugin = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(plugin, EXT_JAD_EDITOR_PAGE);
        JADEditorPageConfigElement[] resultElements = new JADEditorPageConfigElement[configElements.length];
        int i = 0;
        while (i < configElements.length) {
            resultElements[i] = new JADEditorPageConfigElement(configElements[i]);
            ++i;
        }
        return resultElements;
    }

    private void reloadLocalFile() {
        this.updateEditorInput();
        for (AbstractJADEditorPage jadEditorPage : this.configPages) {
            if (jadEditorPage == null) continue;
            jadEditorPage.editorInputChanged();
        }
    }

    private boolean shouldReloadLocalFile() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)MTJUIMessages.JADFormEditor_shouldReloadLocalFile_dialod_title, (String)MTJUIMessages.JADFormEditor_shouldReloadLocalFile_dialog_message);
    }

    private void updateEditorInput() {
        File localFile = this.getLocalFile();
        this.modificationStamp = localFile.lastModified();
        String filename = localFile.toString();
        this.preferenceStore = new ManifestPreferenceStore(filename);
        try {
            this.preferenceStore.load();
        }
        catch (IOException e) {
            MTJLogger.log((int)2, (Throwable)e);
        }
    }

    protected void addPages() {
        super.setPartName(this.jadFile.getProject().getName());
        JADEditorPageConfigElement[] pageElements = this.getAllEditorPageConfigElements();
        Arrays.sort(pageElements, new Comparator<JADEditorPageConfigElement>(){

            @Override
            public int compare(JADEditorPageConfigElement o1, JADEditorPageConfigElement o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        try {
            this.overviewPage = new OverviewEditorPage(this);
            this.addPage((IFormPage)this.overviewPage);
            this.configPages.add(this.overviewPage);
        }
        catch (PartInitException e1) {
            e1.printStackTrace();
        }
        JADEditorPageConfigElement[] jADEditorPageConfigElementArray = pageElements;
        int n = pageElements.length;
        int n2 = 0;
        while (n2 < n) {
            JADEditorPageConfigElement element = jADEditorPageConfigElementArray[n2];
            try {
                AbstractJADEditorPage page = element.getJADEditorPage();
                page.initialize(this);
                this.addPage((IFormPage)page);
                this.configPages.add(page);
                if (page instanceof OverviewEditorPage.PackagingModelChangeListener) {
                    this.overviewPage.addPackagingModelChangeListener((OverviewEditorPage.PackagingModelChangeListener)((Object)page));
                }
            }
            catch (Exception e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
            ++n2;
        }
        try {
            SigningJADEditorPage signingJADEditorPage = new SigningJADEditorPage(this, this.overviewPage);
            this.addPage((IFormPage)signingJADEditorPage);
            this.configPages.add(signingJADEditorPage);
        }
        catch (PartInitException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        try {
            IMidletSuiteProject suiteProject;
            MTJBuildProperties properties;
            IJavaProject javaProject = JavaCore.create((IProject)this.jadFile.getProject());
            if (javaProject != null && (properties = MTJBuildProperties.getBuildProperties((IMTJProject)(suiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject)))).getBuildPropertyFile().exists()) {
                IFormPage[] iFormPageArray = this.buildPropertiesPages = new IFormPage[]{new BuildPropertiesPage(this, properties), new BuildPropertiesSourcePage(this, properties)};
                int n3 = this.buildPropertiesPages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFormPage page = iFormPageArray[n4];
                    this.addPage(page);
                    ++n4;
                }
            }
        }
        catch (PartInitException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        this.sourceEditor = new JADSourceEditorPage(this);
        try {
            this.addPage((IEditorPart)this.sourceEditor, super.getEditorInput());
        }
        catch (PartInitException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    protected void setInput(IEditorInput input) {
        if (input instanceof FileEditorInput) {
            FileInPlaceEditorInput fipei = new FileInPlaceEditorInput(((FileEditorInput)input).getFile());
            fipei.setInPlaceEditor((IInPlaceEditor)this);
            super.setInput((IEditorInput)fipei);
        } else {
            super.setInput(input);
        }
        if (input instanceof IStorageEditorInput) {
            IStorageEditorInput storageInput = (IStorageEditorInput)input;
            try {
                IPath storagePath = storageInput.getStorage().getFullPath();
                if (storagePath != null) {
                    IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
                    this.jadFile = root.getFile(storagePath.makeAbsolute());
                    if (this.jadFile != null && this.jadFile.exists()) {
                        this.updateEditorInput();
                    }
                }
            }
            catch (Exception e) {
                MTJLogger.log((int)2, (Throwable)e);
            }
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        String plugin = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionDelta[] deltas = event.getExtensionDeltas(plugin, EXT_JAD_EDITOR_PAGE);
        if (deltas.length > 0) {
            jadEditorPageConfigElements = this.readAllVendorSpecJADAttributes();
        }
    }

    public void gotoMarker(IMarker marker) {
        IFormPage page = this.getActivePageInstance();
        if (page.getId() != this.sourceEditor.getId()) {
            page = this.setActivePage(this.sourceEditor.getId());
        }
        IDE.gotoMarker((IEditorPart)page, (IMarker)marker);
    }
}

