/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.JADAttributesRegistry;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.OverviewEditorPage;
import org.eclipse.mtj.internal.ui.util.MidletSelectionDialogCreator;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.JADPropertiesEditorPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class JADOptionalPropertiesEditorPage
extends JADPropertiesEditorPage
implements OverviewEditorPage.PackagingModelChangeListener {
    public static final String ID = "optional";
    private Composite optionalActivePanel;
    private Composite optionalMidletPanel;
    private Composite optionalLibletPanel;
    private Composite otaActivePanel;
    private Composite otaMidletPanel;
    private Composite otaLibletPanel;
    public static final String[][] MIDLET_LIBLET_KEYS = new String[][]{{"MIDlet-Description", "LIBlet-Description"}, {"MIDlet-Delete-Notify", "LIBlet-Delete-Notify"}, {"MIDlet-Install-Notify", "LIBlet-Install-Notify"}};
    private Map<String, FieldEditor> midletFieldEditorsMap = new HashMap<String, FieldEditor>();
    private Map<String, FieldEditor> libletFieldEditorsMap = new HashMap<String, FieldEditor>();
    private PackagingModel packagingModel = PackagingModel.MIDLET;
    public static final String PUSH_REGISTRY_PREFIX = "MIDlet-Push-";
    private static final String PROP_CLASS = "class";
    private static final String PROP_CONNSTR = "connection string";
    private static final String PROP_SENDER = "allowed sender";
    private static final String[] PROPERTIES = new String[]{"connection string", "class", "allowed sender"};
    private static final List<String> PROPERTY_LIST = Arrays.asList(PROPERTIES);
    private Button addButton;
    private ArrayList<PushRegEntry> pushRegEntries = new ArrayList();
    private Button removeButton;
    private int storedEntriesCount;
    private TableViewer tableViewer;

    public JADOptionalPropertiesEditorPage() {
        super(ID, MTJUIMessages.JADOptionalPropertiesEditorPage_title);
    }

    public JADOptionalPropertiesEditorPage(JADFormEditor editor) {
        super(editor, ID, MTJUIMessages.JADOptionalPropertiesEditorPage_title);
    }

    public String getTitle() {
        return MTJUIMessages.JADOptionalPropertiesEditorPage_title;
    }

    protected void addContextHelp(Composite c) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "org.eclipse.mtj.ui.help_JADOptionalPropertiesEditorPage");
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/optional.html";
    }

    protected String getSectionDescription() {
        return null;
    }

    protected String getSectionTitle() {
        return null;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getTitle());
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action("help"){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                }
            };
            helpAction.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            manager.add((IAction)helpAction);
        }
        form.updateToolBar();
        this.createSectionContent(managedForm, managedForm.getForm().getBody(), this);
    }

    protected void createSectionContent(IManagedForm managedForm, Composite composite, IPropertyChangeListener propertyChangeListener) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayoutData((Object)new GridData(1808));
        body.setLayout((Layout)new GridLayout(2, true));
        new Label(body, 0);
        new Label(body, 0);
        Section optionalSection = this.createStaticBasicSection(toolkit, body, MTJUIMessages.JADOptionalPropertiesEditorPage_SectionTitle, MTJUIMessages.JADOptionalPropertiesEditorPage_description);
        Composite optionalSectionClient = this.createStaticSectionClient(toolkit, (Composite)optionalSection, ID);
        optionalSection.setLayoutData((Object)new GridData(770));
        optionalSection.setLayout((Layout)new GridLayout());
        Section otaSection = this.createStaticBasicSection(toolkit, body, MTJUIMessages.JADOTAPropertiesEditorPage_SectionTitle, MTJUIMessages.JADOTAPropertiesEditorPage_SectionDescription);
        Composite otaSectionClient = this.createStaticSectionClient(toolkit, (Composite)otaSection, "ota");
        otaSection.setLayoutData((Object)new GridData(770));
        otaSection.setLayout((Layout)new GridLayout());
        this.optionalActivePanel = new Composite(optionalSectionClient, 0);
        this.optionalMidletPanel = new Composite(this.optionalActivePanel, 0);
        this.optionalLibletPanel = new Composite(this.optionalActivePanel, 0);
        this.otaActivePanel = new Composite(otaSectionClient, 0);
        this.otaMidletPanel = new Composite(this.otaActivePanel, 0);
        this.otaLibletPanel = new Composite(this.otaActivePanel, 0);
        this.createSectionContent(managedForm, optionalSectionClient, this.optionalActivePanel, this.optionalMidletPanel, this.optionalLibletPanel, this);
        this.createSectionContent(managedForm, otaSectionClient, this.otaActivePanel, this.otaMidletPanel, this.otaLibletPanel, this);
        ArrayList<FieldEditor> fieldEditorsList = new ArrayList<FieldEditor>();
        fieldEditorsList.addAll(this.midletFieldEditorsMap.values());
        fieldEditorsList.addAll(this.libletFieldEditorsMap.values());
        this.fieldEditors = fieldEditorsList.toArray(new FieldEditor[0]);
        this.changePackagingModel(this.packagingModel);
        this.updateEditComponents();
        optionalSection.setClient((Control)optionalSectionClient);
        otaSection.setClient((Control)otaSectionClient);
        new Label(body, 0);
        new Label(body, 0);
        Section pushSection = toolkit.createSection(body, 384);
        pushSection.setText(MTJUIMessages.JADPushRegistryEditorPage_sectionTitle);
        pushSection.setDescription(MTJUIMessages.JADPushRegistryEditorPage_sectionDescription);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        pushSection.setLayoutData((Object)gd);
        pushSection.setLayout((Layout)new GridLayout());
        Composite pushSectionClient = toolkit.createComposite((Composite)pushSection, 0);
        pushSectionClient.setLayout((Layout)new GridLayout(2, false));
        pushSection.setClient((Control)pushSectionClient);
        this.createTableViewer(toolkit, pushSectionClient);
        this.createButtons(toolkit, pushSectionClient);
        this.addContextHelp(composite);
    }

    private void createSectionContent(IManagedForm managedForm, Composite section, Composite activePanel, Composite midletPanel, Composite libletPanel, IPropertyChangeListener propertyChangeListener) {
        Control control;
        Control[] children;
        section.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        activePanel.setLayout((Layout)new StackLayout());
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        activePanel.setLayoutData((Object)gridData);
        midletPanel.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        libletPanel.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        new Label(midletPanel, 0);
        new Label(midletPanel, 0);
        new Label(libletPanel, 0);
        new Label(libletPanel, 0);
        DescriptorPropertyDescription[] theDescriptors = this.getDescriptors();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite sectionComp = null;
        int i = 0;
        while (i < theDescriptors.length) {
            Composite composite = sectionComp = theDescriptors[i].isLibletDescriptor() ? libletPanel : midletPanel;
            if (theDescriptors[i].getSectionId().equals((String)section.getData())) {
                IntegerFieldEditor editor = null;
                switch (theDescriptors[i].getDataType()) {
                    case 3: {
                        editor = this.createIntegerFieldEditor(toolkit, sectionComp, theDescriptors[i]);
                        break;
                    }
                    case 4: {
                        editor = this.createComboFieldEditor(toolkit, sectionComp, theDescriptors[i]);
                        break;
                    }
                    default: {
                        editor = this.createStringFieldEditor(toolkit, sectionComp, theDescriptors[i]);
                    }
                }
                if (theDescriptors[i].isLibletDescriptor()) {
                    this.libletFieldEditorsMap.put(theDescriptors[i].getPropertyName(), (FieldEditor)editor);
                } else {
                    this.midletFieldEditorsMap.put(theDescriptors[i].getPropertyName(), (FieldEditor)editor);
                }
                Label label = editor.getLabelControl(sectionComp);
                toolkit.adapt((Control)label, false, false);
                editor.setPropertyChangeListener(propertyChangeListener);
            }
            ++i;
        }
        Control[] controlArray = children = midletPanel.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            if (control instanceof Combo) {
                toolkit.adapt(control, false, false);
            }
            ++n2;
        }
        controlArray = children = libletPanel.getChildren();
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            if (control instanceof Combo) {
                toolkit.adapt(control, false, false);
            }
            ++n2;
        }
    }

    protected DescriptorPropertyDescription[] doGetDescriptors() {
        DescriptorPropertyDescription[] optionalDescriptors = JADAttributesRegistry.getJADAttrDescriptorsByPage((String)(String.valueOf(this.getId()) + ".optional"));
        DescriptorPropertyDescription[] otaDescriptors = JADAttributesRegistry.getJADAttrDescriptorsByPage((String)(String.valueOf(this.getId()) + ".ota"));
        DescriptorPropertyDescription[] result = new DescriptorPropertyDescription[optionalDescriptors.length + otaDescriptors.length];
        System.arraycopy(optionalDescriptors, 0, result, 0, optionalDescriptors.length);
        System.arraycopy(otaDescriptors, 0, result, optionalDescriptors.length, otaDescriptors.length);
        return result;
    }

    public boolean isManagingProperty(String property) {
        String[] managedProperties;
        String[] stringArray = managedProperties = new String[]{"MIDlet-Data-Size", "MIDlet-Description", "MIDlet-Icon", "MIDlet-Info-URL", "MIDlet-Delete-Confirm", "MIDlet-Delete-Notify", "MIDlet-Install-Notify", "LIBlet-Delete-Notify", "LIBlet-Install-Notify", "LIBlet-Description"};
        int n = managedProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String managedProperty = stringArray[n2];
            if (managedProperty.equals(property)) {
                return true;
            }
            ++n2;
        }
        boolean manages = property.startsWith(PUSH_REGISTRY_PREFIX);
        if (manages) {
            String value = property.substring(PUSH_REGISTRY_PREFIX.length());
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                manages = false;
            }
        }
        return manages;
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    private void addItem() {
        PushRegEntry midletDefinition = new PushRegEntry(MTJUIMessages.JADPushRegistryEditorPage_new_pushReg, "", "*");
        this.pushRegEntries.add(midletDefinition);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit toolkit, Composite parent) {
        Composite composite = toolkit.createComposite(parent);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        composite.setLayout((Layout)layout);
        this.addButton = toolkit.createButton(composite, MTJUIMessages.JADPushRegistryEditorPage_add_btn_label, 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADOptionalPropertiesEditorPage.this.addItem();
            }
        });
        toolkit.createLabel(composite, "");
        this.removeButton = toolkit.createButton(composite, MTJUIMessages.JADPushRegistryEditorPage_remove_btn_label, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADOptionalPropertiesEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit toolkit, Composite parent) {
        String[] columns = new String[]{MTJUIMessages.JADPushRegistryEditorPage_connection_column, MTJUIMessages.JADPushRegistryEditorPage_class_column, MTJUIMessages.JADPushRegistryEditorPage_sender_column};
        int styles = 68356;
        Table table = toolkit.createTable(parent, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                JADOptionalPropertiesEditorPage.this.removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout layout = new TableLayout();
        int width = 100 / columns.length;
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setText(element);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(width));
            ++n2;
        }
        table.setLayout((Layout)layout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new MidletCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private void loadPushRegistryEntries() {
        this.pushRegEntries.clear();
        IManifestPreferenceStore store = this.getPreferenceStore();
        int i = 1;
        while (i < 1000) {
            String propName = PUSH_REGISTRY_PREFIX + i;
            if (!store.contains(propName)) break;
            String propValue = store.getString(propName);
            this.pushRegEntries.add(new PushRegEntry(propValue));
            ++i;
        }
        this.storedEntriesCount = this.pushRegEntries.size();
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private void removeSelectedItems() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            this.pushRegEntries.remove(index);
            --i;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)input);
        }
        this.setDirty(false);
        this.loadPushRegistryEntries();
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.setTaskName(this.getTitle());
        IManifestPreferenceStore store = this.getPreferenceStore();
        int currentEntriesCount = this.pushRegEntries.size();
        ArrayList<FieldEditor> integerFieldEditorsToExclude = new ArrayList<FieldEditor>();
        IMidletSuiteProject midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (midletProject instanceof MidletSuiteProject) {
            Collection<FieldEditor> elementsList = null;
            switch (this.packagingModel) {
                case LIBLET: {
                    elementsList = this.midletFieldEditorsMap.values();
                    break;
                }
                case MIDLET: {
                    elementsList = this.libletFieldEditorsMap.values();
                }
            }
            for (FieldEditor element : elementsList) {
                if (element instanceof IntegerFieldEditor) {
                    integerFieldEditorsToExclude.add(element);
                    continue;
                }
                if (!(element instanceof StringFieldEditor)) continue;
                ((StringFieldEditor)element).setStringValue("");
            }
        }
        int i = 0;
        while (i < currentEntriesCount) {
            PushRegEntry def = this.pushRegEntries.get(i);
            store.setValue(PUSH_REGISTRY_PREFIX + (i + 1), def.toString());
            ++i;
        }
        while (i < this.storedEntriesCount) {
            store.setToDefault(PUSH_REGISTRY_PREFIX + (i + 1));
            ++i;
        }
        this.storedEntriesCount = currentEntriesCount;
        super.doSave(monitor);
        for (FieldEditor fieldEditor : integerFieldEditorsToExclude) {
            store.setToDefault(fieldEditor.getPreferenceName());
        }
    }

    public void packagingModelChanged(PackagingModel newPackagingModel) {
        this.changePackagingModel(newPackagingModel);
    }

    private void changePackagingModel(PackagingModel newPackagingModel) {
        if (newPackagingModel != this.packagingModel) {
            int i = 0;
            while (i < MIDLET_LIBLET_KEYS.length) {
                StringFieldEditor midletField = (StringFieldEditor)this.midletFieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][0]);
                StringFieldEditor libletField = (StringFieldEditor)this.libletFieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][1]);
                if (midletField != null && libletField != null) {
                    if (newPackagingModel == PackagingModel.MIDLET) {
                        midletField.setStringValue(libletField.getStringValue());
                    } else {
                        libletField.setStringValue(midletField.getStringValue());
                    }
                }
                ++i;
            }
        }
        this.packagingModel = newPackagingModel;
        if (this.optionalActivePanel != null) {
            ((StackLayout)this.optionalActivePanel.getLayout()).topControl = newPackagingModel == PackagingModel.LIBLET ? this.optionalLibletPanel : this.optionalMidletPanel;
            this.optionalActivePanel.layout();
        }
        if (this.otaActivePanel != null) {
            ((StackLayout)this.otaActivePanel.getLayout()).topControl = newPackagingModel == PackagingModel.LIBLET ? this.otaLibletPanel : this.otaMidletPanel;
            this.otaActivePanel.layout();
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String value = null;
            if (element instanceof PushRegEntry) {
                PushRegEntry entry = (PushRegEntry)element;
                int fieldIndex = this.getFieldIndex(property);
                if (fieldIndex != -1) {
                    value = entry.fields[fieldIndex];
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                String newValue = (String)value;
                if (data instanceof PushRegEntry) {
                    int fieldIndex = this.getFieldIndex(property);
                    PushRegEntry entry = (PushRegEntry)data;
                    if (fieldIndex != -1) {
                        this.updateField(entry, property, fieldIndex, newValue);
                    }
                }
            }
        }

        private int getFieldIndex(String property) {
            return PROPERTY_LIST.indexOf(property);
        }

        private void updateField(PushRegEntry entry, String property, int fieldIndex, String newValue) {
            if (!entry.fields[fieldIndex].equals(newValue)) {
                entry.fields[fieldIndex] = newValue;
                JADOptionalPropertiesEditorPage.this.setDirty(true);
                JADOptionalPropertiesEditorPage.this.tableViewer.update((Object)entry, new String[]{property});
            }
        }
    }

    private class MidletCellEditor
    extends DialogCellEditor {
        MidletCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            String value = null;
            try {
                IType type;
                Object[] results;
                IJavaProject javaProject = JADOptionalPropertiesEditorPage.this.getJavaProject();
                SelectionDialog dialog = MidletSelectionDialogCreator.createMidletSelectionDialog(cellEditorWindow.getShell(), (IRunnableContext)JADOptionalPropertiesEditorPage.this.getSite().getPage().getWorkbenchWindow(), javaProject, false, MTJUIMessages.JADPushRegistryEditorPage_choose_MIDlet);
                if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                    value = type.getFullyQualifiedName();
                }
            }
            catch (JavaModelException e) {
                MTJLogger.log((int)4, (String)"openDialogBox", (Throwable)e);
            }
            return value;
        }
    }

    static class PushRegEntry {
        public String[] fields = new String[3];

        PushRegEntry(String entryString) {
            String[] tokens = entryString.split(",");
            int i = 0;
            while (i < 3) {
                this.fields[i] = i > tokens.length ? "" : tokens[i];
                ++i;
            }
        }

        PushRegEntry(String connStr, String className, String allowedSender) {
            this.fields[0] = connStr;
            this.fields[1] = className;
            this.fields[2] = allowedSender;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.fields != null) {
                int i = 0;
                while (i < this.fields.length) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(this.fields[i]);
                    ++i;
                }
            }
            return sb.toString();
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return JADOptionalPropertiesEditorPage.this.pushRegEntries.toArray(new Object[JADOptionalPropertiesEditorPage.this.pushRegEntries.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((PushRegEntry)element).fields[columnIndex];
        }
    }
}

