/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import org.eclipse.mtj.internal.ui.editors.IModel;
import org.eclipse.mtj.internal.ui.editors.IModelListener;
import org.eclipse.mtj.internal.ui.forms.blocks.NamedObject;

public class MidletsModel
implements IModel {
    private ArrayList<IModelListener> modelListeners = new ArrayList();
    private ArrayList<NamedObject> objects = new ArrayList();

    public MidletsModel(NamedObject[] midlets) {
        this.initialize(midlets);
    }

    public void add(NamedObject[] objs, boolean notify) {
        NamedObject[] namedObjectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            NamedObject element = namedObjectArray[n2];
            this.objects.add(element);
            element.setModel(this);
            ++n2;
        }
        if (notify) {
            this.fireModelChanged(objs, "__added", "");
        }
    }

    public void reorder(NamedObject obj, Direction direction) {
        int i = 0;
        while (i < this.objects.size()) {
            NamedObject target = this.objects.get(i);
            if (target == obj) {
                if (direction == Direction.DOWN && i == this.objects.size() - 1 || direction == Direction.UP && i == 0) {
                    return;
                }
                this.objects.remove(i);
                this.objects.add(i += direction.getValue(), obj);
                this.fireModelChanged(new Object[]{obj}, "__added", "");
                break;
            }
            ++i;
        }
    }

    public void addModelListener(IModelListener listener) {
        if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public void clear() {
        this.objects.clear();
    }

    public void fireModelChanged(Object[] objects, String type, String property) {
        int i = 0;
        while (i < this.modelListeners.size()) {
            this.modelListeners.get(i).modelChanged(objects, type, property);
            ++i;
        }
    }

    public Object[] getContents() {
        return this.objects.toArray();
    }

    public void remove(NamedObject[] objs, boolean notify) {
        NamedObject[] namedObjectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            NamedObject element = namedObjectArray[n2];
            this.objects.remove(element);
            element.setModel(null);
            ++n2;
        }
        if (notify) {
            this.fireModelChanged(objs, "__removed", "");
        }
    }

    public void removeModelListener(IModelListener listener) {
        this.modelListeners.remove(listener);
    }

    private void initialize(NamedObject[] objects) {
        if (objects != null) {
            this.add(objects, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP(-1),
        DOWN(1);

        int value;

        private Direction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

