/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.devices.DeviceSelector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeviceTab
extends AbstractLaunchConfigurationTab {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private DeviceSelector deviceSelector;
    private Text extraParameters;
    private IJavaProject javaProject;
    private Button projectDeviceButton;
    private ComboViewer securityDomainViewer;
    private Button specificDeviceButton;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        IJavaProject currentProject = this.getJavaProjectFrom((ILaunchConfiguration)workingCopy);
        if (currentProject != null || this.javaProject != null) {
            boolean isDifferent;
            boolean bl = isDifferent = currentProject == null && this.javaProject != null || currentProject != null && this.javaProject == null || !currentProject.equals(this.javaProject);
            if (isDifferent) {
                this.javaProject = currentProject;
                this.initializeDeviceFrom((ILaunchConfiguration)workingCopy);
            }
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        Group group = new Group(comp, 32);
        group.setText(MTJUIMessages.DeviceTab_device_group_label_text);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.projectDeviceButton = new Button((Composite)group, 16);
        new Label((Composite)group, 0).setText(MTJUIMessages.DeviceTab_projectDeviceButton_radio_label_text);
        this.specificDeviceButton = new Button((Composite)group, 16);
        new Label((Composite)group, 0).setText(MTJUIMessages.DeviceTab_specificDeviceButton_radio_label_text);
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.createContents((Composite)group, false, true);
        Label securityDomainLabel = new Label(comp, 0);
        securityDomainLabel.setText(MTJUIMessages.DeviceTab_securityDomain_label_text);
        securityDomainLabel.setFont(font);
        this.securityDomainViewer = new ComboViewer(comp, 12);
        this.securityDomainViewer.setContentProvider((IContentProvider)new SecurityDomainContentProvider());
        this.securityDomainViewer.getCombo().setFont(font);
        this.securityDomainViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.securityDomainViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        this.securityDomainViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label extraParamsLabel = new Label(comp, 0);
        extraParamsLabel.setText(MTJUIMessages.DeviceTab_extraParams_label_text);
        extraParamsLabel.setFont(font);
        this.extraParameters = new Text(comp, 2048);
        this.extraParameters.setLayoutData((Object)new GridData(768));
        this.extraParameters.setTextLimit(200);
        this.extraParameters.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectDeviceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceTab.this.deviceSelector.setEnabled(DeviceTab.this.specificDeviceButton.getSelection());
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.specificDeviceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceTab.this.deviceSelector.setEnabled(DeviceTab.this.specificDeviceButton.getSelection());
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeviceTab.this.securityDomainViewer.setInput((Object)DeviceTab.this.deviceSelector.getSelectedDevice());
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public Image getImage() {
        return MTJUIPluginImages.DESC_CELLPHONE_OBJ.createImage();
    }

    public String getName() {
        return MTJUIMessages.DeviceTab_name;
    }

    public void initializeFrom(ILaunchConfiguration launchConfig) {
        this.javaProject = this.getJavaProjectFrom(launchConfig);
        this.initializeDeviceFrom(launchConfig);
        this.securityDomainViewer.setInput((Object)this.getSelectedDevice());
        String domain = this.getStringOrDefault(launchConfig, "mtj.security_domain", "None");
        this.securityDomainViewer.setSelection((ISelection)new StructuredSelection((Object)domain), true);
        String params = this.getStringOrDefault(launchConfig, "mtj.launch_params", "");
        this.extraParameters.setText(params);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean valid = true;
        if (this.getSelectedDevice() == null) {
            this.setErrorMessage(MTJUIMessages.DeviceTab_error_no_device_selected);
            valid = false;
        }
        return valid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute("mtj.use_project_device", this.projectDeviceButton.getSelection());
        if (this.specificDeviceButton.getSelection()) {
            IDevice device = this.deviceSelector.getSelectedDevice();
            String groupName = device == null ? null : device.getSDKName();
            String deviceName = device == null ? null : device.getName();
            launchConfig.setAttribute("mtj.emulated_device_group", groupName);
            launchConfig.setAttribute("mtj.emulated_device", deviceName);
        }
        IStructuredSelection selection = (IStructuredSelection)this.securityDomainViewer.getSelection();
        launchConfig.setAttribute("mtj.security_domain", (String)selection.getFirstElement());
        launchConfig.setAttribute("mtj.launch_params", this.extraParameters.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute("mtj.use_project_device", true);
        launchConfig.setAttribute("mtj.emulated_device_group", "");
        launchConfig.setAttribute("mtj.emulated_device", "");
        launchConfig.setAttribute("mtj.security_domain", "None");
        launchConfig.setAttribute("mtj.launch_params", "");
    }

    private IJavaProject getJavaProjectFrom(ILaunchConfiguration launchConfig) {
        IProject project;
        IJavaProject configProject = null;
        String projectName = "";
        try {
            projectName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException ce) {
            MTJLogger.log((int)2, (String)MTJUIMessages.DeviceTab_error_updating_project_field, (Throwable)ce);
        }
        if (projectName.trim().length() > 1 && (project = MTJCore.getWorkspace().getRoot().getProject(projectName)) != null && project.exists() && project.isOpen()) {
            configProject = JavaCore.create((IProject)project);
        }
        return configProject;
    }

    private IDevice getProjectDevice() {
        IDevice device = null;
        if (this.javaProject != null) {
            IMidletSuiteProject suite = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.javaProject);
            device = suite.getRuntimeList().getActiveMTJRuntime().getDevice();
        }
        return device;
    }

    private IMIDPDevice getSelectedDevice() {
        IMIDPDevice device = null;
        device = this.projectDeviceButton.getSelection() ? (IMIDPDevice)this.getProjectDevice() : (IMIDPDevice)this.deviceSelector.getSelectedDevice();
        return device;
    }

    private String getStringOrDefault(ILaunchConfiguration launchConfig, String attributeName, String defaultValue) {
        String value = null;
        try {
            value = launchConfig.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (Throwable)e);
            value = defaultValue;
        }
        return value;
    }

    private void initializeDeviceFrom(ILaunchConfiguration launchConfig) {
        boolean useProjectDevice = true;
        try {
            useProjectDevice = launchConfig.getAttribute("mtj.use_project_device", true);
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (String)MTJUIMessages.DeviceTab_error_initializePlatformDefinitionFrom, (Throwable)e);
        }
        this.projectDeviceButton.setSelection(useProjectDevice);
        this.deviceSelector.setEnabled(!useProjectDevice);
        this.specificDeviceButton.setSelection(!useProjectDevice);
        IDevice device = null;
        if (useProjectDevice) {
            device = this.getProjectDevice();
        } else {
            String groupName = this.getStringOrDefault(launchConfig, "mtj.emulated_device_group", "");
            String deviceName = this.getStringOrDefault(launchConfig, "mtj.emulated_device", "");
            try {
                device = MTJCore.getDeviceRegistry().getDevice(groupName, deviceName);
            }
            catch (PersistenceException e) {
                MTJLogger.log((int)2, (String)MTJUIMessages.DeviceTab_error_retrieving_devices, (Throwable)e);
            }
        }
        this.deviceSelector.setSelectedDevice(device);
    }

    private class SecurityDomainContentProvider
    implements IStructuredContentProvider {
        private SecurityDomainContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            IMIDPDevice device = (IMIDPDevice)inputElement;
            Object[] elements = device.getProtectionDomains();
            if (elements == null) {
                elements = NO_ELEMENTS;
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

