/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.launching.midp.LaunchingUtils;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.launching.NonJavaLaunchShortcut;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadLaunchShortcut
extends NonJavaLaunchShortcut {
    private IFile jadFile;

    @Override
    protected ILaunchConfiguration createConfiguration() {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getEmulatorConfigType();
            String launchConfigName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(this.jadFile.getName());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchConfigName);
            wc.setAttribute("mtj.do_jad_launch", true);
            String jadFileURL = this.getLaunchingJadFileLocation(this.jadFile);
            wc.setAttribute("mtj.specified_jad_url", jadFileURL);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.jadFile.getProject().getName());
            wc.setAttribute("mtj.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"debug", (String)"perspective_default");
            config = wc.doSave();
        }
        catch (CoreException ce) {
            MTJLogger.log((int)2, (String)"createConfiguration", (Throwable)ce);
        }
        return config;
    }

    private String getLaunchingJadFileLocation(IFile jadFile) {
        IMidletSuiteProject suite = this.getMidletSuiteProject(jadFile);
        IPath launchBasePath = LaunchingUtils.getJadLaunchBasePath((IMTJProject)suite);
        IPath launchingJadPath = launchBasePath.append(jadFile.getName());
        String launchingJadFileLocation = launchingJadPath.toPortableString();
        return launchingJadFileLocation;
    }

    private List<ILaunchConfiguration> getCandidateConfigs(IFile jadFile) {
        ILaunchConfigurationType configType = this.getEmulatorConfigType();
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                boolean doJadLaunch = config.getAttribute("mtj.do_jad_launch", false);
                String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                String jadUrl = config.getAttribute("mtj.specified_jad_url", "");
                if (doJadLaunch && projectName.equals(jadFile.getProject().getName()) && jadUrl.indexOf(jadFile.getName()) >= 0) {
                    candidateConfigs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (String)"getCandidateConfigs", (Throwable)e);
        }
        this.jadFile = jadFile;
        return candidateConfigs;
    }

    private ILaunchConfigurationType getEmulatorConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return configType;
    }

    private IJavaProject getJavaProject(IFile selectedFile) {
        IProject project = selectedFile.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject;
    }

    private IMidletSuiteProject getMidletSuiteProject(IFile selectedFile) {
        IJavaProject javaProject = this.getJavaProject(selectedFile);
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject);
        return midletSuiteProject;
    }

    private IFile getRuntimeJadFile(IMidletSuiteProject suite) {
        IFolder emulationFolder = LaunchingUtils.getEmulationFolder((IMTJProject)suite);
        IFile runtimeJadFile = emulationFolder.getFile(suite.getJadFileName());
        return runtimeJadFile;
    }

    private boolean isProjectJad(IFile receiver) {
        IMidletSuiteProject midletProject = this.getMidletSuiteProject(receiver);
        String jadFileName = midletProject.getJadFileName();
        return jadFileName.equals(receiver.getName());
    }

    @Override
    protected List<ILaunchConfiguration> getLaunchConfigurations(ISelection selection) {
        IFile jadFile = null;
        Object selected = ((IStructuredSelection)selection).getFirstElement();
        if (selected instanceof IFile) {
            jadFile = (IFile)selected;
            if (!this.isProjectJad(jadFile)) {
                IMidletSuiteProject suite = this.getMidletSuiteProject(jadFile);
                jadFile = this.getRuntimeJadFile(suite);
            }
        } else if (selected instanceof IProject) {
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)selected));
            IMidletSuiteProject suite = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject);
            jadFile = this.getRuntimeJadFile(suite);
        } else if (selected instanceof IJavaProject) {
            IMidletSuiteProject suite = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)((IJavaProject)selected));
            jadFile = this.getRuntimeJadFile(suite);
        }
        if (jadFile == null) {
            return null;
        }
        return this.getCandidateConfigs(jadFile);
    }

    @Override
    protected List<ILaunchConfiguration> getLaunchConfigurations(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        IFile jadFile = (IFile)input.getAdapter(IFile.class);
        if (jadFile == null) {
            return null;
        }
        if (!this.isProjectJad(jadFile)) {
            IMidletSuiteProject suite = this.getMidletSuiteProject(jadFile);
            jadFile = this.getRuntimeJadFile(suite);
        }
        return this.getCandidateConfigs(jadFile);
    }
}

