/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistryChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.preferences.SymbolDefinitionsImportWizard;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SymbolDefinitionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.symbolDefinitionsPreferencePage";
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.SymbolDefinitionsPreferencePage_symbolColumnInfo, 50.0f, null), new TableColumnInfo(MTJUIMessages.SymbolDefinitionsPreferencePage_valueColumnInfo, 50.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String PROP_SYMBOL = "symbol";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"symbol", "value"};
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile(".*\\s+.*");
    private Button addSetButton;
    private Button addSymbolButton;
    private ArrayList<ISymbol> currentDefinitions;
    private ComboViewer definitionsComboViewer;
    private ISymbolSet[] definitionSetsinput = null;
    private Button importSetButton;
    private Button removeSetButton;
    private Button removeSymbolButton;
    private Group symbolsGroup;
    private TableViewer tableViewer;
    private IWorkbench workbench;

    public void commitSymbolDefinitions() {
        this.commitSymbolDefinitions(this.getSelectedSymbolDefinitionSet());
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        this.noDefaultAndApplyButton();
    }

    public boolean performCancel() {
        return this.reloadSymbolDefinitionsRegistry() && super.performCancel();
    }

    public boolean performOk() {
        boolean succeeded = false;
        this.commitSymbolDefinitions();
        try {
            MTJCore.getSymbolSetRegistry().store();
            succeeded = true;
        }
        catch (PersistenceException e) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_store_symbol, e);
        }
        catch (TransformerException e) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_store_symbol, e);
        }
        catch (IOException e) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_store_symbol, e);
        }
        return succeeded && super.performOk();
    }

    private void commitSymbolDefinitions(ISymbolSet set) {
        if (set != null) {
            HashMap<String, String> defs = new HashMap<String, String>(this.currentDefinitions.size());
            for (ISymbol def : this.currentDefinitions) {
                defs.put(def.getName(), def.getValue());
            }
            set.setSymbols(defs);
        }
    }

    private TableViewer createTableViewer(Composite composite) {
        int styles = 68100;
        Table table = new Table(composite, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new TableContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SymbolDefinitionLabelProvider());
        viewer.setSorter(new ViewerSorter());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
            }
        });
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings("symbolDefsViewerSettings");
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, 650, COLUMN_INFO, 0);
        viewerConfiguration.configure(viewer);
        viewer.setCellModifier((ICellModifier)new CellModifier());
        viewer.setColumnProperties(PROPERTIES);
        viewer.setCellEditors(new CellEditor[]{new SymbolNameCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        return viewer;
    }

    private ISymbol getSelectedSymbolDefinition() {
        ISymbol definition = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection != null) {
            definition = (ISymbol)selection.getFirstElement();
        }
        return definition;
    }

    private ISymbolSet getSelectedSymbolDefinitionSet() {
        ISymbolSet set = null;
        IStructuredSelection selection = (IStructuredSelection)this.definitionsComboViewer.getSelection();
        set = selection.size() == 0 ? null : (ISymbolSet)selection.getFirstElement();
        return set;
    }

    private void handleAddSetButton() {
        try {
            String typedSetName = this.definitionsComboViewer.getCombo().getText();
            ISymbolSet typedSet = null;
            try {
                typedSet = MTJCore.getSymbolSetRegistry().getSymbolSet(typedSetName);
            }
            catch (PersistenceException persistenceException) {}
            ISymbolSet selectedSet = this.getSelectedSymbolDefinitionSet();
            if (!this.isValidSetName(typedSetName) || selectedSet != null || typedSet != null) {
                this.setErrorMessage(MTJUIMessages.SymbolDefinitionsPreferencePage_invalidSymbolSetName);
                return;
            }
            this.setErrorMessage(null);
            ISymbolSet set = MTJCore.getSymbolSetFactory().createSymbolSet(typedSetName);
            MTJCore.getSymbolSetRegistry().addSymbolSet(set);
            this.definitionsComboViewer.refresh();
            this.definitionsComboViewer.setSelection((ISelection)new StructuredSelection((Object)set));
            this.tableViewer.setInput((Object)set);
        }
        catch (PersistenceException e) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_add_symbol, e);
        }
    }

    private void handleAddSymbolButton() {
        String symbolName = "NewSymbol";
        ISymbol symbolDefinition = null;
        int i = 1;
        while (i < 100) {
            symbolName = "NewSymbol" + i;
            symbolDefinition = MTJCore.getSymbolSetFactory().createSymbol(symbolName, "true");
            if (!this.currentDefinitions.contains(symbolDefinition)) {
                this.currentDefinitions.add(symbolDefinition);
                break;
            }
            ++i;
        }
        this.tableViewer.refresh();
        TableItem[] items = this.tableViewer.getTable().getItems();
        int pos = 0;
        while (pos < items.length) {
            if (symbolDefinition.equals(items[pos].getData())) break;
            ++pos;
        }
        this.tableViewer.getTable().select(pos);
        this.tableViewer.getTable().forceFocus();
    }

    private void handleException(String message, Throwable t) {
        MTJLogger.log((int)2, (String)message, (Throwable)t);
        MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)MTJUIMessages.SymbolDefinitionsPreferencePage_handleException_dialog_title, (String)message);
    }

    private void handleImportSetButton() {
        SymbolDefinitionsImportWizard wizard = new SymbolDefinitionsImportWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.definitionsComboViewer.refresh();
        }
    }

    private void handleRemoveSetButton() {
        ISymbolSet set = this.getSelectedSymbolDefinitionSet();
        if (set != null) {
            MTJCore.getSymbolSetRegistry().removeSymbolSet(set.getName());
            this.definitionsComboViewer.refresh();
            this.tableViewer.refresh();
        }
    }

    private void handleRemoveSymbolButton() {
        TableItem[] selected;
        Table table = this.tableViewer.getTable();
        TableItem[] tableItemArray = selected = table.getSelection();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            this.currentDefinitions.remove(tableItem.getData());
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private void initializeDefinitionsCombo() {
        Object inputObject = new Object();
        this.definitionsComboViewer.setInput(inputObject);
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.definitionsComboViewer.getContentProvider();
        Object[] content = contentProvider.getElements(inputObject);
        if (content != null && content.length > 0) {
            this.definitionsComboViewer.setSelection((ISelection)new StructuredSelection(content[0]), true);
        }
    }

    private boolean isValidSetName(String name) {
        boolean isValid = name != null && name.trim().length() > 0;
        int i = 0;
        while (isValid && i < name.length()) {
            char c = name.charAt(i);
            isValid = c == ' ' || Character.isLetterOrDigit(c);
            ++i;
        }
        return isValid;
    }

    private boolean isValidSymbol(String symbol) {
        boolean valid = false;
        if (symbol != null) {
            Matcher matcher = WHITESPACE_PATTERN.matcher(symbol);
            valid = !matcher.matches();
        }
        return valid;
    }

    private boolean reloadSymbolDefinitionsRegistry() {
        boolean succeeded = true;
        try {
            MTJCore.getSymbolSetRegistry().load();
        }
        catch (PersistenceException e) {
            succeeded = false;
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_reloading_symbol_definitions, e);
        }
        return succeeded;
    }

    private void updateButtonEnablement() {
        ISymbolSet selectedSet = this.getSelectedSymbolDefinitionSet();
        this.removeSetButton.setEnabled(selectedSet != null);
        ISymbol selectedDefinition = this.getSelectedSymbolDefinition();
        this.addSymbolButton.setEnabled(selectedSet != null);
        this.removeSymbolButton.setEnabled(selectedDefinition != null);
    }

    protected Control createContents(Composite parent) {
        try {
            this.definitionSetsinput = MTJCore.getSymbolSetRegistry().getAllSymbolSets();
        }
        catch (PersistenceException e1) {
            this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_retrieving_symbol_definitions, e1);
        }
        MTJCore.getSymbolSetRegistry().addSymbolSetRegistryChangeListener(new ISymbolSetRegistryChangeListener(){

            public void symbolSetRegistryChanged() {
                try {
                    SymbolDefinitionsPreferencePage.this.definitionSetsinput = MTJCore.getSymbolSetRegistry().getAllSymbolSets();
                    if (SymbolDefinitionsPreferencePage.this.definitionsComboViewer != null && !SymbolDefinitionsPreferencePage.this.definitionsComboViewer.getControl().isDisposed() && SymbolDefinitionsPreferencePage.this.workbench.getActiveWorkbenchWindow() != null) {
                        SymbolDefinitionsPreferencePage.this.definitionsComboViewer.refresh();
                    }
                }
                catch (PersistenceException e) {
                    SymbolDefinitionsPreferencePage.this.handleException(MTJUIMessages.SymbolDefinitionsPreferencePage_error_retrieving_symbol_definitions, e);
                }
            }
        });
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        Composite nameComposite = new Composite(composite, 0);
        nameComposite.setLayout((Layout)new GridLayout(3, false));
        nameComposite.setLayoutData((Object)new GridData(768));
        new Label(nameComposite, 0).setText(MTJUIMessages.SymbolDefinitionsPreferencePage_def_set_label_text);
        this.definitionsComboViewer = new ComboViewer(nameComposite, 4);
        this.definitionsComboViewer.setContentProvider((IContentProvider)new DefinitionSetsContentProvider());
        this.definitionsComboViewer.setLabelProvider((IBaseLabelProvider)new DefinitionSetLabelProvider());
        this.definitionsComboViewer.setInput((Object)this.definitionSetsinput);
        this.definitionsComboViewer.setSorter(new ViewerSorter());
        GridData gd = new GridData(768);
        gd.verticalAlignment = 0x1000000;
        this.definitionsComboViewer.getCombo().setLayoutData((Object)gd);
        this.definitionsComboViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
                SymbolDefinitionsPreferencePage.this.setErrorMessage(null);
            }
        });
        Composite nameButtonComposite = new Composite(nameComposite, 0);
        nameButtonComposite.setLayout((Layout)new GridLayout(1, true));
        this.addSetButton = new Button(nameButtonComposite, 8);
        this.addSetButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_addSetButton);
        this.addSetButton.setLayoutData((Object)new GridData(768));
        this.addSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SymbolDefinitionsPreferencePage.this.handleAddSetButton();
            }
        });
        this.addSetButton.setEnabled(true);
        this.removeSetButton = new Button(nameButtonComposite, 8);
        this.removeSetButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_removeSetButton);
        this.removeSetButton.setLayoutData((Object)new GridData(768));
        this.removeSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SymbolDefinitionsPreferencePage.this.handleRemoveSetButton();
            }
        });
        this.removeSetButton.setEnabled(false);
        this.importSetButton = new Button(nameButtonComposite, 8);
        this.importSetButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_ImportButton);
        this.importSetButton.setLayoutData((Object)new GridData(768));
        this.importSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SymbolDefinitionsPreferencePage.this.handleImportSetButton();
            }
        });
        this.symbolsGroup = new Group(composite, 4);
        this.symbolsGroup.setLayout((Layout)new GridLayout(2, false));
        this.symbolsGroup.setLayoutData((Object)new GridData(1808));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 400;
        gridData.heightHint = 300;
        this.tableViewer = this.createTableViewer((Composite)this.symbolsGroup);
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        Composite symbolsButtonComposite = new Composite((Composite)this.symbolsGroup, 0);
        symbolsButtonComposite.setLayout((Layout)new GridLayout(1, true));
        this.addSymbolButton = new Button(symbolsButtonComposite, 8);
        this.addSymbolButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_addSymbolButton);
        this.addSymbolButton.setLayoutData((Object)new GridData(768));
        this.addSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SymbolDefinitionsPreferencePage.this.handleAddSymbolButton();
            }
        });
        this.addSymbolButton.setEnabled(false);
        this.removeSymbolButton = new Button(symbolsButtonComposite, 8);
        this.removeSymbolButton.setText(MTJUIMessages.SymbolDefinitionsPreferencePage_removeSymbolButton);
        this.removeSymbolButton.setLayoutData((Object)new GridData(768));
        this.removeSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SymbolDefinitionsPreferencePage.this.handleRemoveSymbolButton();
            }
        });
        this.removeSymbolButton.setEnabled(false);
        this.definitionsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
                ISymbolSet set = SymbolDefinitionsPreferencePage.this.getSelectedSymbolDefinitionSet();
                SymbolDefinitionsPreferencePage.this.tableViewer.setInput((Object)set);
            }
        });
        this.initializeDefinitionsCombo();
        return composite;
    }

    protected void performDefaults() {
        this.reloadSymbolDefinitionsRegistry();
        this.initializeDefinitionsCombo();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String value = null;
            ISymbol def = (ISymbol)element;
            value = property.equals(SymbolDefinitionsPreferencePage.PROP_SYMBOL) ? def.getName() : def.getValue();
            return value;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            String symbolName = item.getText(0);
            String currentValue = item.getText(1);
            int itemIndex = this.findSymbolDefinition(symbolName);
            if (itemIndex != -1) {
                if (property.equals(SymbolDefinitionsPreferencePage.PROP_SYMBOL)) {
                    String newSymbol = (String)value;
                    if (SymbolDefinitionsPreferencePage.this.isValidSymbol(newSymbol)) {
                        ISymbol s = MTJCore.getSymbolSetFactory().createSymbol(newSymbol, currentValue);
                        SymbolDefinitionsPreferencePage.this.currentDefinitions.set(itemIndex, s);
                    }
                } else {
                    ISymbol def = (ISymbol)SymbolDefinitionsPreferencePage.this.currentDefinitions.get(itemIndex);
                    def.setValue((String)value);
                }
                SymbolDefinitionsPreferencePage.this.tableViewer.refresh();
            }
            SymbolDefinitionsPreferencePage.this.setErrorMessage(null);
        }

        private int findSymbolDefinition(String name) {
            int index = -1;
            int i = 0;
            while (i < SymbolDefinitionsPreferencePage.this.currentDefinitions.size()) {
                ISymbol def = (ISymbol)SymbolDefinitionsPreferencePage.this.currentDefinitions.get(i);
                if (def.getName().equals(name)) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }
    }

    private static class DefinitionSetLabelProvider
    extends LabelProvider {
        private DefinitionSetLabelProvider() {
        }

        public String getText(Object element) {
            return ((ISymbolSet)element).getName();
        }
    }

    private class DefinitionSetsContentProvider
    implements IStructuredContentProvider {
        private DefinitionSetsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] definitions = NO_ELEMENTS;
            if (SymbolDefinitionsPreferencePage.this.definitionSetsinput != null) {
                definitions = SymbolDefinitionsPreferencePage.this.definitionSetsinput;
            }
            return definitions;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class SymbolDefinitionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SymbolDefinitionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            ISymbol def = (ISymbol)element;
            switch (columnIndex) {
                case 0: {
                    text = def.getName();
                    break;
                }
                case 1: {
                    text = def.getValue();
                }
            }
            return text;
        }
    }

    private class SymbolNameCellEditor
    extends TextCellEditor {
        public SymbolNameCellEditor(Composite parent) {
            super(parent);
            this.setValidator(new SymbolNameCellEditorValidator());
            this.addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                }

                public void cancelEditor() {
                }

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (!newValidState) {
                        SymbolNameCellEditor.this.setErrorMessage(SymbolNameCellEditor.this.getErrorMessage());
                    } else {
                        SymbolNameCellEditor.this.setErrorMessage(null);
                    }
                }
            });
        }
    }

    private class SymbolNameCellEditorValidator
    implements ICellEditorValidator {
        private SymbolNameCellEditorValidator() {
        }

        public String isValid(Object value) {
            String symbol = (String)value;
            return SymbolDefinitionsPreferencePage.this.isValidSymbol(symbol) ? null : MTJUIMessages.SymbolDefinitionsPreferencePage_invalid_symbol;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return SymbolDefinitionsPreferencePage.this.currentDefinitions.toArray(new Object[SymbolDefinitionsPreferencePage.this.currentDefinitions.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ISymbolSet set;
            Collection symbols;
            if (oldInput != null) {
                SymbolDefinitionsPreferencePage.this.commitSymbolDefinitions((ISymbolSet)oldInput);
            }
            if (SymbolDefinitionsPreferencePage.this.currentDefinitions == null) {
                SymbolDefinitionsPreferencePage.this.currentDefinitions = new ArrayList();
            } else {
                SymbolDefinitionsPreferencePage.this.currentDefinitions.clear();
            }
            if (newInput instanceof ISymbolSet && (symbols = (set = (ISymbolSet)newInput).getSymbols()) != null) {
                SymbolDefinitionsPreferencePage.this.symbolsGroup.setText(NLS.bind((String)MTJUIMessages.SymbolDefinitionsPreferencePage_symbolsGroup_label_text, (Object)set.getName()));
                for (ISymbol s : symbols) {
                    SymbolDefinitionsPreferencePage.this.currentDefinitions.add(s);
                }
            }
        }
    }
}

