/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessContentAssistModel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessDirectiveProvider;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessCompletionProposal;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContentAssistMessages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessDebugLevel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessDirective;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbol;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbolManager;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessCompletionEngine {
    public List<PreprocessCompletionProposal> completeDebugLevel(PreprocessContext ppContext) {
        PreprocessDebugLevel[] levels;
        ArrayList<PreprocessCompletionProposal> result = new ArrayList<PreprocessCompletionProposal>();
        PreprocessDebugLevel[] preprocessDebugLevelArray = levels = this.getSupportDebuglevels();
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            PreprocessDebugLevel level = preprocessDebugLevelArray[n2];
            if (ppContext.accept(level)) {
                result.add(this.constructPreprocessProposal(ppContext, level, MTJUIPluginImages.DESC_PREPROCESS_SYMBOL_ASSIST.createImage()));
            }
            ++n2;
        }
        return result;
    }

    private PreprocessDebugLevel[] getSupportDebuglevels() {
        PreprocessDebugLevel[] levels = new PreprocessDebugLevel[]{new PreprocessDebugLevel("debug", PreprocessContentAssistMessages.dl_debug_desc), new PreprocessDebugLevel("error", PreprocessContentAssistMessages.dl_error_desc), new PreprocessDebugLevel("fatal", PreprocessContentAssistMessages.dl_fatal_desc), new PreprocessDebugLevel("info", PreprocessContentAssistMessages.dl_info_desc), new PreprocessDebugLevel("warn", PreprocessContentAssistMessages.dl_warn_desc)};
        return levels;
    }

    public List<PreprocessCompletionProposal> completeDirective(PreprocessContext ppContext) {
        PreprocessDirective[] directives;
        ArrayList<PreprocessCompletionProposal> result = new ArrayList<PreprocessCompletionProposal>();
        IPreprocessDirectiveProvider directiveProvider = ppContext.getDirectiveProvider();
        PreprocessDirective[] preprocessDirectiveArray = directives = directiveProvider.getAllDirectives();
        int n = directives.length;
        int n2 = 0;
        while (n2 < n) {
            PreprocessDirective directive = preprocessDirectiveArray[n2];
            if (ppContext.accept(directive)) {
                result.add(this.constructPreprocessProposal(ppContext, directive, MTJUIPluginImages.DESC_PREPROCESS_DIRECTIVE_ASSIST.createImage()));
            }
            ++n2;
        }
        return result;
    }

    public List<PreprocessCompletionProposal> completeSymbol(PreprocessContext ppContext) {
        ArrayList<PreprocessCompletionProposal> result = new ArrayList<PreprocessCompletionProposal>();
        List<PreprocessSymbol> symbols = PreprocessSymbolManager.getSymbols(ppContext.getContainedProject());
        for (PreprocessSymbol symbol : symbols) {
            if (!ppContext.accept(symbol)) continue;
            result.add(this.constructPreprocessProposal(ppContext, symbol, MTJUIPluginImages.DESC_PREPROCESS_SYMBOL_ASSIST.createImage()));
        }
        return result;
    }

    private PreprocessCompletionProposal constructPreprocessProposal(PreprocessContext ppContext, IPreprocessContentAssistModel model, Image image) {
        return new PreprocessCompletionProposal(model, ppContext, image);
    }
}

