/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessCompletionEngine;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.ProposalType;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateAccess;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateContextType;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessProposalComputer
implements IJavaCompletionProposalComputer {
    private PreprocessTemplateEngine tmplateEngine;
    private PreprocessCompletionEngine pPEngine = new PreprocessCompletionEngine();

    public PreprocessProposalComputer() {
        PreprocessTemplateContextType contextType = (PreprocessTemplateContextType)PreprocessTemplateAccess.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.mtj.preprocess");
        this.tmplateEngine = new PreprocessTemplateEngine(contextType);
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        IProject project = javaContext.getCompilationUnit().getJavaProject().getProject();
        int offset = context.getInvocationOffset();
        IDocument doc = context.getDocument();
        PreprocessContext ppContext = new PreprocessContext(doc, offset, project);
        ArrayList<ICompletionProposal> resultProposals = new ArrayList<ICompletionProposal>();
        for (ProposalType propsalType : ppContext.getPossibleProposalTypes()) {
            switch (propsalType) {
                case DIRECTIVE: {
                    resultProposals.addAll(this.pPEngine.completeDirective(ppContext));
                    break;
                }
                case SYMBOL: {
                    resultProposals.addAll(this.pPEngine.completeSymbol(ppContext));
                    break;
                }
                case DEBUG_LEVER: {
                    resultProposals.addAll(this.pPEngine.completeDebugLevel(ppContext));
                    break;
                }
                case TEMPLATE: {
                    resultProposals.addAll(this.tmplateEngine.complete(ppContext));
                }
            }
        }
        return resultProposals;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

