/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.templates.midlets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplate;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MIDletTemplateBuffer {
    private MIDletTemplate template;
    private Map<String, String> templateBuffers;
    private Map<String, String> dictionary;
    private String packageName;
    private String clazzName;

    public static MIDletTemplateBuffer createTemplateBuffer(MIDletTemplate template, Map<String, String> dictionary, String packageName, String clazzname) {
        MIDletTemplateBuffer buffer = new MIDletTemplateBuffer(template, dictionary);
        buffer.clazzName = clazzname;
        buffer.packageName = packageName;
        try {
            buffer.initBuffer();
        }
        catch (IOException iOException) {
            return null;
        }
        return buffer;
    }

    public Map<String, String> getTemplateBuffers() {
        return this.templateBuffers;
    }

    private MIDletTemplateBuffer(MIDletTemplate template, Map<String, String> dictionary) {
        this.template = template;
        this.dictionary = dictionary;
        this.templateBuffers = new HashMap<String, String>();
    }

    private void initBuffer() throws IOException {
        Object bundleObj = null;
        File file = FileLocator.getBundleFile((Bundle)this.template.getBundle());
        if (!file.isDirectory()) {
            bundleObj = new ZipFile(file);
            this.processTemplateFiles((ZipFile)bundleObj);
        } else {
            bundleObj = file;
            this.processTemplateFiles((File)bundleObj);
        }
    }

    private void processTemplateFiles(File folder) throws IOException {
        String path = NLS.bind((String)"templates/{0}/java", (Object)this.template.getId());
        File javaFolder = new File(folder, path);
        if (javaFolder.exists() && javaFolder.isDirectory()) {
            File[] files;
            File[] fileArray = files = javaFolder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && Pattern.matches(".+[.template]", file.getName())) {
                    this.templateBuffers.put(file.getName(), this.processTemplate(new FileInputStream(file)));
                }
                ++n2;
            }
        }
    }

    private void processTemplateFiles(ZipFile zipFile) throws IOException {
        String expression = NLS.bind((String)"templates/{0}/java/.+[.]template", (Object)this.template.getId());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!Pattern.matches(expression, entry.getName())) continue;
            Path path = new Path(entry.getName());
            this.templateBuffers.put(path.lastSegment(), this.processTemplate(zipFile.getInputStream(entry)));
        }
    }

    private String processTemplate(InputStream in) throws IOException {
        BufferedReader reader = null;
        StringBuffer buffer = null;
        reader = new BufferedReader(new InputStreamReader(in));
        buffer = new StringBuffer();
        if (this.packageName != null && this.packageName.length() > 0) {
            buffer.append(NLS.bind((String)"package {0};\n", (Object)this.packageName));
        }
        String line = null;
        while ((line = reader.readLine()) != null) {
            buffer.append(line).append("\n");
        }
        reader.close();
        String content = buffer.toString();
        content = content.replace("$class_name$", this.clazzName);
        for (String key : this.dictionary.keySet()) {
            content = content.replace(key, this.dictionary.get(key));
        }
        return content;
    }
}

