/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.export.antenna;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.export.AntennaBuildExport;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.wizards.export.antenna.AntennaBuildFileExportPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class AntennaBuildFileExportWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection fSelection;
    private AntennaBuildFileExportPage page;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(MTJUIMessages.AntennaBuildFileExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MTJUIPluginImages.DESC_ANTENNA_EXPORT_WIZ);
        this.setNeedsProgressMonitor(true);
        this.fSelection = selection;
    }

    public void addPages() {
        this.page = new AntennaBuildFileExportPage();
        List projects = this.fSelection.toList();
        this.page.setSelectedProjects(projects);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final IMidletSuiteProject midletProject = this.page.getMidletProject();
        final String buildFile = this.page.getBuildFileName();
        final String buildDirectory = this.page.getBuildDirectory();
        if (midletProject == null) {
            return false;
        }
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AntennaBuildExport export = new AntennaBuildExport(midletProject, buildFile, buildDirectory);
                    try {
                        export.doExport(monitor);
                    }
                    catch (AntennaExportException e) {
                        MTJUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MTJUIPlugin.getPluginId(), "Failed to export Antenna build files", (Throwable)e));
                    }
                }
            });
        }
        catch (Exception e) {
            MTJUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MTJUIPlugin.getPluginId(), "Failed to export Antenna build files", (Throwable)e));
        }
        return true;
    }
}

