/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ArchiveUtils;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectRecord;
import org.eclipse.mtj.internal.ui.wizards.importer.common.StatusUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectImporter {
    protected Set<String> skipFolders = new HashSet<String>();

    public ProjectRecord[] searchProjectsFromProvider(ILeveledImportStructureProvider structureProvider, IProgressMonitor monitor) {
        ArrayList<ProjectRecord> collected = new ArrayList<ProjectRecord>();
        Object child = structureProvider.getRoot();
        this.collectProjectsFromProvider(collected, child, structureProvider, monitor);
        return collected.toArray(new ProjectRecord[0]);
    }

    public ProjectRecord[] searchProjectsFromDirectory(File directory, IProgressMonitor monitor) {
        ArrayList<ProjectRecord> collected = new ArrayList<ProjectRecord>();
        this.collectProjectsFromDirectory(collected, directory, new HashSet<String>(), monitor);
        return collected.toArray(new ProjectRecord[0]);
    }

    private void collectProjectsFromDirectory(Collection<ProjectRecord> projects, File root, Set<String> directoriesVisited, IProgressMonitor monitor) {
        ProjectRecord project;
        if (monitor == null || monitor.isCanceled() || !root.isDirectory()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setTaskName(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)root.getPath()));
        try {
            directoriesVisited.add(root.getCanonicalPath());
        }
        catch (IOException exception) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), exception));
        }
        File projectDescriptor = new File(root, this.getProjectDescriptorFile());
        if (projectDescriptor.exists() && (project = this.createProjectRecord(root.getAbsolutePath(), null)) != null) {
            projects.add(project);
            progress.done();
            return;
        }
        File[] nestedFolders = root.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        progress.setWorkRemaining(nestedFolders.length);
        File[] fileArray = nestedFolders;
        int n = nestedFolders.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                File newRoot = fileArray[n2];
                if (!this.skipFolders.contains(newRoot.getName())) {
                    block8: {
                        try {
                            String canonicalPath = newRoot.getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block8;
                            break block9;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), exception));
                        }
                    }
                    this.collectProjectsFromDirectory(projects, newRoot, directoriesVisited, (IProgressMonitor)progress.newChild(1));
                }
            }
            ++n2;
        }
        progress.done();
    }

    protected abstract ProjectRecord createProjectRecord(String var1, ILeveledImportStructureProvider var2);

    public abstract String getProjectDescriptorFile();

    private void collectProjectsFromProvider(Collection<ProjectRecord> projects, Object entry, ILeveledImportStructureProvider structureProvider, IProgressMonitor monitor) {
        ProjectRecord project;
        if (monitor == null || monitor.isCanceled()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setTaskName(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)structureProvider.getLabel(entry)));
        Object projectDescriptor = ArchiveUtils.getChild(structureProvider, entry, this.getProjectDescriptorFile());
        if (projectDescriptor != null && (project = this.createProjectRecord(structureProvider.getFullPath(entry), structureProvider)) != null) {
            projects.add(project);
            progress.done();
            return;
        }
        Object[] nestedFolders = ArchiveUtils.listSubfolders(structureProvider, entry);
        progress.setWorkRemaining(nestedFolders.length);
        Object[] objectArray = nestedFolders;
        int n = nestedFolders.length;
        int n2 = 0;
        while (n2 < n) {
            Object newRoot = objectArray[n2];
            if (!this.skipFolders.contains(structureProvider.getLabel(newRoot))) {
                this.collectProjectsFromProvider(projects, newRoot, structureProvider, (IProgressMonitor)progress.newChild(1));
            }
            ++n2;
        }
        progress.done();
    }

    public abstract void projectCreated(ProjectRecord var1, IProject var2, IProgressMonitor var3) throws CoreException;

    public abstract IDevice getProjectDevice(ProjectRecord var1) throws CoreException;
}

