/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SrcFolderFilter;
import org.eclipse.mtj.internal.ui.util.FolderValidator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LocalizationBlock
implements MouseListener {
    private Composite composite;
    private Button dstFolderButton;
    private Text dstFolderText;
    private IJavaElement jPackage;
    private IJavaProject jProject;
    private IResource jSource;
    private Button pkgFolderButton;
    private Text pkgFolderText;
    private IWizardContainer wizard;

    public LocalizationBlock(IJavaProject project, IWizardContainer wizard) {
        this.jProject = project;
        this.wizard = wizard;
    }

    public Composite createMainComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.composite.setLayout((Layout)layout);
        Label dstFolderLabel = new Label(this.composite, 0);
        dstFolderLabel.setText(MTJUIMessages.LocalizationBlock_DestinationFolder);
        this.dstFolderText = new Text(this.composite, 2048);
        this.dstFolderText.setEnabled(false);
        this.dstFolderButton = new Button(this.composite, 0);
        this.dstFolderButton.setText(MTJUIMessages.LocalizationBlock_Browse);
        this.dstFolderButton.addMouseListener((MouseListener)this);
        Label packageFolderLabel = new Label(this.composite, 0);
        packageFolderLabel.setText(MTJUIMessages.LocalizationBlock_PackageName);
        this.pkgFolderText = new Text(this.composite, 2048);
        this.pkgFolderText.setEnabled(false);
        this.pkgFolderButton = new Button(this.composite, 0);
        this.pkgFolderButton.setText(MTJUIMessages.LocalizationBlock_Browse);
        this.pkgFolderButton.addMouseListener((MouseListener)this);
        Dialog.applyDialogFont((Control)this.composite);
        int srcLabelWidth = this.getWidgetTextWidth((Control)dstFolderLabel, dstFolderLabel.getText());
        int pkgLabelWidth = this.getWidgetTextWidth((Control)packageFolderLabel, packageFolderLabel.getText());
        GridData data = new GridData();
        data.widthHint = Math.max(srcLabelWidth, pkgLabelWidth);
        dstFolderLabel.setLayoutData((Object)data);
        packageFolderLabel.setLayoutData((Object)data);
        data = new GridData(768);
        this.dstFolderText.setLayoutData((Object)data);
        this.pkgFolderText.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = this.getWidgetTextWidth((Control)this.dstFolderButton, this.dstFolderButton.getText()) + 20;
        this.dstFolderButton.setLayoutData((Object)data);
        this.pkgFolderButton.setLayoutData((Object)data);
        return this.composite;
    }

    public Composite getControl() {
        return this.composite;
    }

    public IResource getDestination() {
        return this.jSource;
    }

    public IJavaElement getPackage() {
        return this.jPackage;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent event) {
        if (event.getSource() == this.dstFolderButton) {
            this.selectDestinationFolder();
        } else if (event.getSource() == this.pkgFolderButton) {
            this.selectPackageFolder();
        }
        this.wizard.updateButtons();
    }

    private int getWidgetTextWidth(Control control, String text) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        return gc.stringExtent((String)text).x;
    }

    private void selectDestinationFolder() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.dstFolderButton.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FolderValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(MTJUIMessages.LocalizationBlock_DestinationFolderTitle);
        dialog.setMessage(MTJUIMessages.LocalizationBlock_DestinationFolderMessage);
        try {
            dialog.addFilter((ViewerFilter)new SrcFolderFilter(this.jProject.getProject(), Utils.getJavaProjectSourceDirectories((IJavaProject)this.jProject)));
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        dialog.setInput((Object)MTJUIPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IResource folder;
            this.jSource = folder = (IResource)dialog.getFirstResult();
            this.dstFolderText.setText(folder.getProjectRelativePath().toString());
        }
    }

    private void selectPackageFolder() {
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createPackageDialog((Shell)this.dstFolderButton.getShell(), (IJavaProject)this.jProject, (int)0);
            dialog.setMessage(MTJUIMessages.LocalizationBlock_PackageDialogMessage);
            dialog.setTitle(MTJUIMessages.LocalizationBlock_PackageDialogTitle);
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0) {
                this.jPackage = (IPackageFragment)dialog.getResult()[0];
                String defaultPackage = "(Default Package)";
                if (this.jPackage.getElementName().equals("")) {
                    this.pkgFolderText.setText(defaultPackage);
                } else {
                    this.pkgFolderText.setText(this.jPackage.getElementName());
                }
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }
}

