/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationData;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationWizardPage1;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class StringLocalizationWizard
extends Wizard {
    private StringLocalizationWizardPage1 page1;
    private ICompilationUnit target;
    private L10nModel model;

    public StringLocalizationWizard(ICompilationUnit _class, L10nModel _model) {
        if (_class == null) {
            throw new IllegalArgumentException(MTJUIMessages.StringLocalizationWizard_classCanNotBeNull);
        }
        if (_model == null) {
            throw new IllegalArgumentException(MTJUIMessages.StringLocalizationWizard_l10nModelCanNotBeNull);
        }
        this.target = _class;
        this.model = _model;
        this.setWindowTitle(MTJUIMessages.StringLocalizationWizard_dialogTitle);
    }

    public boolean performFinish() {
        block4: {
            if (this.model.getLocales().getChildCount() != 0) break block4;
            return false;
        }
        try {
            StringLocalizationData[] externalized = this.page1.getExternalizedStrings();
            StringLocalizationData[] ignored = this.page1.getIgnoredStrings();
            if (externalized.length > 0 || ignored.length > 0) {
                this.updateLocalizationData(this.model, externalized);
                this.updateClassFile(this.model, externalized, ignored);
                return true;
            }
        }
        catch (Exception e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        return false;
    }

    private void updateClassFile(L10nModel model, StringLocalizationData[] externalized, StringLocalizationData[] ignored) throws CoreException {
        IType type;
        IField field;
        ReplaceEdit edit;
        String value;
        IRegion region;
        StringLocalizationData stringData;
        IImportDeclaration iimport = null;
        String ppackage = null;
        NullProgressMonitor monitor = new NullProgressMonitor();
        L10nLocales locales = model.getLocales();
        MultiTextEdit multiEdit = new MultiTextEdit();
        StringLocalizationData[] stringLocalizationDataArray = externalized;
        int n = externalized.length;
        int n2 = 0;
        while (n2 < n) {
            stringData = stringLocalizationDataArray[n2];
            region = stringData.getRegion();
            value = NLS.bind((String)"l10n.getString(L10nConstants.keys.{0})", (Object)stringData.getKey().toUpperCase());
            edit = new ReplaceEdit(region.getOffset(), region.getLength(), value);
            multiEdit.addChild((TextEdit)edit);
            ++n2;
        }
        stringLocalizationDataArray = ignored;
        n = ignored.length;
        n2 = 0;
        while (n2 < n) {
            stringData = stringLocalizationDataArray[n2];
            region = stringData.getRegion();
            value = NLS.bind((String)"\"{0}\"{1}", (Object[])new String[]{stringData.getValue(), "/**$NON-NLS**/"});
            edit = new ReplaceEdit(region.getOffset(), region.getLength(), value);
            multiEdit.addChild((TextEdit)edit);
            ++n2;
        }
        this.target.applyTextEdit((TextEdit)multiEdit, (IProgressMonitor)monitor);
        ppackage = locales.getPackage();
        if (ppackage.length() > 0) {
            ppackage = String.valueOf(ppackage) + ".";
        }
        if (!(iimport = this.target.getImport(NLS.bind((String)"{0}L10nResources", (Object)ppackage))).exists()) {
            this.target.createImport(NLS.bind((String)"{0}L10nResources", (Object)ppackage), null, (IProgressMonitor)monitor);
        }
        if (!(iimport = this.target.getImport(NLS.bind((String)"{0}L10nConstants", (Object)ppackage))).exists()) {
            this.target.createImport(NLS.bind((String)"{0}L10nConstants", (Object)ppackage), null, (IProgressMonitor)monitor);
        }
        if (!(field = (type = this.target.findPrimaryType()).getField("l10n")).exists()) {
            type.createField("L10nResources l10n = L10nResources.getL10nResources(null);", null, true, (IProgressMonitor)monitor);
        }
        this.target.save((IProgressMonitor)monitor, true);
    }

    private void updateLocalizationData(L10nModel model, StringLocalizationData[] stringsData) throws CoreException {
        IDocumentElementNode[] children;
        L10nLocales locales = model.getLocales();
        IDocumentElementNode[] iDocumentElementNodeArray = children = locales.getChildNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode child = iDocumentElementNodeArray[n2];
            L10nLocale locale = (L10nLocale)child;
            StringLocalizationData[] stringLocalizationDataArray = stringsData;
            int n3 = stringsData.length;
            int n4 = 0;
            while (n4 < n3) {
                StringLocalizationData data = stringLocalizationDataArray[n4];
                L10nEntry entry = locale.getEntry(data.getKey());
                if (entry == null) {
                    entry = new L10nEntry(model);
                    entry.setKey(data.getKey());
                    locale.addChild((L10nObject)entry);
                }
                entry.setValue(data.getValue());
                ++n4;
            }
            ++n2;
        }
        model.save();
        L10nApi.syncronizeApi((L10nModel)model);
    }

    public void addPages() {
        try {
            String name = this.target.getElementName();
            IBuffer buffer = this.target.getBuffer();
            this.page1 = new StringLocalizationWizardPage1(name, buffer);
            this.addPage((IWizardPage)this.page1);
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }
}

