/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.libraries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.externallibrary.model.Visibility;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.mtj.internal.ui.util.PixelConverter;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.mtj.internal.ui.wizards.libraries.LibraryInfoBlock;
import org.eclipse.mtj.internal.ui.wizards.libraries.LibraryListLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrarySelectionBlock {
    private static final int IDX_SELECT_ALL = 0;
    private static final int IDX_UNSELECT_ALL = 1;
    private static final String PATH_SEPARATOR = "/";
    private final List<String> publicLibsNames;
    private boolean librariesAvailable = false;
    private LibraryInfoBlock libraryInfoBlock;
    private CheckedListDialogField libraryList;
    private Composite LibrarySelectionComposite;
    private Composite parentComposite;

    public LibrarySelectionBlock() {
        String[] tempLibs;
        String[] buttonLabels = new String[]{MTJUIMessages.NewMidletProjectWizardPageLibrary_libraryList_checkall_button, MTJUIMessages.NewMidletProjectWizardPageLibrary_libraryList_uncheckall_button};
        this.libraryList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new LibraryListLabelProvider());
        this.libraryList.setLabelText(MTJUIMessages.NewMidletProjectWizardPageLibrary_libraryList_label);
        this.libraryList.setCheckAllButtonIndex(0);
        this.libraryList.setUncheckAllButtonIndex(1);
        this.libraryInfoBlock = new LibraryInfoBlock();
        this.publicLibsNames = new ArrayList<String>();
        String[] stringArray = tempLibs = ExternalLibraryManager.getInstance().getMidletLibraryNames();
        int n = tempLibs.length;
        int n2 = 0;
        while (n2 < n) {
            String libname = stringArray[n2];
            IExternalLibrary library = ExternalLibraryManager.getInstance().getMidletLibrary(libname);
            if (library != null && library.getVisibility() != Visibility.INTERNAL && library.getVisibility() != Visibility.INVALID) {
                this.publicLibsNames.add(libname);
            }
            ++n2;
        }
        if (!this.publicLibsNames.isEmpty()) {
            this.librariesAvailable = true;
        }
    }

    public void checkAll(boolean state) {
        this.libraryList.checkAll(state);
    }

    public Control createControl(Composite parent) {
        this.parentComposite = parent;
        PixelConverter converter = new PixelConverter((Control)this.parentComposite);
        int[] sashWeight = new int[]{60};
        this.LibrarySelectionComposite = this.createMainComposite(this.parentComposite);
        Composite scrolledPagecomposite = this.createScrolledPageContent(this.LibrarySelectionComposite);
        SashForm sashForm = this.createSashForm(scrolledPagecomposite);
        this.createLibraryListComposite((Composite)sashForm, converter.convertWidthInCharsToPixels(24));
        this.createExpandableComposite(sashForm, sashWeight);
        sashForm.setWeights(new int[]{50, 50});
        this.adjustSashForm(sashWeight, sashForm, false);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = converter.convertHeightInCharsToPixels(20);
        sashForm.setLayoutData((Object)gd);
        parent.layout(true);
        this.libraryList.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this.libraryInfoBlock);
        return this.LibrarySelectionComposite;
    }

    public Control getControl() {
        return this.LibrarySelectionComposite;
    }

    public List<IPath> getLibrariesPathEntries() {
        ArrayList<IPath> entryPath = new ArrayList<IPath>();
        List<Object> libs = this.libraryList.getElements();
        for (Object object : libs) {
            IExternalLibrary type = (IExternalLibrary)object;
            entryPath.add((IPath)new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY/" + type.getName()));
        }
        return entryPath;
    }

    public List<Object> getSelectedLibraries() {
        return this.libraryList.getCheckedElements();
    }

    public List<IPath> getSelectedLibrariesPathEntries() {
        ArrayList<IPath> entryPath = new ArrayList<IPath>();
        List<Object> libs = this.getSelectedLibraries();
        for (Object object : libs) {
            IExternalLibrary type = (IExternalLibrary)object;
            entryPath.add((IPath)new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY/" + type.getName()));
        }
        return entryPath;
    }

    public boolean isLibrariesAvailable() {
        return this.librariesAvailable;
    }

    public void setChecked(Object object, boolean state) {
        this.libraryList.setCheckedWithoutUpdate(object, state);
    }

    public void setLibrarySelectionDialogFieldListener(IDialogFieldListener listener) {
        this.libraryList.setDialogFieldListener(listener);
    }

    private void adjustSashForm(int[] sashWeight, SashForm sashForm, boolean isExpanded) {
        if (isExpanded) {
            int upperWeight = sashWeight[0];
            sashForm.setWeights(new int[]{upperWeight, 100 - upperWeight});
        } else {
            sashWeight[0] = sashForm.getWeights()[0] / 10;
            sashForm.setWeights(new int[]{95, 5});
        }
        sashForm.layout(true);
    }

    private Composite createExpandableComposite(final SashForm parent, final int[] sashWeight) {
        final ExpandableComposite excomposite = new ExpandableComposite((Composite)parent, 0, 18);
        excomposite.setLayoutData((Object)new GridData(4, 4, true, true));
        excomposite.setFont(parent.getFont());
        excomposite.setText(MTJUIMessages.NewMidletProjectWizardPageLibrary_HintTextGroup_title);
        excomposite.setExpanded(false);
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parentScrolledComposite = LibrarySelectionBlock.this.getParentScrolledComposite((Control)excomposite);
                if (parentScrolledComposite != null) {
                    boolean expanded = excomposite.isExpanded();
                    parentScrolledComposite.reflow(true);
                    LibrarySelectionBlock.this.adjustSashForm(sashWeight, parent, expanded);
                }
            }
        });
        excomposite.setClient(this.libraryInfoBlock.createControl((Composite)excomposite));
        return excomposite;
    }

    private Composite createLibraryListComposite(Composite parent, int buttonBarWidth) {
        Composite libraryListComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        libraryListComposite.setLayout((Layout)layout);
        libraryListComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        LayoutUtil.doDefaultLayout(libraryListComposite, new DialogField[]{this.libraryList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.libraryList.getListControl(null));
        this.libraryList.setButtonsMinWidth(buttonBarWidth);
        this.initialize();
        return libraryListComposite;
    }

    private Composite createMainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private SashForm createSashForm(Composite parent) {
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setFont(sashForm.getFont());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        return sashForm;
    }

    private Composite createScrolledPageContent(Composite parent) {
        ScrolledPageContent scrolledContent = new ScrolledPageContent(parent);
        scrolledContent.setLayout((Layout)new GridLayout());
        scrolledContent.setLayoutData(new GridData(4, 4, true, true));
        Composite body = scrolledContent.getBody();
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        return body;
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private void initialize() {
        if (this.librariesAvailable) {
            for (String libName : this.publicLibsNames) {
                try {
                    this.libraryList.addElement(ExternalLibraryManager.getInstance().getMidletLibrary(libName));
                }
                catch (Exception e) {
                    MTJLogger.log((int)4, (String)("Failed to load \"" + libName + "\" Library"), (Throwable)e);
                }
            }
        }
    }

    protected void doUpdateUI() {
        this.libraryList.refresh();
    }

    protected void updateUI() {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (LibrarySelectionBlock.this.parentComposite == null || LibrarySelectionBlock.this.parentComposite.isDisposed()) {
                        return;
                    }
                    LibrarySelectionBlock.this.doUpdateUI();
                }
            });
        }
    }
}

