/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.midlet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletDefinition;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.ApplicationDescriptor;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateBuilderException;
import org.eclipse.mtj.internal.ui.templates.midlets.MidletTemplateBuilder;
import org.eclipse.mtj.internal.ui.wizards.midlet.page.NewMidletWizardPage;
import org.eclipse.mtj.internal.ui.wizards.templates.TemplateWizardPageDelegate;
import org.eclipse.mtj.internal.ui.wizards.templates.midlets.MidletTemplateListWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMidletWizard
extends Wizard
implements INewWizard {
    public static final String TemplateCustomPage = "TemplateCustomPage";
    private NewMidletWizardPage midletPage;
    private IStructuredSelection selection;
    private MidletTemplateListWizardPage page1;
    private TemplateWizardPageDelegate page2;
    private IWorkbench workbench;

    public NewMidletWizard() {
        this.setWindowTitle(MTJUIMessages.NewMidletWizard_dialogtitle);
        this.setDialogSettings(MTJUIPlugin.getDialogSettings("NewMidletWizard"));
        this.setDefaultPageImageDescriptor(MTJUIPluginImages.DESC_NEW_MIDLET_CLASS);
    }

    public void addPages() {
        this.midletPage = new NewMidletWizardPage();
        this.addPage((IWizardPage)this.midletPage);
        this.midletPage.setWizard((IWizard)this);
        this.midletPage.init(this.selection);
        this.page1 = new MidletTemplateListWizardPage();
        this.page1.setImageDescriptor(MTJUIPluginImages.DESC_TEMPLATE_WIZ);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new TemplateWizardPageDelegate(TemplateCustomPage);
        this.page2.setImageDescriptor(MTJUIPluginImages.DESC_TEMPLATE_WIZ);
        this.addPage((IWizardPage)this.page2);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public boolean performFinish() {
        boolean completed = true;
        IRunnableWithProgress createMidletOp = this.getCreateMidletOperation();
        try {
            this.getContainer().run(false, true, createMidletOp);
        }
        catch (InvocationTargetException e) {
            MTJUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MTJUIPlugin.getPluginId(), "error creating the new MIDlet", (Throwable)e));
            completed = false;
        }
        catch (InterruptedException interruptedException) {
            completed = false;
        }
        return completed;
    }

    private void addMidletToJAD(IType type, IProgressMonitor monitor) throws IOException, CoreException {
        IJavaProject javaProject = (IJavaProject)type.getAncestor(2);
        IMidletSuiteProject midletSuite = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject);
        IApplicationDescriptor desc = midletSuite.getApplicationDescriptor();
        if (desc != null) {
            ApplicationDescriptor.MidletDefinition def = new ApplicationDescriptor.MidletDefinition(desc.getMidletCount() + 1, type.getElementName(), "", type.getFullyQualifiedName());
            desc.addMidletDefinition((IMidletDefinition)def);
            desc.store();
            IFile jadFile = midletSuite.getApplicationDescriptorFile();
            jadFile.refreshLocal(1, monitor);
        }
    }

    private IRunnableWithProgress getCreateMidletOperation() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IType type = null;
                if (NewMidletWizard.this.page1.getSelectedTemplate() != null) {
                    MidletTemplateBuilder builder = new MidletTemplateBuilder(NewMidletWizard.this.page1.getSelectedTemplate(), NewMidletWizard.this.page2.getDictionary());
                    try {
                        type = builder.build(NewMidletWizard.this.midletPage.getPackageFragmentRoot(), NewMidletWizard.this.midletPage.getPackageFragment(), NewMidletWizard.this.midletPage.getTypeName(), monitor);
                    }
                    catch (MIDletTemplateBuilderException e) {
                        MTJLogger.log((int)4, (Throwable)e);
                    }
                } else {
                    WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(NewMidletWizard.this.midletPage.getRunnable());
                    op.run(monitor);
                    type = NewMidletWizard.this.midletPage.getCreatedType();
                }
                if (type != null) {
                    IResource resource = type.getResource();
                    if (resource != null) {
                        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)NewMidletWizard.this.workbench.getActiveWorkbenchWindow());
                        NewMidletWizard.this.openResource((IFile)resource);
                    }
                    if (NewMidletWizard.this.midletPage.isAddToJadSelected()) {
                        try {
                            NewMidletWizard.this.addMidletToJAD(type, monitor);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            }
        };
        return new WorkspaceModifyDelegatingOperation(runnable);
    }

    private void openResource(final IFile resource) {
        Display display;
        IWorkbenchPage activePage;
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window != null && (activePage = this.workbench.getActiveWorkbenchWindow().getActivePage()) != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

