/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.projects;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.sdk.device.midp.Profile;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageOne;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class NewMidletProjectWizardPageProperties
extends WizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPageTwo";
    private OptionsGroup optionsGroup;
    private NewMidletProjectWizardPageOne pageOne;
    private PropertiesGroup propertiesGroup;
    private Validator validator;

    public NewMidletProjectWizardPageProperties(NewMidletProjectWizardPageOne firstPage) {
        super(PAGE_NAME);
        this.setTitle(MTJUIMessages.NewMidletProjectWizardPageTwo_title);
        this.setDescription(MTJUIMessages.NewMidletProjectWizardPageTwo_description);
        this.pageOne = firstPage;
        this.validator = new Validator();
        this.propertiesGroup = new PropertiesGroup();
        this.optionsGroup = new OptionsGroup();
        this.pageOne.getProjectNameGroup().addObserver(this.propertiesGroup);
        this.propertiesGroup.addObserver(this.validator);
        this.optionsGroup.addObserver(this.validator);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(), true));
        Control nameControl = this.createPropertiesControl(composite);
        nameControl.setLayoutData((Object)new GridData(768));
        Control optionsControl = this.createOptionsControl(composite);
        optionsControl.setLayoutData((Object)new GridData(768));
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        this.setControl((Control)scrolledComposite);
    }

    public PackagingModel getPackagingModel() {
        return this.propertiesGroup.getPackagingModel();
    }

    public String getMeConfiguration() {
        return this.propertiesGroup.getMeConfiguration();
    }

    public String getMeProfile() {
        return this.propertiesGroup.getMeProfile();
    }

    public String getMIDletName() {
        return this.propertiesGroup.getMIDletName();
    }

    public String getMIDletVendor() {
        return this.propertiesGroup.getMIDletVendor();
    }

    public String getMIDletVersion() {
        return this.propertiesGroup.getMIDletVersion();
    }

    public String getPackageName() {
        return this.optionsGroup.getPackage();
    }

    public String getPropertiesFolderName() {
        return this.optionsGroup.getPropertiesFolder();
    }

    public boolean isJMUnitEnabled() {
        return this.optionsGroup.isJMUnitEnable();
    }

    public boolean isLocalizationEnabled() {
        return this.optionsGroup.isLocalizationEnable();
    }

    public boolean isPreprocessingEnabled() {
        return this.optionsGroup.isPreprocessingEnable();
    }

    private Control createOptionsControl(Composite parent) {
        return this.optionsGroup.createControl(parent);
    }

    private GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected Control createPropertiesControl(Composite parent) {
        return this.propertiesGroup.createControl(parent);
    }

    private final class OptionsGroup
    extends Observable
    implements IDialogFieldListener {
        private SelectionButtonDialogField enableJMUnit;
        private SelectionButtonDialogField enableLocalization;
        private SelectionButtonDialogField enablePreprocessing = new SelectionButtonDialogField(32);
        private StringDialogField packageField;
        private StringDialogField propertiesFolder;

        public OptionsGroup() {
            this.enablePreprocessing.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_enablePreprocessing);
            this.enablePreprocessing.setDialogFieldListener(this);
            this.enableLocalization = new SelectionButtonDialogField(32);
            this.enableLocalization.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_enableLocalization);
            this.enableLocalization.setDialogFieldListener(this);
            this.propertiesFolder = new StringDialogField();
            this.propertiesFolder.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_propertiesFolder);
            this.propertiesFolder.setDialogFieldListener(this);
            this.propertiesFolder.setTextWithoutUpdate("res");
            this.propertiesFolder.setEnabled(false);
            this.packageField = new StringDialogField();
            this.packageField.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_package);
            this.packageField.setDialogFieldListener(this);
            this.enableJMUnit = new SelectionButtonDialogField(32);
            this.enableJMUnit.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_enableJMUnit);
            this.enableJMUnit.setDialogFieldListener(this);
            this.enablePreprocessing.setSelection(false);
            this.enableLocalization.setSelection(false);
            this.enableLocalization.attachDialogField(this.propertiesFolder);
            this.enableLocalization.attachDialogFields(new DialogField[]{this.packageField});
        }

        public Control createControl(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayout((Layout)NewMidletProjectWizardPageProperties.this.initGridLayout(new GridLayout(2, false), true));
            group.setText(MTJUIMessages.NewMidletProjectWizardPageProperties_midlet_additional_support);
            this.enablePreprocessing.doFillIntoGrid((Composite)group, 2);
            this.enableLocalization.doFillIntoGrid((Composite)group, 2);
            this.propertiesFolder.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.propertiesFolder.getTextControl(null));
            this.packageField.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.packageField.getTextControl(null));
            this.enableJMUnit.doFillIntoGrid((Composite)group, 2);
            return group;
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        public String getPackage() {
            return this.packageField.getText();
        }

        public String getPropertiesFolder() {
            return this.propertiesFolder.getText();
        }

        public boolean isJMUnitEnable() {
            return this.enableJMUnit.isSelected();
        }

        public boolean isLocalizationEnable() {
            return this.enableLocalization.isSelected();
        }

        public boolean isPreprocessingEnable() {
            return this.enablePreprocessing.isSelected();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PropertiesGroup
    extends Observable
    implements IDialogFieldListener,
    Observer {
        private Map<String, IAPI> configurations;
        private ComboDialogField packagingModel;
        private ComboDialogField meConfiguration;
        private ComboDialogField meProfile;
        private StringDialogField midletName;
        private StringDialogField midletVendor;
        private StringDialogField midletVersion;
        private Map<String, IAPI> profiles;
        private String[] configurationNames;
        private String[] meepSupportedConfigurationNames = new String[]{Configuration.CLDC_18.getName()};
        private String[] profileNames;
        private String[] libletSupportedProfileNames = new String[]{Profile.MEEP_80.getName()};

        public PropertiesGroup() {
            this.configurations = new HashMap<String, IAPI>();
            this.profiles = new HashMap<String, IAPI>();
            String[] packagingModelNames = new String[]{PackagingModel.MIDLET.getName(), PackagingModel.LIBLET.getName()};
            this.packagingModel = new ComboDialogField(8);
            this.packagingModel.setLabelText(MTJUIMessages.jadPropertiesEditorPage_PackagingModel_text);
            this.packagingModel.setDialogFieldListener(this);
            this.packagingModel.setItems(packagingModelNames);
            this.packagingModel.setTextWithoutUpdate(packagingModelNames[0]);
            this.midletName = new StringDialogField();
            this.midletName.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletName);
            this.midletName.setDialogFieldListener(this);
            this.midletVendor = new StringDialogField();
            this.midletVendor.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletVendor);
            this.midletVendor.setDialogFieldListener(this);
            this.midletVersion = new StringDialogField();
            this.midletVersion.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletVersion);
            this.midletVersion.setDialogFieldListener(this);
            Configuration[] meConfigurations = Configuration.values();
            this.configurationNames = new String[meConfigurations.length];
            String defaultConfiguration = "";
            int i = 0;
            while (i < meConfigurations.length) {
                this.configurationNames[i] = meConfigurations[i].getName();
                if (meConfigurations[i].toString().equals("CLDC-1.0")) {
                    defaultConfiguration = meConfigurations[i].getName();
                }
                this.configurations.put(this.configurationNames[i], (IAPI)meConfigurations[i]);
                ++i;
            }
            this.meConfiguration = new ComboDialogField(8);
            this.meConfiguration.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_meConfiguration);
            this.meConfiguration.setDialogFieldListener(this);
            this.meConfiguration.setItems(this.configurationNames);
            this.meConfiguration.setTextWithoutUpdate(defaultConfiguration);
            Profile[] meProfiles = Profile.values();
            this.profileNames = new String[meProfiles.length];
            String defaultProfile = "";
            int i2 = 0;
            while (i2 < meProfiles.length) {
                this.profileNames[i2] = meProfiles[i2].getName();
                if (meProfiles[i2].toString().equals("MIDP-2.1")) {
                    defaultProfile = meProfiles[i2].getName();
                }
                this.profiles.put(this.profileNames[i2], (IAPI)meProfiles[i2]);
                ++i2;
            }
            this.meProfile = new ComboDialogField(8);
            this.meProfile.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_meProfile);
            this.meProfile.setDialogFieldListener(this);
            this.meProfile.setItems(this.profileNames);
            this.meProfile.setTextWithoutUpdate(defaultProfile);
        }

        public Control createControl(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayout((Layout)NewMidletProjectWizardPageProperties.this.initGridLayout(new GridLayout(2, false), true));
            group.setText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_contents);
            this.packagingModel.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.packagingModel.getComboControl(null));
            this.midletName.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.midletName.getTextControl(null));
            this.midletVendor.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.midletVendor.getTextControl(null));
            this.midletVersion.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.midletVersion.getTextControl(null));
            this.meConfiguration.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.meConfiguration.getComboControl(null));
            this.meProfile.doFillIntoGrid((Composite)group, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.meProfile.getComboControl(null));
            this.meConfiguration.getComboControl(null).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertiesGroup.this.updateComboFields();
                }
            });
            this.meProfile.getComboControl(null).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertiesGroup.this.updateComboFields();
                }
            });
            this.packagingModel.getComboControl(null).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (PropertiesGroup.this.packagingModel.getText().equals(PackagingModel.MIDLET.getName())) {
                        PropertiesGroup.this.midletName.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletName);
                        PropertiesGroup.this.midletVendor.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletVendor);
                        PropertiesGroup.this.midletVersion.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletVersion);
                    } else if (PropertiesGroup.this.packagingModel.getText().equals(PackagingModel.LIBLET.getName())) {
                        PropertiesGroup.this.midletName.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_libletName);
                        PropertiesGroup.this.midletVendor.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_libletVendor);
                        PropertiesGroup.this.midletVersion.setLabelText(MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_libletVersion);
                    }
                    PropertiesGroup.this.updateComboFields();
                }
            });
            this.initValues();
            this.updateComboFields();
            return group;
        }

        private void updateComboFields() {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    String selectedItem;
                    if (PropertiesGroup.this.packagingModel.getText().equals(PackagingModel.MIDLET.getName())) {
                        selectedItem = PropertiesGroup.this.meProfile.getText();
                        PropertiesGroup.this.meProfile.setItems(PropertiesGroup.this.profileNames);
                        PropertiesGroup.this.meProfile.selectItem(selectedItem);
                    } else if (PropertiesGroup.this.packagingModel.getText().equals(PackagingModel.LIBLET.getName())) {
                        PropertiesGroup.this.meProfile.setItems(PropertiesGroup.this.libletSupportedProfileNames);
                        PropertiesGroup.this.meProfile.selectItem(0);
                    }
                    if (PropertiesGroup.this.meProfile.getText().equals(Profile.MEEP_80.getName())) {
                        PropertiesGroup.this.meConfiguration.setItems(PropertiesGroup.this.meepSupportedConfigurationNames);
                        PropertiesGroup.this.meConfiguration.selectItem(0);
                    } else {
                        selectedItem = PropertiesGroup.this.meConfiguration.getText();
                        PropertiesGroup.this.meConfiguration.setItems(PropertiesGroup.this.configurationNames);
                        PropertiesGroup.this.meConfiguration.selectItem(selectedItem);
                    }
                    String meProfileSelected = PropertiesGroup.this.meProfile.getText();
                    String meConfigurationSelected = PropertiesGroup.this.meConfiguration.getText();
                    if (!Configuration.CLDC_10.getName().equals(meConfigurationSelected) && !Configuration.CLDC_11.getName().equals(meConfigurationSelected) || Profile.MEEP_80.getName().equals(meProfileSelected) || Profile.IMP_NG.getName().equals(meProfileSelected) || Profile.IMP_10.getName().equals(meProfileSelected)) {
                        NewMidletProjectWizardPageProperties.this.optionsGroup.enableJMUnit.setSelection(false);
                        NewMidletProjectWizardPageProperties.this.optionsGroup.enableJMUnit.setEnabled(false);
                    } else {
                        NewMidletProjectWizardPageProperties.this.optionsGroup.enableJMUnit.setEnabled(true);
                    }
                }
            });
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        public PackagingModel getPackagingModel() {
            if (this.packagingModel.getText().equals(PackagingModel.LIBLET.getName())) {
                return PackagingModel.LIBLET;
            }
            return PackagingModel.MIDLET;
        }

        public String getMeConfiguration() {
            return this.configurations.get(this.meConfiguration.getText()).toString();
        }

        public String getMeProfile() {
            return this.profiles.get(this.meProfile.getText()).toString();
        }

        public String getMIDletName() {
            return this.midletName.getText();
        }

        public String getMIDletVendor() {
            return this.midletVendor.getText();
        }

        public String getMIDletVersion() {
            return this.midletVersion.getText();
        }

        @Override
        public void update(Observable o, Object arg) {
            String midlet = this.midletName.getText();
            String projectName = NewMidletProjectWizardPageProperties.this.pageOne.getProjectName();
            if (projectName.length() > 0 && midlet.startsWith(projectName.substring(0, projectName.length() - 1)) || midlet.equals(" MIDlet Suite")) {
                this.midletName.setText(String.valueOf(projectName) + " MIDlet Suite");
            }
        }

        private <A extends IMIDPAPI> A findActualRequiredAPI(A[] values, IMIDPAPI requiredAPI) {
            if (requiredAPI != null) {
                A[] AArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    A candidate = AArray[n2];
                    if (requiredAPI.getType() == candidate.getType() && requiredAPI.getIdentifier().equals(candidate.getIdentifier()) && requiredAPI.getVersion().equals((Object)candidate.getVersion())) {
                        return candidate;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private void updateProfileAndConfiguration() {
            IDevice activeDevice = NewMidletProjectWizardPageProperties.this.pageOne.getSelectedDevice();
            if (activeDevice instanceof IMIDPDevice) {
                IMIDPDevice activeMEDevice = (IMIDPDevice)activeDevice;
                Configuration deviceConfiguration = (Configuration)this.findActualRequiredAPI((IMIDPAPI[])Configuration.values(), activeMEDevice.getCLDCAPI());
                Profile deviceProfile = (Profile)this.findActualRequiredAPI((IMIDPAPI[])Profile.values(), activeMEDevice.getMIDPAPI());
                if (deviceConfiguration != null) {
                    this.meConfiguration.setTextWithoutUpdate(deviceConfiguration.getName());
                }
                if (deviceProfile != null) {
                    this.meProfile.setTextWithoutUpdate(deviceProfile.getName());
                }
            }
        }

        private void initValues() {
            this.midletName.setText(String.valueOf(NewMidletProjectWizardPageProperties.this.pageOne.getProjectName()) + " MIDlet Suite");
            this.midletVendor.setText("MIDlet Suite Vendor");
            this.midletVersion.setText("1.0.0");
            NewMidletProjectWizardPageProperties.this.pageOne.getConfigurationGroup().addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    PropertiesGroup.this.updateProfileAndConfiguration();
                }
            });
            this.updateProfileAndConfiguration();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private final class Validator
    implements Observer {
        private Pattern correctPattern = Pattern.compile("([a-z_]\\w*)(\\.[a-z_]\\w*)*");
        private Pattern packagePattern = Pattern.compile("([a-zA-Z_]\\w*)(\\.[a-zA-Z_]\\w*)*");

        private Validator() {
        }

        public void update(Observable o, Object arg) {
            if (NewMidletProjectWizardPageProperties.this.getMIDletName().equals("")) {
                NewMidletProjectWizardPageProperties.this.setErrorMessage(NLS.bind((String)MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_fieldEmpty, (Object)MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletName));
                NewMidletProjectWizardPageProperties.this.setMessage(null);
                NewMidletProjectWizardPageProperties.this.setPageComplete(false);
                return;
            }
            if (NewMidletProjectWizardPageProperties.this.getMIDletVendor().equals("")) {
                NewMidletProjectWizardPageProperties.this.setErrorMessage(NLS.bind((String)MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_fieldEmpty, (Object)MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletVendor));
                NewMidletProjectWizardPageProperties.this.setMessage(null);
                NewMidletProjectWizardPageProperties.this.setPageComplete(false);
                return;
            }
            if (NewMidletProjectWizardPageProperties.this.getMIDletVersion().equals("")) {
                NewMidletProjectWizardPageProperties.this.setErrorMessage(NLS.bind((String)MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_fieldEmpty, (Object)MTJUIMessages.NewMidletProjectWizardPageTwo_propertiesGroup_midletVersion));
                NewMidletProjectWizardPageProperties.this.setMessage(null);
                NewMidletProjectWizardPageProperties.this.setPageComplete(false);
                return;
            }
            if (NewMidletProjectWizardPageProperties.this.isLocalizationEnabled()) {
                String packageName = NewMidletProjectWizardPageProperties.this.getPackageName();
                if (packageName.equals("")) {
                    NewMidletProjectWizardPageProperties.this.setErrorMessage(null);
                    NewMidletProjectWizardPageProperties.this.setMessage(MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_packageEmpty, 2);
                    NewMidletProjectWizardPageProperties.this.setPageComplete(true);
                    return;
                }
                Matcher packageMatcher = this.packagePattern.matcher(packageName);
                if (packageMatcher.matches()) {
                    Matcher correctMatcher = this.correctPattern.matcher(packageName);
                    if (correctMatcher.matches()) {
                        NewMidletProjectWizardPageProperties.this.setErrorMessage(null);
                        NewMidletProjectWizardPageProperties.this.setMessage(null);
                        NewMidletProjectWizardPageProperties.this.setPageComplete(true);
                        return;
                    }
                    NewMidletProjectWizardPageProperties.this.setErrorMessage(null);
                    NewMidletProjectWizardPageProperties.this.setMessage(MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_packageUpperCase, 2);
                    NewMidletProjectWizardPageProperties.this.setPageComplete(true);
                    return;
                }
                NewMidletProjectWizardPageProperties.this.setMessage(null);
                NewMidletProjectWizardPageProperties.this.setErrorMessage(NLS.bind((String)MTJUIMessages.NewMidletProjectWizardPageTwo_optionsGroup_packageError, (Object)packageName));
                NewMidletProjectWizardPageProperties.this.setPageComplete(false);
                return;
            }
            NewMidletProjectWizardPageProperties.this.setErrorMessage(null);
            NewMidletProjectWizardPageProperties.this.setMessage(null);
            NewMidletProjectWizardPageProperties.this.setPageComplete(true);
        }
    }
}

