/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.jad;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.internal.core.project.midp.JADAttributesRegistry;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.preferences.ExtendedStringFieldEditor;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.ComboJADPropertyEditor;
import org.eclipse.mtj.ui.editors.jad.IFilteredJADPropertyEditor;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.ListDescriptorPropertyDescription;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class JADPropertiesEditorPage
extends AbstractJADEditorPage
implements IPropertyChangeListener {
    private DescriptorPropertyDescription[] descriptors;
    protected FieldEditor[] fieldEditors;

    public JADPropertiesEditorPage(JADFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public JADPropertiesEditorPage(String id, String title) {
        super(id, title);
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.setTaskName(this.getTitle());
        FieldEditor[] fieldEditorArray = this.fieldEditors;
        int n = this.fieldEditors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor element = fieldEditorArray[n2];
            element.store();
            ++n2;
        }
        this.setDirty(false);
    }

    public void editorInputChanged() {
        this.updateEditComponents();
    }

    public DescriptorPropertyDescription[] getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.doGetDescriptors();
        }
        return this.descriptors;
    }

    public boolean isManagingProperty(String property) {
        int i = 0;
        while (i < this.getDescriptors().length) {
            DescriptorPropertyDescription desc = this.getDescriptors()[i];
            if (property.equals(desc.getPropertyName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value")) {
            this.setDirty(true);
        }
    }

    public void setFocus() {
        if (this.fieldEditors.length > 0) {
            this.fieldEditors[0].setFocus();
        }
    }

    protected FieldEditor createComboFieldEditor(FormToolkit toolkit, Composite composite, DescriptorPropertyDescription description) {
        ListDescriptorPropertyDescription listDescription = (ListDescriptorPropertyDescription)description;
        return new ComboJADPropertyEditor(listDescription.getPropertyName(), listDescription.getDisplayName(), listDescription.getNamesAndValues(), listDescription.getFilter(), composite);
    }

    protected IntegerFieldEditor createIntegerFieldEditor(FormToolkit toolkit, Composite parent, DescriptorPropertyDescription descriptor) {
        IntegerFieldEditor integerEditor = new IntegerFieldEditor(descriptor.getPropertyName(), descriptor.getDisplayName(), parent);
        toolkit.adapt((Control)integerEditor.getTextControl(parent), true, true);
        return integerEditor;
    }

    protected StringFieldEditor createStringFieldEditor(FormToolkit toolkit, Composite parent, DescriptorPropertyDescription descriptor) {
        ExtendedStringFieldEditor editor = new ExtendedStringFieldEditor(descriptor.getPropertyName(), descriptor.getDisplayName(), parent);
        toolkit.adapt((Control)editor.getTextControl(parent), true, true);
        return editor;
    }

    protected void updateEditComponents() {
        if (this.fieldEditors != null) {
            FieldEditor fieldEditor;
            IManifestPreferenceStore store = this.getPreferenceStore();
            FieldEditor[] fieldEditorArray = this.fieldEditors;
            int n = this.fieldEditors.length;
            int n2 = 0;
            while (n2 < n) {
                fieldEditor = fieldEditorArray[n2];
                fieldEditor.setPreferenceStore((IPreferenceStore)store);
                fieldEditor.load();
                ++n2;
            }
            fieldEditorArray = this.fieldEditors;
            n = this.fieldEditors.length;
            n2 = 0;
            while (n2 < n) {
                fieldEditor = fieldEditorArray[n2];
                if (fieldEditor instanceof IFilteredJADPropertyEditor) {
                    ((IFilteredJADPropertyEditor)fieldEditor).updateDependencies();
                }
                ++n2;
            }
        }
    }

    protected abstract void addContextHelp(Composite var1);

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 1));
        Composite center = toolkit.createComposite(body);
        center.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        center.setLayoutData((Object)new TableWrapData(256));
        Section section = this.createStaticBasicSection(toolkit, center, this.getSectionTitle(), this.getSectionDescription());
        Composite sectionClient = this.createStaticSectionClient(toolkit, (Composite)section, null);
        sectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        this.createSectionContent(managedForm, sectionClient, this);
        section.setClient((Control)sectionClient);
    }

    protected void createSectionContent(IManagedForm managedForm, Composite composite, final IPropertyChangeListener propertyChangeListener) {
        Control[] children;
        FormToolkit toolkit = managedForm.getToolkit();
        composite.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        new Label(composite, 0);
        new Label(composite, 0);
        DescriptorPropertyDescription[] theDescriptors = this.getDescriptors();
        HashMap<String, FieldEditor> fieldEditorsByPropertyNames = new HashMap<String, FieldEditor>();
        HashMap<String, ArrayList<IFilteredJADPropertyEditor>> dependentEditors = new HashMap<String, ArrayList<IFilteredJADPropertyEditor>>();
        this.fieldEditors = new FieldEditor[theDescriptors.length];
        int i = 0;
        while (i < theDescriptors.length) {
            IFilteredJADPropertyEditor filteredEditor;
            String[] filterPropertyNames;
            switch (theDescriptors[i].getDataType()) {
                case 3: {
                    this.fieldEditors[i] = this.createIntegerFieldEditor(toolkit, composite, theDescriptors[i]);
                    break;
                }
                case 4: {
                    this.fieldEditors[i] = this.createComboFieldEditor(toolkit, composite, theDescriptors[i]);
                    break;
                }
                default: {
                    this.fieldEditors[i] = this.createStringFieldEditor(toolkit, composite, theDescriptors[i]);
                }
            }
            fieldEditorsByPropertyNames.put(theDescriptors[i].getPropertyName(), this.fieldEditors[i]);
            if (this.fieldEditors[i] instanceof IFilteredJADPropertyEditor && (filterPropertyNames = (filteredEditor = (IFilteredJADPropertyEditor)this.fieldEditors[i]).getFilterPropertyNames()) != null) {
                String[] stringArray = filterPropertyNames;
                int n = filterPropertyNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String filterPropertyName = stringArray[n2];
                    ArrayList<IFilteredJADPropertyEditor> propertyDependentEditors = (ArrayList<IFilteredJADPropertyEditor>)dependentEditors.get(filterPropertyName);
                    if (propertyDependentEditors == null) {
                        propertyDependentEditors = new ArrayList<IFilteredJADPropertyEditor>();
                        dependentEditors.put(filterPropertyName, propertyDependentEditors);
                    }
                    propertyDependentEditors.add(filteredEditor);
                    ++n2;
                }
            }
            Label label = this.fieldEditors[i].getLabelControl(composite);
            toolkit.adapt((Control)label, false, false);
            this.fieldEditors[i].setPropertyChangeListener(propertyChangeListener);
            ++i;
        }
        for (Map.Entry dependentEditorsEntry : dependentEditors.entrySet()) {
            final String masterEditorPropertyName = (String)dependentEditorsEntry.getKey();
            FieldEditor masterEditor = (FieldEditor)fieldEditorsByPropertyNames.get(masterEditorPropertyName);
            if (masterEditor == null) continue;
            final List propertyDependentEditors = (List)dependentEditorsEntry.getValue();
            masterEditor.setPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    propertyChangeListener.propertyChange(event);
                    if ("mtj_update_jad_filter".equals(event.getProperty())) {
                        for (IFilteredJADPropertyEditor propertyDependentEditor : propertyDependentEditors) {
                            propertyDependentEditor.performFiltering(masterEditorPropertyName, event.getNewValue());
                        }
                    }
                }
            });
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n3 = 0;
        while (n3 < n) {
            Control control = controlArray[n3];
            if (control instanceof Combo) {
                toolkit.adapt(control, false, false);
            }
            ++n3;
        }
        this.updateEditComponents();
        this.addContextHelp(composite);
    }

    protected DescriptorPropertyDescription[] doGetDescriptors() {
        return JADAttributesRegistry.getJADAttrDescriptorsByPage((String)this.getId());
    }

    protected abstract String getSectionDescription();

    protected abstract String getSectionTitle();

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.updateEditComponents();
        this.setDirty(false);
    }
}

