/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.hypertext;

import java.lang.reflect.Field;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylar.internal.core.util.MylarStatusHandler;
import org.eclipse.mylar.internal.tasklist.ui.editors.MylarTaskEditor;
import org.eclipse.mylar.provisional.core.AbstractUserInteractionMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;

public class BrowserTracker
extends AbstractUserInteractionMonitor
implements IPartListener,
IWindowListener,
IPageListener {
    private UrlTrackingListener urlTrackingListener = new UrlTrackingListener();
    private IWorkbenchPart currentBrowserPart = null;

    protected void handleWorkbenchPartSelection(IWorkbenchPart part, ISelection selection) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof WebBrowserEditor) {
            this.currentBrowserPart = part;
            Browser browser = this.getBrowser((WebBrowserEditor)part);
            if (browser != null) {
                browser.addLocationListener((LocationListener)this.urlTrackingListener);
            }
        } else if (part instanceof MylarTaskEditor) {
            this.currentBrowserPart = part;
            Browser browser = ((MylarTaskEditor)part).getWebBrowser();
            if (browser != null) {
                browser.addLocationListener((LocationListener)this.urlTrackingListener);
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
        Browser browser;
        if (part instanceof WebBrowserEditor && (browser = this.getBrowser((WebBrowserEditor)part)) != null) {
            browser.removeLocationListener((LocationListener)this.urlTrackingListener);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    private Browser getBrowser(WebBrowserEditor browserEditor) {
        try {
            Class<?> browserClass = browserEditor.getClass();
            Field browserField = browserClass.getDeclaredField("webBrowser");
            browserField.setAccessible(true);
            Object browserObject = browserField.get(browserEditor);
            if (browserObject != null && browserObject instanceof BrowserViewer) {
                return ((BrowserViewer)browserObject).getBrowser();
            }
        }
        catch (Exception e) {
            MylarStatusHandler.log((Throwable)e, (String)"could not add browser listener");
        }
        return null;
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.addPageListener((IPageListener)this);
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
    }

    class UrlTrackingListener
    implements LocationListener {
        UrlTrackingListener() {
        }

        public void changing(LocationEvent event) {
        }

        public void changed(LocationEvent event) {
            if (event != null) {
                BrowserTracker.this.handleElementSelection(BrowserTracker.this.currentBrowserPart, event);
            }
        }
    }
}

