/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.hypertext.ui.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylar.internal.tasklist.ui.TaskListImages;
import org.eclipse.mylar.internal.ui.MylarImages;
import org.eclipse.mylar.provisional.core.IMylarContext;
import org.eclipse.mylar.provisional.core.IMylarContextListener;
import org.eclipse.mylar.provisional.core.IMylarElement;
import org.eclipse.mylar.provisional.core.IMylarStructureBridge;
import org.eclipse.mylar.provisional.core.MylarPlugin;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementsEditor
extends EditorPart {
    private static final String LABEL = "Web Documents in Active Context";
    private Composite editorComposite;
    private ScrolledForm form;
    private Tree linksTree;
    private TreeViewer treeViewer;
    private List<String> links;
    private RelatedLinksContentProvider contentProvider;
    private Map<String, List<String>> sitesMap = new HashMap<String, List<String>>();
    private Action add;
    private Action delete;
    public static final Color HYPERLINK = new Color((Device)Display.getDefault(), 0, 0, 255);
    private final IMylarContextListener REFRESH_UPDATE_LISTENER = new IMylarContextListener(){

        public void interestChanged(IMylarElement node) {
        }

        public void interestChanged(List<IMylarElement> nodes) {
        }

        public void contextActivated(IMylarContext taskscape) {
            WebElementsEditor.this.update();
        }

        public void contextDeactivated(IMylarContext taskscape) {
            WebElementsEditor.this.update();
        }

        public void presentationSettingsChanging(IMylarContextListener.UpdateKind kind) {
        }

        public void landmarkAdded(IMylarElement node) {
        }

        public void landmarkRemoved(IMylarElement node) {
        }

        public void edgesChanged(IMylarElement node) {
        }

        public void nodeDeleted(IMylarElement node) {
        }

        public void presentationSettingsChanged(IMylarContextListener.UpdateKind kind) {
        }
    };

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(LABEL);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        MylarPlugin.getContextManager().removeListener(this.REFRESH_UPDATE_LISTENER);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        this.editorComposite = this.form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 10;
        layout.topMargin = 10;
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        this.editorComposite.setLayout((Layout)layout);
        this.createContent(this.editorComposite, toolkit);
        this.form.setFocus();
        MylarPlugin.getContextManager().addListener(this.REFRESH_UPDATE_LISTENER);
    }

    private void createContent(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(LABEL);
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                WebElementsEditor.this.form.reflow(true);
            }

            public void expansionStateChanged(ExpansionEvent e) {
                WebElementsEditor.this.form.reflow(true);
            }
        });
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new TableWrapData(256));
        this.createTable(container, toolkit);
        this.createTableViewer(container, toolkit);
        toolkit.paintBordersFor(container);
    }

    public void setFocus() {
    }

    private void createTableViewer(Composite parent, FormToolkit toolkit) {
        this.treeViewer = new TreeViewer(this.linksTree);
        this.contentProvider = new RelatedLinksContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RelatedLinksLabelProvider());
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                String url = (String)((IStructuredSelection)WebElementsEditor.this.treeViewer.getSelection()).getFirstElement();
                if (url != null) {
                    WebElementsEditor.this.openURLinBrowser(url);
                }
            }
        });
        this.update();
        this.defineActions();
        this.hookContextMenu();
    }

    public void update() {
        if (this.treeViewer.getContentProvider() != null) {
            this.treeViewer.setInput(this.getWebDocs());
            this.treeViewer.expandAll();
        }
    }

    private List<String> getWebDocs() {
        this.links = new ArrayList<String>();
        List elements = MylarPlugin.getContextManager().getInterestingDocuments();
        for (IMylarElement element : elements) {
            if (!element.getContentType().equals("html")) continue;
            this.links.add(element.getHandleIdentifier());
        }
        return this.links;
    }

    private void createTable(Composite parent, FormToolkit toolkit) {
        this.linksTree = toolkit.createTree(parent, 0);
        TableWrapData wd = new TableWrapData(256);
        wd.heightHint = 350;
        wd.grabVertical = true;
        this.linksTree.setLayoutData((Object)wd);
        this.linksTree.setHeaderVisible(false);
        this.linksTree.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                if (!((RelatedLinksContentProvider)WebElementsEditor.this.treeViewer.getContentProvider()).isEmpty()) {
                    Cursor hyperlinkCursor = new Cursor((Device)Display.getCurrent(), 21);
                    Display.getCurrent().getCursorControl().setCursor(hyperlinkCursor);
                }
            }

            public void mouseExit(MouseEvent e) {
                Cursor pointer = new Cursor((Device)Display.getCurrent(), 0);
                if (Display.getCurrent() != null && Display.getCurrent().getCursorControl() != null) {
                    Display.getCurrent().getCursorControl().setCursor(pointer);
                }
            }

            public void mouseHover(MouseEvent e) {
                if (!((RelatedLinksContentProvider)WebElementsEditor.this.treeViewer.getContentProvider()).isEmpty()) {
                    Cursor hyperlinkCursor = new Cursor((Device)Display.getCurrent(), 21);
                    Display.getCurrent().getCursorControl().setCursor(hyperlinkCursor);
                }
            }
        });
    }

    private void addLinkToTable() {
    }

    private void removeLinkFromTable() {
        String url = (String)((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (url != null) {
            MylarPlugin.getContextManager().delete(MylarPlugin.getContextManager().getElement(url));
        }
        this.treeViewer.setInput(this.getWebDocs());
    }

    private void defineActions() {
        this.delete = new Action(){

            public void run() {
                WebElementsEditor.this.removeLinkFromTable();
            }
        };
        this.delete.setText("Mark as Uninteresting");
        this.delete.setToolTipText("Mark as Uninteresting");
        this.delete.setImageDescriptor(TaskListImages.REMOVE);
        this.add = new Action(){

            public void run() {
                WebElementsEditor.this.addLinkToTable();
            }
        };
        this.add.setText("Add");
        this.add.setToolTipText("Add");
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)WebElementsEditor.this.delete);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
    }

    private void openURLinBrowser(String url) {
        try {
            IWebBrowser browser = null;
            int flags = 0;
            flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
            browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, "org.eclipse.mylar.tasklist", "Mylar Context Browser", "tasktooltip");
            browser.openURL(new URL(url));
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"URL not found", (String)(String.valueOf(url) + " could not be opened"));
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"URL not found", (String)(String.valueOf(url) + " could not be opened"));
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private class RelatedLinksContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        RelatedLinksContentProvider() {
        }

        public Object[] getElements(Object parent) {
            WebElementsEditor.this.sitesMap.clear();
            if (parent instanceof ArrayList) {
                ArrayList webDocs = (ArrayList)parent;
                IMylarStructureBridge bridge = MylarPlugin.getDefault().getStructureBridge("html");
                HashSet<String> sites = new HashSet<String>();
                for (String link : webDocs) {
                    String webSite = bridge.getParentHandle(link);
                    if (webSite == null) continue;
                    sites.add(webSite);
                    ArrayList<String> pages = (ArrayList<String>)WebElementsEditor.this.sitesMap.get(webSite);
                    if (pages == null) {
                        pages = new ArrayList<String>();
                        WebElementsEditor.this.sitesMap.put(webSite, pages);
                    }
                    pages.add(link);
                }
                if (sites.size() > 0) {
                    return sites.toArray();
                }
                return new String[]{"Task context not activated"};
            }
            return this.getChildren(parent);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isEmpty() {
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String site = (String)parentElement;
                List pages = (List)WebElementsEditor.this.sitesMap.get(site);
                if (pages != null) {
                    return pages.toArray();
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String site = (String)parentElement;
                List pages = (List)WebElementsEditor.this.sitesMap.get(site);
                return pages != null && pages.size() > 0;
            }
            return false;
        }
    }

    private class RelatedLinksLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        RelatedLinksLabelProvider() {
        }

        public String getColumnText(Object obj, int columnIndex) {
            String result = "";
            if (obj instanceof String) {
                switch (columnIndex) {
                    case 0: {
                        result = (String)obj;
                        break;
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object obj, int columnIndex) {
            if (columnIndex == 0 && !WebElementsEditor.this.sitesMap.containsKey(obj)) {
                return MylarImages.getImage((ImageDescriptor)MylarImages.WEB_DOCUMENT);
            }
            return null;
        }

        public Color getForeground(Object element) {
            return HYPERLINK;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

