/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.team;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarContext;
import org.eclipse.mylar.context.core.IMylarContextListener;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.core.IMylarStructureBridge;
import org.eclipse.mylar.context.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.MylarContextManager;
import org.eclipse.mylar.internal.team.ContextChangeSet;
import org.eclipse.mylar.internal.team.TeamRespositoriesManager;
import org.eclipse.mylar.resources.MylarResourcesPlugin;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.DateRangeContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskActivityListener;
import org.eclipse.mylar.tasks.core.ITaskListChangeListener;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.team.AbstractTeamRepositoryProvider;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextChangeSetManager
implements IMylarContextListener {
    private final IChangeSetChangeListener CHANGE_SET_LISTENER = new IChangeSetChangeListener(){

        public void setRemoved(ChangeSet set) {
            ContextChangeSet contextChangeSet;
            if (set instanceof ContextChangeSet && (contextChangeSet = (ContextChangeSet)set).getTask().isActive()) {
                for (ActiveChangeSetManager collector : ContextChangeSetManager.this.collectors) {
                    collector.add((ChangeSet)contextChangeSet);
                }
            }
        }

        public void setAdded(ChangeSet set) {
        }

        public void defaultSetChanged(ChangeSet previousDefault, ChangeSet set) {
        }

        public void nameChanged(ChangeSet set) {
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
        }
    };
    private List<ActiveChangeSetManager> collectors = new ArrayList<ActiveChangeSetManager>();
    private Map<String, ContextChangeSet> activeChangeSets = new HashMap<String, ContextChangeSet>();
    private ITaskActivityListener TASK_ACTIVITY_LISTENER = new ITaskActivityListener(){

        public void taskListRead() {
            ContextChangeSetManager.this.initContextChangeSets();
        }

        public void taskActivated(ITask task) {
        }

        public void tasksActivated(List<ITask> tasks) {
        }

        public void taskDeactivated(ITask task) {
        }

        public void activityChanged(DateRangeContainer week) {
        }

        public void calendarChanged() {
        }
    };
    private ITaskListChangeListener TASK_CHANGE_LISTENER = new ITaskListChangeListener(){

        public void localInfoChanged(ITask task) {
            for (ActiveChangeSetManager collector : ContextChangeSetManager.this.collectors) {
                ChangeSet[] sets = collector.getSets();
                int i = 0;
                while (i < sets.length) {
                    ContextChangeSet contextChangeSet;
                    ChangeSet set = sets[i];
                    if (set instanceof ContextChangeSet && (contextChangeSet = (ContextChangeSet)set).getTask().equals(task)) {
                        contextChangeSet.initTitle();
                    }
                    ++i;
                }
            }
        }

        public void repositoryInfoChanged(ITask task) {
        }

        public void taskMoved(ITask task, AbstractTaskContainer fromContainer, AbstractTaskContainer toContainer) {
        }

        public void taskDeleted(ITask task) {
        }

        public void containerAdded(AbstractTaskContainer container) {
        }

        public void containerDeleted(AbstractTaskContainer container) {
        }

        public void taskAdded(ITask task) {
        }

        public void containerInfoChanged(AbstractTaskContainer container) {
        }
    };
    private boolean isEnabled = false;

    public ContextChangeSetManager() {
        List<AbstractTeamRepositoryProvider> providerList = TeamRespositoriesManager.getInstance().getProviders();
        for (AbstractTeamRepositoryProvider provider : providerList) {
            ActiveChangeSetManager changeSetManager = provider.getActiveChangeSetManager();
            if (changeSetManager == null) continue;
            this.collectors.add(changeSetManager);
        }
    }

    public void enable() {
        if (!this.isEnabled) {
            ContextCorePlugin.getContextManager().addListener((IMylarContextListener)this);
            TasksUiPlugin.getTaskListManager().getTaskList().addChangeListener(this.TASK_CHANGE_LISTENER);
            TasksUiPlugin.getTaskListManager().addActivityListener(this.TASK_ACTIVITY_LISTENER);
            if (TasksUiPlugin.getTaskListManager().isTaskListInitialized()) {
                this.initContextChangeSets();
            }
            for (ActiveChangeSetManager collector : this.collectors) {
                collector.addListener(this.CHANGE_SET_LISTENER);
            }
            this.isEnabled = true;
        }
    }

    public void disable() {
        ContextCorePlugin.getContextManager().removeListener((IMylarContextListener)this);
        TasksUiPlugin.getTaskListManager().removeActivityListener(this.TASK_ACTIVITY_LISTENER);
        TasksUiPlugin.getTaskListManager().getTaskList().removeChangeListener(this.TASK_CHANGE_LISTENER);
        for (ActiveChangeSetManager collector : this.collectors) {
            collector.removeListener(this.CHANGE_SET_LISTENER);
        }
        this.isEnabled = false;
    }

    private void initContextChangeSets() {
        for (ActiveChangeSetManager collector : this.collectors) {
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet restoredSet = sets[i];
                if (!(restoredSet instanceof ContextChangeSet)) {
                    String encodedTitle = restoredSet.getName();
                    String taskHandle = ContextChangeSet.getHandleFromPersistedTitle(encodedTitle);
                    ITask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(taskHandle);
                    if (task != null) {
                        try {
                            ContextChangeSet contextChangeSet = new ContextChangeSet(task, collector);
                            contextChangeSet.restoreResources(restoredSet.getResources());
                            collector.remove(restoredSet);
                            collector.add((ChangeSet)contextChangeSet);
                        }
                        catch (Exception e) {
                            MylarStatusHandler.fail((Throwable)e, (String)"could not restore change set", (boolean)false);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void clearActiveChangeSets() {
        this.activeChangeSets.clear();
    }

    public IResource[] getResources(ITask task) {
        for (ActiveChangeSetManager collector : this.collectors) {
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                ContextChangeSet contextChangeSet;
                ChangeSet set = sets[i];
                if (set instanceof ContextChangeSet && (contextChangeSet = (ContextChangeSet)set).getTask().equals(task)) {
                    return contextChangeSet.getResources();
                }
                ++i;
            }
        }
        return null;
    }

    public void contextActivated(IMylarContext context) {
        try {
            ITask task = this.getTask(context);
            if (task != null && !this.activeChangeSets.containsKey(task.getHandleIdentifier())) {
                for (ActiveChangeSetManager collector : this.collectors) {
                    ContextChangeSet contextChangeSet = new ContextChangeSet(task, collector);
                    List interestingResources = MylarResourcesPlugin.getDefault().getInterestingResources();
                    contextChangeSet.add(interestingResources.toArray(new IResource[interestingResources.size()]));
                    this.activeChangeSets.put(task.getHandleIdentifier(), contextChangeSet);
                    if (collector.contains((ChangeSet)contextChangeSet)) continue;
                    collector.add((ChangeSet)contextChangeSet);
                }
            }
        }
        catch (Exception e) {
            MylarStatusHandler.fail((Throwable)e, (String)"could not update change set", (boolean)false);
        }
    }

    public void contextDeactivated(IMylarContext context) {
        for (ActiveChangeSetManager collector : this.collectors) {
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                IResource[] resources;
                ChangeSet set = sets[i];
                if (set instanceof ContextChangeSet && ((resources = set.getResources()) == null || resources.length == 0)) {
                    collector.remove(set);
                }
                ++i;
            }
        }
        this.activeChangeSets.clear();
    }

    public List<ContextChangeSet> getActiveChangeSets() {
        return new ArrayList<ContextChangeSet>(this.activeChangeSets.values());
    }

    private ITask getTask(IMylarContext context) {
        List activeTasks = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTasks();
        if (activeTasks.size() > 0) {
            return (ITask)activeTasks.get(0);
        }
        return null;
    }

    private boolean shouldRemove(IMylarElement element) {
        return element.getInterest().getValue() + element.getInterest().getDecayValue() < MylarContextManager.getScalingFactors().getInteresting();
    }

    public void interestChanged(List<IMylarElement> elements) {
        for (IMylarElement element : elements) {
            IMylarStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
            try {
                IResource resource;
                if (!bridge.isDocument(element.getHandleIdentifier()) || (resource = MylarResourcesPlugin.getDefault().getResourceForElement(element, false)) == null || !resource.exists()) continue;
                for (ContextChangeSet activeContextChangeSet : this.getActiveChangeSets()) {
                    if (activeContextChangeSet.contains(resource) || !element.getInterest().isInteresting()) continue;
                    activeContextChangeSet.add(new IResource[]{resource});
                }
                if (!this.shouldRemove(element)) continue;
                for (ActiveChangeSetManager collector : this.collectors) {
                    ChangeSet[] sets = collector.getSets();
                    int i = 0;
                    while (i < sets.length) {
                        if (sets[i] instanceof ContextChangeSet) {
                            sets[i].remove(resource);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                MylarStatusHandler.fail((Throwable)e, (String)"could not manipulate change set resources", (boolean)false);
            }
        }
    }

    public void nodeDeleted(IMylarElement node) {
    }

    public void landmarkAdded(IMylarElement node) {
    }

    public void landmarkRemoved(IMylarElement node) {
    }

    public void edgesChanged(IMylarElement node) {
    }

    public void presentationSettingsChanging(IMylarContextListener.UpdateKind kind) {
    }

    public void presentationSettingsChanged(IMylarContextListener.UpdateKind kind) {
    }
}

