/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.team;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylar.context.core.MylarStatusHandler;
import org.eclipse.mylar.team.AbstractTeamRepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamRespositoriesManager {
    private static final String ATTR_CLASS = "class";
    private static final String ELEM_REPOSITORY_PROVIDER = "repository";
    private static final String EXT_POINT_TEAM_REPOSITORY_PROVIDER = "providers";
    private static TeamRespositoriesManager sharedInstance;
    private List<AbstractTeamRepositoryProvider> provider;

    public static TeamRespositoriesManager getInstance() {
        if (sharedInstance == null) {
            TeamRespositoriesManager.initialize();
        }
        return sharedInstance;
    }

    private static synchronized void initialize() {
        if (sharedInstance != null) {
            return;
        }
        sharedInstance = new TeamRespositoriesManager();
    }

    private TeamRespositoriesManager() {
        this.readExtensions();
    }

    private void readExtensions() {
        ArrayList<AbstractTeamRepositoryProvider> providerList = new ArrayList<AbstractTeamRepositoryProvider>();
        IExtensionPoint teamProvider = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.mylar.team", EXT_POINT_TEAM_REPOSITORY_PROVIDER);
        IExtension[] extensions = teamProvider.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (ELEM_REPOSITORY_PROVIDER.equals(element.getName())) {
                    try {
                        AbstractTeamRepositoryProvider provider = (AbstractTeamRepositoryProvider)element.createExecutableExtension(ATTR_CLASS);
                        providerList.add(provider);
                    }
                    catch (CoreException e) {
                        MylarStatusHandler.log((Throwable)e, (String)MessageFormat.format("Error while initializing repository contribution {0} from plugin {1}.", element.getAttribute(ATTR_CLASS), element.getContributor().getName()));
                    }
                }
                ++j;
            }
            ++i;
        }
        providerList.trimToSize();
        this.provider = Collections.unmodifiableList(providerList);
    }

    public List<AbstractTeamRepositoryProvider> getProviders() {
        return this.provider;
    }
}

