/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.team.ccvs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylar.internal.team.ui.wizards.CommitContextWizard;
import org.eclipse.mylar.team.AbstractTeamRepositoryProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.mapping.CVSActiveChangeSetCollector;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.ui.PlatformUI;

public class CvsRepositoryProvider
extends AbstractTeamRepositoryProvider {
    private static final String WIZARD_LABEL = "Commit Resources in Task Context";

    public ActiveChangeSetManager getActiveChangeSetManager() {
        return (CVSActiveChangeSetCollector)CVSUIPlugin.getPlugin().getChangeSetManager();
    }

    public boolean hasOutgoingChanges(IResource[] resources) {
        try {
            CommitContextWizard wizard = new CommitContextWizard(resources, null);
            return wizard.hasOutgoingChanges();
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public void commit(IResource[] resources) {
        try {
            CommitContextWizard wizard = new CommitContextWizard(resources, null);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell != null && !shell.isDisposed() && wizard.hasOutgoingChanges()) {
                wizard.loadSize();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.setMinimumPageSize(wizard.loadSize());
                dialog.create();
                dialog.setTitle(WIZARD_LABEL);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 1) {
                    dialog.close();
                }
            }
        }
        catch (CVSException cVSException) {}
    }
}

