/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.team.template;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylar.context.core.MylarStatusHandler;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.team.AbstractCommitTemplateVariable;
import org.eclipse.mylar.team.MylarTeamPlugin;

public class CommitTemplateManager {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_RECOGNIZED_KEYWORD = "recognizedKeyword";
    private static final String ELEM_TEMPLATE_HANDLER = "templateVariable";
    private static final String EXT_POINT_TEMPLATE_HANDLERS = "commitTemplates";

    public String generateComment(ITask task, String template) {
        return this.processKeywords(task, template);
    }

    public String getTaskIdFromCommentOrLabel(String commentOrLabel) {
        String id = this.getTaskIdFromComment(commentOrLabel);
        return id;
    }

    private String getTaskIdFromComment(String comment) {
        try {
            Pattern pattern;
            Matcher matcher;
            String template = MylarTeamPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylar.team.commit.template");
            int templateNewline = template.indexOf(10);
            String templateFirstLineIndex = template;
            if (templateNewline != -1) {
                templateFirstLineIndex = template.substring(0, templateNewline - 1);
            }
            String regex = this.getTaskIdRegEx(templateFirstLineIndex);
            int commentNewlineIndex = comment.indexOf(10);
            String commentFirstLine = comment;
            if (commentNewlineIndex != -1) {
                commentFirstLine = comment.substring(0, commentNewlineIndex);
            }
            if ((matcher = (pattern = Pattern.compile(regex)).matcher(commentFirstLine)).find()) {
                return matcher.group(1);
            }
        }
        catch (Exception ex) {
            MylarStatusHandler.log((Throwable)ex, (String)"Problem while parsing task id from comment");
        }
        return null;
    }

    public String getTaskIdRegEx(String template) {
        template = template.replaceFirst("\\$\\{task\\.id\\}", "\uffff");
        template = this.replaceKeywords(template, "\ufffe");
        template = this.quoteChars(template, " $()*+.< [\\]^{|}");
        template = template.replaceFirst("\uffff", "(\\\\d+)");
        template = template.replaceAll("\ufffe", ".*");
        return template;
    }

    private String replaceKeywords(String str, String placeholder) {
        String[] recognizedKeywords;
        String[] stringArray = recognizedKeywords = this.getRecognizedKeywords();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String keyword = stringArray[n];
            str = str.replaceAll("\\$\\{" + keyword + "\\}", placeholder);
            ++n;
        }
        return str;
    }

    private String quoteChars(String str, String charsToQuote) {
        StringBuilder builder = new StringBuilder(str.length() * 2);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (charsToQuote.indexOf(c) != -1) {
                builder.append('\\');
            }
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }

    public String[] getRecognizedKeywords() {
        final ArrayList result = new ArrayList();
        new ExtensionProcessor(){

            protected Object processContribution(IConfigurationElement element, String keyword, String description, String className) throws Exception {
                result.add(keyword);
                return null;
            }
        }.run();
        return result.toArray(new String[result.size()]);
    }

    public String getHandlerDescription(final String keyword) {
        return (String)new ExtensionProcessor(){

            protected Object processContribution(IConfigurationElement element, String foundKeyword, String description, String className) throws Exception {
                return keyword.equals(foundKeyword) ? description : null;
            }
        }.run();
    }

    public AbstractCommitTemplateVariable createHandler(final String keyword) {
        return (AbstractCommitTemplateVariable)new ExtensionProcessor(){

            protected Object processContribution(IConfigurationElement element, String foundKeyword, String description, String className) throws Exception {
                if (keyword.equals(foundKeyword)) {
                    AbstractCommitTemplateVariable handler = (AbstractCommitTemplateVariable)element.createExecutableExtension(CommitTemplateManager.ATTR_CLASS);
                    if (handler instanceof AbstractCommitTemplateVariable) {
                        handler.setDescription(description);
                        handler.setRecognizedKeyword(foundKeyword);
                    } else {
                        String recognizedKeyword = handler.getRecognizedKeyword();
                        if (recognizedKeyword == null || !recognizedKeyword.equals(foundKeyword)) {
                            throw new IllegalArgumentException("Keyword markup does not match handler implementation");
                        }
                    }
                    return handler;
                }
                return null;
            }
        }.run();
    }

    private String processKeywords(ITask task, String template) {
        String[] segments = template.split("\\$\\{");
        StringBuffer buffer = new StringBuffer(segments[0]);
        int i = 1;
        while (i < segments.length) {
            String segment = segments[i];
            String value = null;
            int brace = segment.indexOf(125);
            if (brace > 0) {
                String keyword = segment.substring(0, brace);
                value = this.processKeyword(task, keyword);
            }
            if (value != null) {
                buffer.append(value);
                buffer.append(segment.substring(brace + 1));
            }
            ++i;
        }
        return buffer.toString();
    }

    private String processKeyword(ITask task, String keyword) {
        try {
            AbstractCommitTemplateVariable handler = this.createHandler(keyword);
            if (handler != null) {
                return handler.getValue(task);
            }
        }
        catch (Exception ex) {
            MylarStatusHandler.log((Throwable)ex, (String)("Problem while dispatching to template handler for: " + keyword));
        }
        return null;
    }

    private static class ExtensionProcessor {
        private ExtensionProcessor() {
        }

        public Object run() {
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.mylar.team", CommitTemplateManager.EXT_POINT_TEMPLATE_HANDLERS);
            IExtension[] extensions = extPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (CommitTemplateManager.ELEM_TEMPLATE_HANDLER.equals(element.getName())) {
                        try {
                            Object result = this.processContribution(element);
                            if (result != null) {
                                return result;
                            }
                        }
                        catch (Exception ex) {
                            String msg = MessageFormat.format("Error while processing template handler contribution {0} from plugin {1}.", element.getAttribute(CommitTemplateManager.ATTR_CLASS), element.getContributor().getName());
                            MylarStatusHandler.log((Throwable)ex, (String)msg);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        protected Object processContribution(IConfigurationElement element) throws Exception {
            String keyword = element.getAttribute(CommitTemplateManager.ATTR_RECOGNIZED_KEYWORD);
            String description = element.getAttribute(CommitTemplateManager.ATTR_DESCRIPTION);
            String className = element.getAttribute(CommitTemplateManager.ATTR_CLASS);
            return this.processContribution(element, keyword, description, className);
        }

        protected Object processContribution(IConfigurationElement element, String keyword, String description, String className) throws Exception {
            return null;
        }
    }
}

