/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.team.template;

import java.util.Date;
import java.util.List;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.team.AbstractCommitTemplateVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTemplateVariables {
    public static String implode(List<String> list, String separator) {
        StringBuilder builder = new StringBuilder();
        for (String cc : list) {
            if (builder.length() != 0) {
                builder.append(separator);
            }
            builder.append(cc);
        }
        return builder.toString();
    }

    public static class ConnectorTaskPrefix
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            AbstractRepositoryConnector connector;
            if (task instanceof AbstractRepositoryTask && (connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector((AbstractRepositoryTask)task)) != null) {
                return connector.getTaskIdPrefix();
            }
            return null;
        }
    }

    public static class RepositoryKind
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getRepositoryKind();
            }
            return null;
        }
    }

    public static class RepositoryUrl
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getRepositoryUrl();
            }
            return null;
        }
    }

    public static class TaskProduct
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getTaskData().getProduct();
            }
            return null;
        }
    }

    public static class TaskAssignee
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getTaskData().getAssignedTo();
            }
            return null;
        }
    }

    public static class TaskReporter
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getTaskData().getReporter();
            }
            return null;
        }
    }

    public static class TaskResolution
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getTaskData().getResolution();
            }
            return null;
        }
    }

    public static class TaskStatus
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask && ((AbstractRepositoryTask)task).getTaskData() != null) {
                return ((AbstractRepositoryTask)task).getTaskData().getStatus().toUpperCase();
            }
            if (task.isCompleted()) {
                return "Complete";
            }
            return "Incomplete";
        }
    }

    public static class TaskCc
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                List list = ((AbstractRepositoryTask)task).getTaskData().getCC();
                return CommitTemplateVariables.implode(list, ", ");
            }
            return null;
        }
    }

    public static class TaskKeywords
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                List list = ((AbstractRepositoryTask)task).getTaskData().getKeywords();
                return CommitTemplateVariables.implode(list, ", ");
            }
            return null;
        }
    }

    public static class TaskLastModified
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getTaskData().getLastModified();
            }
            return null;
        }
    }

    public static class TaskSummary
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return ((AbstractRepositoryTask)task).getTaskData().getSummary();
            }
            return task.getDescription();
        }
    }

    public static class TaskDescription
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            return task.getDescription();
        }
    }

    public static class TaskHandle
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            return task.getHandleIdentifier();
        }
    }

    public static class TaskId
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            if (task instanceof AbstractRepositoryTask) {
                return AbstractRepositoryTask.getTaskId((String)task.getHandleIdentifier());
            }
            return null;
        }
    }

    public static class TaskNotes
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            return task.getNotes();
        }
    }

    public static class TaskPriority
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            return task.getPriority();
        }
    }

    public static class TaskType
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            return task.getTaskType();
        }
    }

    public static class TaskURL
    extends AbstractCommitTemplateVariable {
        public String getValue(ITask task) {
            return task.getUrl();
        }
    }

    protected static abstract class CommitTemplateDate
    extends AbstractCommitTemplateVariable {
        protected CommitTemplateDate() {
        }

        public String getValue(ITask task) {
            Date date = this.getDate(task);
            return this.formatDate(date);
        }

        protected String formatDate(Date date) {
            return date.toString();
        }

        protected abstract Date getDate(ITask var1);

        public static class TaskCompletion
        extends CommitTemplateDate {
            protected Date getDate(ITask task) {
                return task.getCompletionDate();
            }
        }

        public static class TaskCreation
        extends CommitTemplateDate {
            protected Date getDate(ITask task) {
                return task.getCreationDate();
            }
        }

        public static class TaskReminder
        extends CommitTemplateDate {
            protected Date getDate(ITask task) {
                return task.getReminderDate();
            }
        }
    }
}

