/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.team.ui.actions;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylar.internal.tasks.ui.TaskListImages;
import org.eclipse.mylar.internal.tasks.ui.TaskUiUtil;
import org.eclipse.mylar.internal.team.ContextChangeSet;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.team.MylarTeamPlugin;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.mapping.CVSCheckedInChangeSet;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.ObjectPluginAction;

public class OpenCorrespondingTaskAction
extends Action
implements IViewActionDelegate {
    private static final String LABEL = "Open Corresponding Task";
    private ISelection selection;
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";

    public OpenCorrespondingTaskAction() {
        this.setText(LABEL);
        this.setToolTipText(LABEL);
        this.setImageDescriptor(TaskListImages.TASK_REPOSITORY);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        if (this.selection instanceof StructuredSelection) {
            this.run((StructuredSelection)this.selection);
        }
    }

    public void run(IAction action) {
        ObjectPluginAction objectAction;
        if (action instanceof ObjectPluginAction && (objectAction = (ObjectPluginAction)action).getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)objectAction.getSelection();
            this.run(selection);
        }
    }

    private void run(StructuredSelection selection) {
        ITask task;
        Object element = selection.getFirstElement();
        boolean opened = false;
        if (element instanceof ChangeSetDiffNode) {
            ChangeSetDiffNode diffNode = (ChangeSetDiffNode)element;
            if (diffNode.getSet() instanceof ContextChangeSet) {
                ITask task2 = ((ContextChangeSet)diffNode.getSet()).getTask();
                TaskUiUtil.openEditor((ITask)task2, (boolean)false);
                opened = true;
            }
        } else if (element instanceof ContextChangeSet && (task = ((ContextChangeSet)((Object)element)).getTask()) != null) {
            TaskUiUtil.openEditor((ITask)task, (boolean)false);
            opened = true;
        }
        if (!opened) {
            IProject project = this.findCorrespondingProject(element);
            String comment = this.getCommentFromSelection(element);
            if (comment != null) {
                AbstractRepositoryConnectorUi connectorUi;
                TaskRepository repository;
                String id = MylarTeamPlugin.getDefault().getCommitTemplateManager().getTaskIdFromCommentOrLabel(comment);
                if (id == null) {
                    id = OpenCorrespondingTaskAction.getTaskIdFromLegacy07Label(comment);
                }
                if (project != null && (repository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)project, false)) != null && (connectorUi = TasksUiPlugin.getRepositoryUi((String)repository.getKind())) != null && id != null) {
                    opened = TaskUiUtil.openRepositoryTask((TaskRepository)repository, (String)id);
                }
                if (!opened) {
                    String fullUrl = OpenCorrespondingTaskAction.getUrlFromComment(comment);
                    String repositoryUrl = null;
                    if (fullUrl != null) {
                        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryForTaskUrl(fullUrl);
                        if (connector != null) {
                            repositoryUrl = connector.getRepositoryUrlFromTaskUrl(fullUrl);
                        }
                    } else {
                        ITask task3 = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
                        if (task3 instanceof AbstractRepositoryTask) {
                            repositoryUrl = ((AbstractRepositoryTask)task3).getRepositoryUrl();
                        } else if (TasksUiPlugin.getRepositoryManager().getAllRepositories().size() == 1) {
                            repositoryUrl = ((TaskRepository)TasksUiPlugin.getRepositoryManager().getAllRepositories().get(0)).getUrl();
                        }
                    }
                    if (!(opened = TaskUiUtil.openRepositoryTask((String)repositoryUrl, (String)id, (String)fullUrl))) {
                        TaskUiUtil.openUrl((String)fullUrl);
                    }
                }
            }
        }
    }

    private String getCommentFromSelection(Object element) {
        if (element instanceof DiffChangeSet) {
            return ((CVSCheckedInChangeSet)element).getComment();
        }
        if (element instanceof ChangeSetDiffNode) {
            return ((ChangeSetDiffNode)element).getName();
        }
        if (element instanceof LogEntry) {
            return ((LogEntry)element).getComment();
        }
        if (element instanceof IFileRevision) {
            return ((IFileRevision)element).getComment();
        }
        return null;
    }

    private IProject findCorrespondingProject(Object element) {
        IResourceVariant resourceVariant;
        if (element instanceof DiffChangeSet) {
            IResource[] resources = ((DiffChangeSet)element).getResources();
            if (resources.length > 0) {
                return resources[0].getProject();
            }
        } else if (element instanceof SynchronizeModelElement) {
            SynchronizeModelElement modelElement = (SynchronizeModelElement)element;
            IResource resource = modelElement.getResource();
            if (resource != null) {
                return resource.getProject();
            }
            IDiffElement[] elements = modelElement.getChildren();
            if (elements.length > 0 && elements[0] instanceof SynchronizeModelElement) {
                return ((SynchronizeModelElement)elements[0]).getResource().getProject();
            }
        } else if (element instanceof IAdaptable && (resourceVariant = (IResourceVariant)((IAdaptable)element).getAdapter(IResourceVariant.class)) != null && resourceVariant instanceof RemoteResource) {
            RemoteResource remoteResource = (RemoteResource)resourceVariant;
            String path = remoteResource.getRepositoryRelativePath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.getProject(new Path(path).removeFirstSegments(1).uptoSegment(1).toString());
        }
        return null;
    }

    public static String getUrlFromComment(String comment) {
        int httpIndex = comment.indexOf(PREFIX_HTTP);
        int httpsIndex = comment.indexOf(PREFIX_HTTPS);
        int idStart = -1;
        if (httpIndex != -1) {
            idStart = httpIndex;
        } else if (httpsIndex != -1) {
            idStart = httpsIndex;
        }
        if (idStart != -1) {
            int idEnd = comment.indexOf(32, idStart);
            if (idEnd == -1) {
                return comment.substring(idStart);
            }
            if (idEnd != -1 && idStart < idEnd) {
                return comment.substring(idStart, idEnd);
            }
        }
        return null;
    }

    public static String getTaskIdFromLegacy07Label(String comment) {
        String PREFIX_DELIM = ":";
        String PREFIX_START_1 = "Progress on:";
        String PREFIX_START_2 = "Completed:";
        String usedPrefix = PREFIX_START_1;
        int firstDelimIndex = comment.indexOf(PREFIX_START_1);
        if (firstDelimIndex == -1) {
            firstDelimIndex = comment.indexOf(PREFIX_START_2);
            usedPrefix = PREFIX_START_2;
        }
        if (firstDelimIndex != -1) {
            int idStart = firstDelimIndex + usedPrefix.length();
            int idEnd = comment.indexOf(PREFIX_DELIM, firstDelimIndex + usedPrefix.length());
            if (idEnd != -1 && idStart < idEnd) {
                String id = comment.substring(idStart, idEnd);
                if (id != null) {
                    return id.trim();
                }
            } else {
                return comment.substring(0, firstDelimIndex);
            }
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

