/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.team.ui.preferences;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylar.internal.team.template.TemplateHandlerContentProposalProvider;
import org.eclipse.mylar.team.MylarTeamPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.fieldassist.ContentAssistField;

public class MylarTeamPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button manageChangeSets;
    private Text commitTemplate = null;

    public MylarTeamPreferencePage() {
        this.setPreferenceStore(MylarTeamPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createChangeSetGroup(container);
        this.createCommitGroup(container);
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylar.team.commit.template", this.commitTemplate.getText());
        this.getPreferenceStore().setValue("org.eclipse.mylar.team.changesets.manage", this.manageChangeSets.getSelection());
        if (this.manageChangeSets.getSelection()) {
            MylarTeamPlugin.getDefault().getChangeSetManager().enable();
        } else {
            MylarTeamPlugin.getDefault().getChangeSetManager().disable();
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.commitTemplate.setText(this.getPreferenceStore().getDefaultString("org.eclipse.mylar.team.commit.template"));
        this.manageChangeSets.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylar.team.changesets.manage"));
    }

    private void createChangeSetGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Change Set Management");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.manageChangeSets = new Button((Composite)group, 32);
        this.manageChangeSets.setText("Automatically create and manage with task context");
        this.manageChangeSets.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.team.changesets.manage"));
    }

    private void createCommitGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Commit Comment Template");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        String completedTemplate = this.getPreferenceStore().getString("org.eclipse.mylar.team.commit.template");
        this.commitTemplate = this.addTemplateField((Composite)group, completedTemplate, new TemplateHandlerContentProposalProvider());
    }

    private Text addTemplateField(Composite parent, final String text, IContentProposalProvider provider) {
        TextContentAdapter adapter = new TextContentAdapter();
        IControlCreator controlCreator = new IControlCreator(){

            public Control createControl(Composite parent, int style) {
                Text control = new Text(parent, style);
                control.setText(text);
                return control;
            }
        };
        ContentAssistField field = new ContentAssistField(parent, 2050, controlCreator, (IControlContentAdapter)adapter, provider, null, new char[]{'$'});
        GridData gd = new GridData();
        gd.heightHint = 60;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        gd.grabExcessVerticalSpace = false;
        field.getLayoutControl().setLayoutData((Object)gd);
        return (Text)field.getControl();
    }
}

