/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.team;

import org.eclipse.mylar.context.core.MylarStatusHandler;
import org.eclipse.mylar.internal.team.ContextChangeSetManager;
import org.eclipse.mylar.internal.team.template.CommitTemplateManager;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MylarTeamPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.mylar.team";
    private static MylarTeamPlugin INSTANCE;
    private ContextChangeSetManager changeSetManager;
    private CommitTemplateManager commitTemplateManager;
    public static final String CHANGE_SET_MANAGE = "org.eclipse.mylar.team.changesets.manage";
    public static final String COMMIT_TEMPLATE = "org.eclipse.mylar.team.commit.template";
    public static final String DEFAULT_COMMIT_TEMPLATE = "${task.status} - ${connector.task.prefix} ${task.id}: ${task.description} \n${task.url}";

    public MylarTeamPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initPreferenceDefaults();
        this.commitTemplateManager = new CommitTemplateManager();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    MylarTeamPlugin.this.changeSetManager = new ContextChangeSetManager();
                    if (MylarTeamPlugin.this.getPreferenceStore().getBoolean(MylarTeamPlugin.CHANGE_SET_MANAGE)) {
                        MylarTeamPlugin.this.changeSetManager.enable();
                    }
                }
                catch (Exception e) {
                    MylarStatusHandler.fail((Throwable)e, (String)"Mylar Team start failed", (boolean)false);
                }
            }
        });
    }

    public void earlyStartup() {
    }

    public void stop(BundleContext context) throws Exception {
        INSTANCE = null;
        super.stop(context);
        this.changeSetManager.disable();
    }

    private void initPreferenceDefaults() {
        this.getPreferenceStore().setDefault(CHANGE_SET_MANAGE, true);
        this.getPreferenceStore().setDefault(COMMIT_TEMPLATE, DEFAULT_COMMIT_TEMPLATE);
    }

    public static MylarTeamPlugin getDefault() {
        return INSTANCE;
    }

    public ContextChangeSetManager getChangeSetManager() {
        return this.changeSetManager;
    }

    public CommitTemplateManager getCommitTemplateManager() {
        return this.commitTemplateManager;
    }

    public void setChangeSetManager(ContextChangeSetManager changeSetManager) {
        this.changeSetManager = changeSetManager;
    }
}

