/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.editor;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylar.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylar.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.RepositoryOperation;
import org.eclipse.mylar.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylar.tasks.core.TaskComment;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.DatePicker;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.TasksUiUtil;
import org.eclipse.mylar.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylar.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.mylar.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.themes.IThemeManager;

public class BugzillaTaskEditor
extends AbstractRepositoryTaskEditor {
    private static final String LABEL_TIME_TRACKING = "Bugzilla Time Tracking";
    protected org.eclipse.swt.widgets.List keyWordsList;
    protected Text keywordsText;
    protected Text estimateText;
    protected Text actualText;
    protected Text remainingText;
    protected Text addTimeText;
    protected Text deadlineText;
    protected DatePicker deadlinePicker;
    protected Text votesText;

    public BugzillaTaskEditor(FormEditor editor) {
        super(editor);
    }

    protected void createCustomAttributeLayout(Composite composite) {
        Label label;
        boolean addHyperlinks;
        Text text;
        GridData textData;
        GridLayout textLayout;
        Composite textFieldComposite;
        Label label2;
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(BugzillaReportElement.DEPENDSON.getKeyString());
        if (attribute != null && !attribute.isReadOnly()) {
            label2 = this.createLabel(composite, attribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label2);
            textFieldComposite = this.toolkit.createComposite(composite);
            textLayout = new GridLayout();
            textLayout.marginWidth = 1;
            textLayout.marginHeight = 3;
            textLayout.verticalSpacing = 3;
            textFieldComposite.setLayout((Layout)textLayout);
            textData = new GridData(256);
            textData.horizontalSpan = 1;
            textData.widthHint = 135;
            text = this.createTextField(textFieldComposite, attribute, 0x800000);
            text.setLayoutData((Object)textData);
            this.toolkit.paintBordersFor(textFieldComposite);
        }
        if ((attribute = this.taskData.getAttribute(BugzillaReportElement.BLOCKED.getKeyString())) != null && !attribute.isReadOnly()) {
            label2 = this.createLabel(composite, attribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label2);
            textFieldComposite = this.toolkit.createComposite(composite);
            textLayout = new GridLayout();
            textLayout.marginWidth = 1;
            textLayout.marginHeight = 3;
            textLayout.verticalSpacing = 3;
            textFieldComposite.setLayout((Layout)textLayout);
            textData = new GridData(256);
            textData.horizontalSpan = 1;
            textData.widthHint = 135;
            text = this.createTextField(textFieldComposite, attribute, 0x800000);
            text.setLayoutData((Object)textData);
            this.toolkit.paintBordersFor(textFieldComposite);
        }
        String dependson = this.taskData.getAttributeValue(BugzillaReportElement.DEPENDSON.getKeyString());
        String blocked = this.taskData.getAttributeValue(BugzillaReportElement.BLOCKED.getKeyString());
        boolean bl = addHyperlinks = dependson != null && dependson.length() > 0 || blocked != null && blocked.length() > 0;
        if (addHyperlinks) {
            this.toolkit.createLabel(composite, "");
            this.addBugHyperlinks(composite, BugzillaReportElement.DEPENDSON.getKeyString());
        }
        if (addHyperlinks) {
            this.toolkit.createLabel(composite, "");
            this.addBugHyperlinks(composite, BugzillaReportElement.BLOCKED.getKeyString());
        }
        try {
            this.addKeywordsList(composite);
        }
        catch (IOException e) {
            MessageDialog.openInformation(null, (String)"Attribute Display Error", (String)("Could not retrieve keyword list, ensure proper configuration in Task Repositories view\n\nError reported: " + e.getMessage()));
        }
        attribute = this.taskData.getAttribute(BugzillaReportElement.BUG_FILE_LOC.getKeyString());
        if (attribute != null && !attribute.isReadOnly()) {
            label = this.createLabel(composite, attribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            Text urlField = this.createTextField(composite, attribute, 0x800000);
            GridDataFactory.fillDefaults().hint(135, -1).applyTo((Control)urlField);
        }
        if ((attribute = this.taskData.getAttribute(BugzillaReportElement.STATUS_WHITEBOARD.getKeyString())) == null) {
            this.taskData.setAttributeValue(BugzillaReportElement.STATUS_WHITEBOARD.getKeyString(), "");
            attribute = this.taskData.getAttribute(BugzillaReportElement.STATUS_WHITEBOARD.getKeyString());
        }
        if (attribute != null && !attribute.isReadOnly()) {
            label = this.createLabel(composite, attribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            Text whiteboardField = this.createTextField(composite, attribute, 0x800000);
            GridDataFactory.fillDefaults().hint(135, -1).applyTo((Control)whiteboardField);
        }
        this.addVoting(composite);
        if (this.taskData.getAttribute(BugzillaReportElement.GROUP.getKeyString()) != null) {
            this.addRoles(composite);
        }
        if (this.taskData.getAttribute(BugzillaReportElement.ESTIMATED_TIME.getKeyString()) != null) {
            this.addBugzillaTimeTracker(this.toolkit, composite);
        }
    }

    private boolean hasCustomAttributeChanges() {
        String[] customAttributeKeys;
        if (this.taskData == null) {
            return false;
        }
        String[] stringArray = customAttributeKeys = new String[]{BugzillaReportElement.BUG_FILE_LOC.getKeyString(), BugzillaReportElement.DEPENDSON.getKeyString(), BugzillaReportElement.BLOCKED.getKeyString(), BugzillaReportElement.KEYWORDS.getKeyString(), BugzillaReportElement.VOTES.getKeyString(), BugzillaReportElement.REPORTER_ACCESSIBLE.getKeyString(), BugzillaReportElement.CCLIST_ACCESSIBLE.getKeyString(), BugzillaReportElement.ESTIMATED_TIME.getKeyString(), BugzillaReportElement.REMAINING_TIME.getKeyString(), BugzillaReportElement.ACTUAL_TIME.getKeyString(), BugzillaReportElement.DEADLINE.getKeyString(), BugzillaReportElement.STATUS_WHITEBOARD.getKeyString()};
        int n = customAttributeKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            RepositoryTaskAttribute attribute = this.taskData.getAttribute(key);
            if (this.hasChanged(attribute)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean hasVisibleAttributeChanges() {
        return super.hasVisibleAttributeChanges() || this.hasCustomAttributeChanges();
    }

    private void addBugHyperlinks(Composite composite, String key) {
        Composite hyperlinksComposite = this.toolkit.createComposite(composite);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.spacing = 0;
        hyperlinksComposite.setLayout((Layout)new RowLayout());
        String values = this.taskData.getAttributeValue(key);
        if (values != null && values.length() > 0) {
            String[] stringArray = values.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String bugNumber = stringArray[n2];
                String bugId = bugNumber.trim();
                Hyperlink hyperlink = this.toolkit.createHyperlink(hyperlinksComposite, bugId, 0);
                AbstractRepositoryTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.repository.getUrl(), bugId);
                if (task != null) {
                    hyperlink.setToolTipText(task.getSummary());
                }
                hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((ITask)task, bugId){
                    private final /* synthetic */ ITask val$task;
                    private final /* synthetic */ String val$bugId;
                    {
                        this.val$task = iTask;
                        this.val$bugId = string;
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        if (this.val$task != null) {
                            TasksUiUtil.refreshAndOpenTaskListElement((ITaskListElement)this.val$task);
                        } else {
                            TasksUiUtil.openRepositoryTask((String)BugzillaTaskEditor.this.repository.getUrl(), (String)this.val$bugId, (String)(String.valueOf(BugzillaTaskEditor.this.repository.getUrl()) + "/show_bug.cgi?id=" + this.val$bugId));
                        }
                    }
                });
                ++n2;
            }
        }
    }

    protected void addRoles(Composite parent) {
        Section rolesSection = this.toolkit.createSection(parent, 512);
        rolesSection.setText("Users in the roles selected below can always view this bug");
        rolesSection.setDescription("(The assignee can always see a bug, and this section does not take effect unless the bug is restricted to at least one group.)");
        GridLayout gl = new GridLayout();
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 4;
        rolesSection.setLayout((Layout)gl);
        rolesSection.setLayoutData((Object)gd);
        Composite rolesComposite = this.toolkit.createComposite((Composite)rolesSection);
        GridLayout attributesLayout = new GridLayout();
        attributesLayout.numColumns = 4;
        attributesLayout.horizontalSpacing = 5;
        attributesLayout.verticalSpacing = 4;
        rolesComposite.setLayout((Layout)attributesLayout);
        GridData attributesData = new GridData(1808);
        attributesData.horizontalSpan = 1;
        attributesData.grabExcessVerticalSpace = false;
        rolesComposite.setLayoutData((Object)attributesData);
        rolesSection.setClient((Control)rolesComposite);
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(BugzillaReportElement.REPORTER_ACCESSIBLE.getKeyString());
        if (attribute == null) {
            this.taskData.setAttributeValue(BugzillaReportElement.REPORTER_ACCESSIBLE.getKeyString(), "0");
            attribute = this.taskData.getAttribute(BugzillaReportElement.REPORTER_ACCESSIBLE.getKeyString());
        }
        Button button = this.addButtonField(rolesComposite, attribute, 32);
        if (this.hasChanged(attribute)) {
            button.setBackground(this.backgroundIncoming);
        }
        attribute = null;
        attribute = this.taskData.getAttribute(BugzillaReportElement.CCLIST_ACCESSIBLE.getKeyString());
        if (attribute == null) {
            this.taskData.setAttributeValue(BugzillaReportElement.CCLIST_ACCESSIBLE.getKeyString(), "0");
            attribute = this.taskData.getAttribute(BugzillaReportElement.CCLIST_ACCESSIBLE.getKeyString());
        }
        button = this.addButtonField(rolesComposite, attribute, 32);
        if (this.hasChanged(attribute)) {
            button.setBackground(this.backgroundIncoming);
        }
    }

    protected boolean hasContentAssist(RepositoryTaskAttribute attribute) {
        return BugzillaReportElement.NEWCC.getKeyString().equals(attribute.getID());
    }

    protected boolean hasContentAssist(RepositoryOperation repositoryOperation) {
        IBugzillaConstants.BUGZILLA_OPERATION operation;
        try {
            operation = IBugzillaConstants.BUGZILLA_OPERATION.valueOf((String)repositoryOperation.getKnobName());
        }
        catch (RuntimeException e) {
            MylarStatusHandler.log((Throwable)e, (String)("Unrecognized operatoin: " + repositoryOperation.getKnobName()));
            operation = null;
        }
        return operation != null && operation == IBugzillaConstants.BUGZILLA_OPERATION.reassign;
    }

    private Button addButtonField(Composite rolesComposite, RepositoryTaskAttribute attribute, int style) {
        if (attribute == null) {
            return null;
        }
        String name = attribute.getName();
        if (this.hasOutgoingChange(attribute)) {
            name = String.valueOf(name) + "*";
        }
        final Button button = this.toolkit.createButton(rolesComposite, name, style);
        if (!attribute.isReadOnly()) {
            button.setData((Object)attribute);
            button.setSelection(attribute.getValue().equals("1"));
            button.setLayoutData((Object)new GridData(256));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String sel = "1";
                    if (!button.getSelection()) {
                        sel = "0";
                    }
                    RepositoryTaskAttribute a = (RepositoryTaskAttribute)button.getData();
                    a.setValue(sel);
                    BugzillaTaskEditor.this.attributeChanged(a);
                }
            });
        }
        return button;
    }

    protected void addBugzillaTimeTracker(FormToolkit toolkit, Composite parent) {
        Section timeSection = toolkit.createSection(parent, 512);
        timeSection.setText(LABEL_TIME_TRACKING);
        GridLayout gl = new GridLayout();
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 4;
        timeSection.setLayout((Layout)gl);
        timeSection.setLayoutData((Object)gd);
        Composite timeComposite = toolkit.createComposite((Composite)timeSection);
        gl = new GridLayout(4, false);
        timeComposite.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalSpan = 5;
        timeComposite.setLayoutData((Object)gd);
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(BugzillaReportElement.ESTIMATED_TIME.getKeyString());
        if (attribute != null && !attribute.isReadOnly()) {
            this.createLabel(timeComposite, attribute);
            this.estimateText = this.createTextField(timeComposite, attribute, 0x800000);
            this.estimateText.setLayoutData((Object)new GridData(256));
        }
        Label label = toolkit.createLabel(timeComposite, "Current Estimate:");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text currentEstimate = toolkit.createText(timeComposite, "" + (Float.parseFloat(this.taskData.getAttributeValue(BugzillaReportElement.ACTUAL_TIME.getKeyString())) + Float.parseFloat(this.taskData.getAttributeValue(BugzillaReportElement.REMAINING_TIME.getKeyString()))));
        currentEstimate.setFont(TEXT_FONT);
        currentEstimate.setLayoutData((Object)new GridData(256));
        currentEstimate.setEditable(false);
        attribute = this.taskData.getAttribute(BugzillaReportElement.ACTUAL_TIME.getKeyString());
        if (attribute != null) {
            this.createLabel(timeComposite, attribute);
            Text actualText = this.createTextField(timeComposite, attribute, 0x800000);
            actualText.setLayoutData((Object)new GridData(256));
            actualText.setEditable(false);
        }
        this.taskData.setAttributeValue(BugzillaReportElement.WORK_TIME.getKeyString(), "0");
        final RepositoryTaskAttribute addTimeAttribute = this.taskData.getAttribute(BugzillaReportElement.WORK_TIME.getKeyString());
        if (addTimeAttribute != null) {
            this.createLabel(timeComposite, addTimeAttribute);
            this.addTimeText = toolkit.createText(timeComposite, this.taskData.getAttributeValue(BugzillaReportElement.WORK_TIME.getKeyString()), 2048);
            this.addTimeText.setFont(TEXT_FONT);
            this.addTimeText.setLayoutData((Object)new GridData(256));
            this.addTimeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    addTimeAttribute.setValue(BugzillaTaskEditor.this.addTimeText.getText());
                    BugzillaTaskEditor.this.attributeChanged(addTimeAttribute);
                }
            });
        }
        if ((attribute = this.taskData.getAttribute(BugzillaReportElement.REMAINING_TIME.getKeyString())) != null) {
            this.createLabel(timeComposite, attribute);
            this.createTextField(timeComposite, attribute, 0x800000);
        }
        if ((attribute = this.taskData.getAttribute(BugzillaReportElement.DEADLINE.getKeyString())) != null) {
            this.createLabel(timeComposite, attribute);
            Composite dateWithClear = toolkit.createComposite(timeComposite);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 1;
            dateWithClear.setLayout((Layout)layout);
            this.deadlinePicker = new DatePicker(dateWithClear, 2048, this.taskData.getAttributeValue(BugzillaReportElement.DEADLINE.getKeyString()));
            this.deadlinePicker.setFont(TEXT_FONT);
            this.deadlinePicker.setDatePattern("yyyy-MM-dd");
            if (this.hasChanged(attribute)) {
                this.deadlinePicker.setBackground(this.backgroundIncoming);
            }
            this.deadlinePicker.addPickerSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Calendar cal = BugzillaTaskEditor.this.deadlinePicker.getDate();
                    if (cal != null) {
                        Date d = cal.getTime();
                        SimpleDateFormat f = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
                        f.applyPattern("yyyy-MM-dd");
                        BugzillaTaskEditor.this.taskData.setAttributeValue(BugzillaReportElement.DEADLINE.getKeyString(), f.format(d));
                        BugzillaTaskEditor.this.attributeChanged(BugzillaTaskEditor.this.taskData.getAttribute(BugzillaReportElement.DEADLINE.getKeyString()));
                    } else {
                        BugzillaTaskEditor.this.taskData.setAttributeValue(BugzillaReportElement.DEADLINE.getKeyString(), "");
                        BugzillaTaskEditor.this.attributeChanged(BugzillaTaskEditor.this.taskData.getAttribute(BugzillaReportElement.DEADLINE.getKeyString()));
                        BugzillaTaskEditor.this.deadlinePicker.setDate(null);
                    }
                }
            });
            ImageHyperlink clearDeadlineDate = toolkit.createImageHyperlink(dateWithClear, 0);
            clearDeadlineDate.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.REMOVE));
            clearDeadlineDate.setToolTipText("Clear");
            clearDeadlineDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    BugzillaTaskEditor.this.taskData.setAttributeValue(BugzillaReportElement.DEADLINE.getKeyString(), "");
                    BugzillaTaskEditor.this.attributeChanged(BugzillaTaskEditor.this.taskData.getAttribute(BugzillaReportElement.DEADLINE.getKeyString()));
                    BugzillaTaskEditor.this.deadlinePicker.setDate(null);
                }
            });
        }
        timeSection.setClient((Control)timeComposite);
    }

    protected void addKeywordsList(Composite attributesComposite) throws IOException {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute("task.common.keywords");
        if (attribute == null) {
            return;
        }
        String keywords = attribute.getValue();
        Label label = this.createLabel(attributesComposite, attribute);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        this.keywordsText = this.createTextField(attributesComposite, attribute, 0x800008);
        this.keywordsText.setFont(TEXT_FONT);
        this.keywordsText.setEditable(false);
        GridData keywordsData = new GridData(256);
        keywordsData.horizontalSpan = 2;
        keywordsData.widthHint = 200;
        this.keywordsText.setLayoutData((Object)keywordsData);
        this.keyWordsList = new org.eclipse.swt.widgets.List(attributesComposite, 514);
        this.keyWordsList.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.keyWordsList.setFont(TEXT_FONT);
        GridData keyWordsTextData = new GridData(256);
        keyWordsTextData.horizontalSpan = 1;
        keyWordsTextData.widthHint = 125;
        keyWordsTextData.heightHint = 40;
        this.keyWordsList.setLayoutData((Object)keyWordsTextData);
        List validKeywords = new ArrayList();
        try {
            validKeywords = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)this.repository, (boolean)false).getKeywords();
        }
        catch (Exception exception) {}
        if (validKeywords != null) {
            for (String keyword : validKeywords) {
                this.keyWordsList.add(keyword);
            }
            StringTokenizer st = new StringTokenizer(keywords, ",", false);
            ArrayList<Integer> indicies = new ArrayList<Integer>();
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                int index = this.keyWordsList.indexOf(s);
                if (index == -1) continue;
                indicies.add(new Integer(index));
            }
            int length = indicies.size();
            int[] sel = new int[length];
            int i = 0;
            while (i < length) {
                sel[i] = (Integer)indicies.get(i);
                ++i;
            }
            this.keyWordsList.select(sel);
        }
        this.keyWordsList.addSelectionListener((SelectionListener)new KeywordListener());
    }

    protected void addVoting(Composite attributesComposite) {
        Label label = this.toolkit.createLabel(attributesComposite, "Votes:");
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        Composite votingComposite = this.toolkit.createComposite(attributesComposite);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        votingComposite.setLayout((Layout)layout);
        RepositoryTaskAttribute votesAttribute = this.taskData.getAttribute(BugzillaReportElement.VOTES.getKeyString());
        this.votesText = this.createTextField(votingComposite, votesAttribute, 0x800008);
        this.votesText.setFont(TEXT_FONT);
        if (votesAttribute != null && this.hasChanged(votesAttribute)) {
            IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
            Color backgroundIncoming = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylar.tasks.ui.colors.category.gradient.end");
            this.votesText.setBackground(backgroundIncoming);
        }
        this.votesText.setEditable(false);
        Hyperlink showVotesHyperlink = this.toolkit.createHyperlink(votingComposite, "Show votes", 0);
        showVotesHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (BugzillaTaskEditor.this.getEditor() instanceof TaskEditor) {
                    TaskEditor mylarTaskEditor = (TaskEditor)BugzillaTaskEditor.this.getEditor();
                    mylarTaskEditor.displayInBrowser(String.valueOf(BugzillaTaskEditor.this.repository.getUrl()) + "/votes.cgi?action=show_bug&bug_id=" + BugzillaTaskEditor.this.taskData.getId());
                }
            }
        });
        Hyperlink voteHyperlink = this.toolkit.createHyperlink(votingComposite, "Vote", 0);
        voteHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (BugzillaTaskEditor.this.getEditor() instanceof TaskEditor) {
                    TaskEditor mylarTaskEditor = (TaskEditor)BugzillaTaskEditor.this.getEditor();
                    mylarTaskEditor.displayInBrowser(String.valueOf(BugzillaTaskEditor.this.repository.getUrl()) + "/votes.cgi?action=show_user&bug_id=" + BugzillaTaskEditor.this.taskData.getId());
                }
            }
        });
    }

    protected void validateInput() {
    }

    protected String getActivityUrl() {
        if (this.repository != null && this.taskData != null) {
            return String.valueOf(this.repository.getUrl()) + "/show_activity.cgi?id=" + this.taskData.getId();
        }
        return null;
    }

    protected class CommentListener
    implements Listener {
        private TaskComment taskComment;

        public CommentListener(TaskComment taskComment) {
            this.taskComment = taskComment;
        }

        public void handleEvent(Event event) {
            BugzillaTaskEditor.this.fireSelectionChanged(new SelectionChangedEvent(BugzillaTaskEditor.this.selectionProvider, (ISelection)new StructuredSelection((Object)new RepositoryTaskSelection(BugzillaTaskEditor.this.taskData.getId(), BugzillaTaskEditor.this.taskData.getRepositoryUrl(), BugzillaTaskEditor.this.taskData.getRepositoryKind(), this.taskComment.getCreated(), this.taskComment, BugzillaTaskEditor.this.taskData.getSummary()))));
        }
    }

    protected class KeywordListener
    implements SelectionListener {
        protected KeywordListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            BugzillaTaskEditor.this.markDirty(true);
            StringBuffer keywords = new StringBuffer();
            String[] sel = BugzillaTaskEditor.this.keyWordsList.getSelection();
            if (BugzillaTaskEditor.this.keyWordsList.getSelectionCount() == 1) {
                int index = BugzillaTaskEditor.this.keyWordsList.getSelectionIndex();
                String keyword = BugzillaTaskEditor.this.keyWordsList.getItem(index);
                if (BugzillaTaskEditor.this.taskData.getAttributeValue(BugzillaReportElement.KEYWORDS.getKeyString()).equals(keyword)) {
                    BugzillaTaskEditor.this.keyWordsList.deselectAll();
                }
            }
            int i = 0;
            while (i < BugzillaTaskEditor.this.keyWordsList.getSelectionCount()) {
                keywords.append(sel[i]);
                if (i != BugzillaTaskEditor.this.keyWordsList.getSelectionCount() - 1) {
                    keywords.append(",");
                }
                ++i;
            }
            BugzillaTaskEditor.this.taskData.setAttributeValue(BugzillaReportElement.KEYWORDS.getKeyString(), keywords.toString());
            BugzillaTaskEditor.this.keywordsText.setText(keywords.toString());
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    }
}

