/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.editor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.editors.AbstractNewRepositoryTaskEditor;
import org.eclipse.mylar.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylar.tasks.ui.search.SearchHitCollector;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NewBugzillaTaskEditor
extends AbstractNewRepositoryTaskEditor {
    private static final int WRAP_LENGTH = 90;

    public NewBugzillaTaskEditor(FormEditor editor) {
        super(editor);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.expandedStateAttributes = true;
    }

    protected void updateTask() {
        String text = this.descriptionTextViewer.getTextWidget().getText();
        if (this.repository.getVersion().startsWith("2.18")) {
            text = NewBugzillaTaskEditor.formatTextToLineWrap(text, true);
            this.descriptionTextViewer.getTextWidget().setText(text);
        }
        super.updateTask();
    }

    protected void createPeopleLayout(Composite composite) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section peopleSection = this.createSection(composite, this.getSectionLabel(AbstractRepositoryTaskEditor.SECTION_NAME.PEOPLE_SECTION));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)peopleSection);
        Composite peopleComposite = toolkit.createComposite((Composite)peopleSection);
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 5;
        peopleComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)peopleComposite);
        Label label = toolkit.createLabel(peopleComposite, "Assign to:");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        Composite textFieldComposite = toolkit.createComposite(peopleComposite);
        GridLayout textLayout = new GridLayout();
        textFieldComposite.setLayout((Layout)textLayout);
        Text textField = this.createTextField(textFieldComposite, this.taskData.getAttribute("task.common.user.assigned"), 0x800000);
        toolkit.paintBordersFor(textFieldComposite);
        GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)textField);
        peopleSection.setClient((Control)peopleComposite);
        toolkit.paintBordersFor(peopleComposite);
    }

    public SearchHitCollector getDuplicateSearchCollector(String searchString) {
        String queryUrl = "";
        try {
            queryUrl = String.valueOf(this.repository.getUrl()) + "/buglist.cgi?long_desc_type=allwordssubstr&long_desc=" + URLEncoder.encode(searchString, this.repository.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            MylarStatusHandler.log((Throwable)e, (String)"Error during duplicate detection");
            return null;
        }
        queryUrl = String.valueOf(queryUrl) + "&product=" + this.taskData.getProduct();
        BugzillaRepositoryQuery bugzillaQuery = new BugzillaRepositoryQuery(this.repository.getUrl(), queryUrl, "search", TasksUiPlugin.getTaskListManager().getTaskList());
        SearchHitCollector collector = new SearchHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), this.repository, (AbstractRepositoryQuery)bugzillaQuery);
        return collector;
    }

    public void submitToRepository() {
        if (this.summaryText.getText().equals("")) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)"Please provide a brief summary with new reports.");
            this.summaryText.setFocus();
            return;
        }
        if (this.descriptionTextViewer.getTextWidget().getText().equals("")) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)"Please proved a detailed summary with new reports");
            this.descriptionTextViewer.getTextWidget().setFocus();
            return;
        }
        super.submitToRepository();
    }

    private static String formatTextToLineWrap(String origText, boolean hardWrap) {
        if (!hardWrap) {
            return origText;
        }
        String[] textArray = new String[(origText.length() / 90 + 1) * 2];
        int i = 0;
        while (i < textArray.length) {
            textArray[i] = null;
            ++i;
        }
        int j = 0;
        while (true) {
            int spaceIndex;
            if ((spaceIndex = origText.indexOf(" ", 85)) == origText.length() || spaceIndex == -1) break;
            textArray[j] = origText.substring(0, spaceIndex);
            origText = origText.substring(spaceIndex + 1, origText.length());
            ++j;
        }
        textArray[j] = origText;
        String newText = "";
        int i2 = 0;
        while (i2 < textArray.length) {
            if (textArray[i2] == null) break;
            newText = String.valueOf(newText) + textArray[i2] + "\n";
            ++i2;
        }
        return newText;
    }
}

