/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.search;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylar.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.search.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.help.WorkbenchHelpSystem;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaSearchPage
extends AbstractRepositoryQueryPage
implements Listener {
    private static final String NUM_DAYS_POSITIVE = "Number of days must be a positive integer. ";
    private static final String TITLE_BUGZILLA_QUERY = "Bugzilla Query";
    private static final int HEIGHT_ATTRIBUTE_COMBO = 60;
    protected Combo summaryPattern = null;
    private static ArrayList<BugzillaSearchData> previousSummaryPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousEmailPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousCommentPatterns = new ArrayList(20);
    private boolean firstTime = true;
    private IDialogSettings fDialogSettings;
    private static final String[] patternOperationText = new String[]{"all words", "any word", "regexp"};
    private static final String[] patternOperationValues = new String[]{"allwordssubstr", "anywordssubstr", "regexp"};
    private static final String[] emailOperationText = new String[]{"substring", "exact", "regexp"};
    private static final String[] emailOperationValues = new String[]{"substring", "exact", "regexp"};
    private static final String[] emailRoleValues = new String[]{"emailassigned_to1", "emailreporter1", "emailcc1", "emaillongdesc1"};
    private BugzillaRepositoryQuery originalQuery = null;
    protected boolean restoring = false;
    private boolean restoreQueryOptions = true;
    private SelectionAdapter updateActionSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (BugzillaSearchPage.this.scontainer != null) {
                BugzillaSearchPage.this.scontainer.setPerformActionEnabled(BugzillaSearchPage.this.canQuery());
            }
        }
    };
    protected Text daysText;
    private static final String[] emailText = new String[]{"bug owner", "reporter", "CC list", "commenter"};
    protected static final String PAGE_NAME = "BugzillaSearchPage";
    private static final String STORE_PRODUCT_ID = "BugzillaSearchPage.PRODUCT";
    private static final String STORE_COMPONENT_ID = "BugzillaSearchPage.COMPONENT";
    private static final String STORE_VERSION_ID = "BugzillaSearchPage.VERSION";
    private static final String STORE_MSTONE_ID = "BugzillaSearchPage.MILESTONE";
    private static final String STORE_STATUS_ID = "BugzillaSearchPage.STATUS";
    private static final String STORE_RESOLUTION_ID = "BugzillaSearchPage.RESOLUTION";
    private static final String STORE_SEVERITY_ID = "BugzillaSearchPage.SEVERITY";
    private static final String STORE_PRIORITY_ID = "BugzillaSearchPage.PRIORITY";
    private static final String STORE_HARDWARE_ID = "BugzillaSearchPage.HARDWARE";
    private static final String STORE_OS_ID = "BugzillaSearchPage.OS";
    private static final String STORE_SUMMARYMATCH_ID = "BugzillaSearchPage.SUMMARYMATCH";
    private static final String STORE_COMMENTMATCH_ID = "BugzillaSearchPage.COMMENTMATCH";
    private static final String STORE_EMAILMATCH_ID = "BugzillaSearchPage.EMAILMATCH";
    private static final String STORE_EMAILBUTTON_ID = "BugzillaSearchPage.EMAILATTR";
    private static final String STORE_SUMMARYTEXT_ID = "BugzillaSearchPage.SUMMARYTEXT";
    private static final String STORE_COMMENTTEXT_ID = "BugzillaSearchPage.COMMENTTEXT";
    private static final String STORE_EMAILADDRESS_ID = "BugzillaSearchPage.EMAILADDRESS";
    protected Combo summaryOperation;
    protected org.eclipse.swt.widgets.List product;
    protected org.eclipse.swt.widgets.List os;
    protected org.eclipse.swt.widgets.List hardware;
    protected org.eclipse.swt.widgets.List priority;
    protected org.eclipse.swt.widgets.List severity;
    protected org.eclipse.swt.widgets.List resolution;
    protected org.eclipse.swt.widgets.List status;
    protected Combo commentOperation;
    protected Combo commentPattern;
    protected org.eclipse.swt.widgets.List component;
    protected org.eclipse.swt.widgets.List version;
    protected org.eclipse.swt.widgets.List target;
    protected Combo emailOperation;
    protected Combo emailPattern;
    protected Button[] emailButtons;
    protected int selIndex;
    protected Button updateButton;

    public BugzillaSearchPage() {
        super(TITLE_BUGZILLA_QUERY);
    }

    public BugzillaSearchPage(TaskRepository repository) {
        super(TITLE_BUGZILLA_QUERY);
        this.repository = repository;
    }

    public BugzillaSearchPage(TaskRepository repository, BugzillaRepositoryQuery origQuery) {
        super(TITLE_BUGZILLA_QUERY, origQuery.getSummary());
        this.originalQuery = origQuery;
        this.repository = repository;
        this.setDescription("Select the Bugzilla query parameters.  Use the Update Attributes button to retrieve updated values from the repository.");
    }

    public void createControl(Composite parent) {
        this.readConfiguration();
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        control.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        if (this.scontainer == null) {
            super.createControl(control);
        }
        this.createSearchGroup(control);
        this.createOptionsGroup(control);
        this.createEmail(control);
        this.createLastDays(control);
        this.setControl((Control)control);
        WorkbenchHelpSystem.getInstance().setHelp((Control)control, "org.eclipse.mylar.bugzilla.ui.bugzillaSearchContext");
    }

    private void createSearchGroup(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 5;
        group.setLayoutData((Object)gd);
        this.createTextSearchComposite((Composite)group);
        this.createComment((Composite)group);
    }

    protected Control createTextSearchComposite(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 16384);
        label.setText("Summary/taskId contains: ");
        gd = new GridData(1);
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.summaryPattern = new Combo(group, 2052);
        this.summaryPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BugzillaSearchPage.this.scontainer != null) {
                    BugzillaSearchPage.this.scontainer.setPerformActionEnabled(BugzillaSearchPage.this.canQuery());
                }
            }
        });
        this.summaryPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.summaryPattern, BugzillaSearchPage.this.summaryOperation, previousSummaryPatterns);
            }
        });
        gd = new GridData(768);
        this.summaryPattern.setLayoutData((Object)gd);
        this.summaryOperation = new Combo(group, 2060);
        this.summaryOperation.setItems(patternOperationText);
        this.summaryOperation.setText(patternOperationText[0]);
        this.summaryOperation.select(0);
        return group;
    }

    private Control createComment(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 16384);
        label.setText("Comment contains: ");
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        this.commentPattern = new Combo(group, 2052);
        this.commentPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BugzillaSearchPage.this.scontainer != null) {
                    BugzillaSearchPage.this.scontainer.setPerformActionEnabled(BugzillaSearchPage.this.canQuery());
                }
            }
        });
        this.commentPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.commentPattern, BugzillaSearchPage.this.commentOperation, previousCommentPatterns);
            }
        });
        gd = new GridData(768);
        this.commentPattern.setLayoutData((Object)gd);
        this.commentOperation = new Combo(group, 2060);
        this.commentOperation.setItems(patternOperationText);
        this.commentOperation.setText(patternOperationText[0]);
        this.commentOperation.select(0);
        return group;
    }

    protected Control createOptionsGroup(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 5;
        group.setLayoutData((Object)gd);
        this.createProductAttributes((Composite)group);
        this.createLists((Composite)group);
        this.createUpdate((Composite)group);
        return group;
    }

    protected Control createProductAttributes(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 5;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 16384);
        label.setText("Product");
        label = new Label(group, 16384);
        label.setText("Component");
        label = new Label(group, 16384);
        label.setText("Version");
        label = new Label(group, 16384);
        label.setText("Milestone");
        this.product = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        this.product.setLayoutData((Object)gd);
        this.product.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BugzillaSearchPage.this.product.getSelectionIndex() != -1) {
                    String[] selectedProducts = BugzillaSearchPage.this.product.getSelection();
                    BugzillaSearchPage.this.updateAttributesFromRepository(BugzillaSearchPage.this.repository.getUrl(), selectedProducts, false);
                } else {
                    BugzillaSearchPage.this.updateAttributesFromRepository(BugzillaSearchPage.this.repository.getUrl(), null, false);
                }
                if (BugzillaSearchPage.this.restoring) {
                    BugzillaSearchPage.this.restoring = false;
                    BugzillaSearchPage.this.restoreWidgetValues();
                }
                if (BugzillaSearchPage.this.scontainer != null) {
                    BugzillaSearchPage.this.scontainer.setPerformActionEnabled(BugzillaSearchPage.this.canQuery());
                }
            }
        });
        this.component = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        this.component.setLayoutData((Object)gd);
        this.component.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        this.version = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        this.version.setLayoutData((Object)gd);
        this.version.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        this.target = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        this.target.setLayoutData((Object)gd);
        this.target.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        return group;
    }

    protected Control createLists(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 5;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 16384);
        label.setText("Status");
        label = new Label(group, 16384);
        label.setText("Resolution");
        label = new Label(group, 16384);
        label.setText("Severity");
        label = new Label(group, 16384);
        label.setText("Priority");
        label = new Label(group, 16384);
        label.setText("Hardware");
        label = new Label(group, 16384);
        label.setText("OS");
        this.status = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 40;
        this.status.setLayoutData((Object)gd);
        this.status.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        this.resolution = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 40;
        this.resolution.setLayoutData((Object)gd);
        this.resolution.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        this.severity = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 40;
        this.severity.setLayoutData((Object)gd);
        this.severity.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        this.priority = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 40;
        this.priority.setLayoutData((Object)gd);
        this.priority.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        this.hardware = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 40;
        this.hardware.setLayoutData((Object)gd);
        this.hardware.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        this.os = new org.eclipse.swt.widgets.List(group, 2562);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 40;
        this.os.setLayoutData((Object)gd);
        this.os.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        return group;
    }

    protected Control createLastDays(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout(6, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Label label = new Label((Composite)group, 16384);
        label.setText("Only bugs changed in the last ");
        this.daysText = new Text((Composite)group, 2048);
        this.daysText.setTextLimit(5);
        GridData daysLayoutData = new GridData();
        daysLayoutData.widthHint = 30;
        this.daysText.setLayoutData((Object)daysLayoutData);
        this.daysText.addListener(24, (Listener)this);
        label = new Label((Composite)group, 16384);
        label.setText(" days.");
        return group;
    }

    protected Control createEmail(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout(7, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Label label = new Label((Composite)group, 16384);
        label.setText("Email: ");
        this.emailPattern = new Combo((Composite)group, 2052);
        this.emailPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BugzillaSearchPage.this.scontainer != null) {
                    BugzillaSearchPage.this.scontainer.setPerformActionEnabled(BugzillaSearchPage.this.canQuery());
                }
            }
        });
        this.emailPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.emailPattern, BugzillaSearchPage.this.emailOperation, previousEmailPatterns);
            }
        });
        gd = new GridData(768);
        gd.widthHint = 110;
        this.emailPattern.setLayoutData((Object)gd);
        this.emailOperation = new Combo((Composite)group, 2060);
        this.emailOperation.setItems(emailOperationText);
        this.emailOperation.setText(emailOperationText[0]);
        this.emailOperation.select(0);
        this.emailButtons = new Button[emailText.length];
        int i = 0;
        while (i < this.emailButtons.length) {
            Button button = new Button((Composite)group, 32);
            button.setText(emailText[i]);
            this.emailButtons[i] = button;
            ++i;
        }
        return group;
    }

    protected Control createSaveQuery(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        return group;
    }

    protected Control createUpdate(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(1);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        this.updateButton = new Button(group, 8);
        this.updateButton.setText("Update Attributes from Repository");
        this.updateButton.setLayoutData((Object)new GridData());
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BugzillaSearchPage.this.repository != null) {
                    BugzillaSearchPage.this.updateAttributesFromRepository(BugzillaSearchPage.this.repository.getUrl(), null, true);
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Mylar Bugzilla Connector", (String)"No repository available, please add one using the Task Repositories view.");
                }
            }
        });
        return group;
    }

    private void handleWidgetSelected(Combo widget, Combo operation, ArrayList<BugzillaSearchData> history) {
        if (widget.getSelectionIndex() < 0) {
            return;
        }
        int index = history.size() - 1 - widget.getSelectionIndex();
        BugzillaSearchData patternData = history.get(index);
        if (patternData == null || !widget.getText().equals(patternData.pattern)) {
            return;
        }
        widget.setText(patternData.pattern);
        operation.setText(operation.getItem(patternData.operation));
    }

    public boolean performAction() {
        if (this.restoreQueryOptions) {
            this.saveWidgetValues();
        }
        this.getPatternData(this.summaryPattern, this.summaryOperation, previousSummaryPatterns);
        this.getPatternData(this.commentPattern, this.commentOperation, previousCommentPatterns);
        this.getPatternData(this.emailPattern, this.emailOperation, previousEmailPatterns);
        String summaryText = this.summaryPattern.getText();
        BugzillaUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylar.bugzilla.query.last", summaryText);
        return super.performAction();
    }

    public void setVisible(boolean visible) {
        if (visible && this.summaryPattern != null) {
            if (this.firstTime) {
                if (this.repository == null) {
                    this.repository = TasksUiPlugin.getRepositoryManager().getDefaultRepository("bugzilla");
                }
                this.firstTime = false;
                String[] stringArray = this.getPreviousPatterns(previousSummaryPatterns);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String searchPattern = stringArray[n2];
                    this.summaryPattern.add(searchPattern);
                    ++n2;
                }
                stringArray = this.getPreviousPatterns(previousCommentPatterns);
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String comment = stringArray[n2];
                    this.commentPattern.add(comment);
                    ++n2;
                }
                stringArray = this.getPreviousPatterns(previousEmailPatterns);
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String email = stringArray[n2];
                    this.emailPattern.add(email);
                    ++n2;
                }
                if (this.repository != null) {
                    this.updateAttributesFromRepository(this.repository.getUrl(), null, false);
                    if (this.product.getItemCount() == 0) {
                        this.updateAttributesFromRepository(this.repository.getUrl(), null, true);
                    }
                }
                if (this.originalQuery != null) {
                    try {
                        this.updateDefaults(this.originalQuery.getUrl());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            if (this.repository != null) {
                IDialogSettings settings = this.getDialogSettings();
                String repoId = "." + this.repository.getUrl();
                if (this.getWizard() == null && this.restoreQueryOptions && settings.getArray(STORE_PRODUCT_ID + repoId) != null && this.product != null) {
                    this.product.setSelection(this.nonNullArray(settings, STORE_PRODUCT_ID + repoId));
                    if (this.product.getSelection().length > 0) {
                        this.updateAttributesFromRepository(this.repository.getUrl(), this.product.getSelection(), false);
                    }
                    this.restoreWidgetValues();
                }
            }
            if (this.scontainer != null) {
                this.scontainer.setPerformActionEnabled(this.canQuery());
            }
            if (this.getWizard() == null) {
                this.summaryPattern.setFocus();
            }
        }
        super.setVisible(visible);
    }

    private boolean canQuery() {
        return this.product.getSelectionCount() > 0 || this.component.getSelectionCount() > 0 || this.version.getSelectionCount() > 0 || this.target.getSelectionCount() > 0 || this.status.getSelectionCount() > 0 || this.resolution.getSelectionCount() > 0 || this.severity.getSelectionCount() > 0 || this.priority.getSelectionCount() > 0 || this.hardware.getSelectionCount() > 0 || this.os.getSelectionCount() > 0 || this.summaryPattern.getText().length() > 0 || this.commentPattern.getText().length() > 0 || this.emailPattern.getText().length() > 0;
    }

    private BugzillaSearchData getPatternData(Combo widget, Combo operation, ArrayList<BugzillaSearchData> previousSearchQueryData) {
        String pattern = widget.getText();
        if (pattern == null || pattern.trim().equals("")) {
            return null;
        }
        BugzillaSearchData match = null;
        int i = previousSearchQueryData.size() - 1;
        while (i >= 0) {
            match = previousSearchQueryData.get(i);
            if (pattern.equals(match.pattern)) break;
            --i;
        }
        if (i >= 0) {
            match.operation = operation.getSelectionIndex();
            previousSearchQueryData.remove(match);
        } else {
            match = new BugzillaSearchData(widget.getText(), operation.getSelectionIndex());
        }
        previousSearchQueryData.add(match);
        return match;
    }

    private String[] getPreviousPatterns(ArrayList<BugzillaSearchData> patternHistory) {
        int size = patternHistory.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = patternHistory.get((int)(size - 1 - i)).pattern;
            ++i;
        }
        return patterns;
    }

    public String getSearchURL(TaskRepository repository) {
        try {
            return this.getQueryURL(repository, this.getQueryParameters());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    protected String getQueryURL(TaskRepository repository, StringBuffer params) {
        StringBuffer url = new StringBuffer(this.getQueryURLStart(repository).toString());
        url.append(params);
        url.append("&order=Importance");
        return url.toString();
    }

    private StringBuffer getQueryURLStart(TaskRepository repository) {
        StringBuffer sb = new StringBuffer(repository.getUrl());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append("buglist.cgi?");
        return sb;
    }

    protected StringBuffer getQueryParameters() throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        sb.append("short_desc_type=");
        sb.append(patternOperationValues[this.summaryOperation.getSelectionIndex()]);
        sb.append("&short_desc=");
        sb.append(URLEncoder.encode(this.summaryPattern.getText(), this.repository.getCharacterEncoding()));
        int[] selected = this.product.getSelectionIndices();
        int i = 0;
        while (i < selected.length) {
            sb.append("&product=");
            sb.append(URLEncoder.encode(this.product.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.component.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&component=");
            sb.append(URLEncoder.encode(this.component.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.version.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&version=");
            sb.append(URLEncoder.encode(this.version.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.target.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&target_milestone=");
            sb.append(URLEncoder.encode(this.target.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        sb.append("&long_desc_type=");
        sb.append(patternOperationValues[this.commentOperation.getSelectionIndex()]);
        sb.append("&long_desc=");
        sb.append(URLEncoder.encode(this.commentPattern.getText(), this.repository.getCharacterEncoding()));
        selected = this.status.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&bug_status=");
            sb.append(URLEncoder.encode(this.status.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.resolution.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&resolution=");
            sb.append(URLEncoder.encode(this.resolution.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.severity.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&bug_severity=");
            sb.append(URLEncoder.encode(this.severity.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.priority.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&priority=");
            sb.append(URLEncoder.encode(this.priority.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.hardware.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&ref_platform=");
            sb.append(URLEncoder.encode(this.hardware.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        selected = this.os.getSelectionIndices();
        i = 0;
        while (i < selected.length) {
            sb.append("&op_sys=");
            sb.append(URLEncoder.encode(this.os.getItem(selected[i]), this.repository.getCharacterEncoding()));
            ++i;
        }
        if (this.emailPattern.getText() != null && !this.emailPattern.getText().trim().equals("")) {
            boolean selectionMade = false;
            Button[] buttonArray = this.emailButtons;
            int n = this.emailButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                if (button.getSelection()) {
                    selectionMade = true;
                    break;
                }
                ++n2;
            }
            if (selectionMade) {
                int i2 = 0;
                while (i2 < this.emailButtons.length) {
                    if (this.emailButtons[i2].getSelection()) {
                        sb.append("&");
                        sb.append(emailRoleValues[i2]);
                        sb.append("=1");
                    }
                    ++i2;
                }
                sb.append("&emailtype1=");
                sb.append(emailOperationValues[this.emailOperation.getSelectionIndex()]);
                sb.append("&email1=");
                sb.append(URLEncoder.encode(this.emailPattern.getText(), this.repository.getCharacterEncoding()));
            }
        }
        if (this.daysText.getText() != null && !this.daysText.getText().equals("")) {
            try {
                Integer.parseInt(this.daysText.getText());
                sb.append("&changedin=");
                sb.append(URLEncoder.encode(this.daysText.getText(), this.repository.getCharacterEncoding()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return sb;
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        this.getDialogSettings();
    }

    private void updateAttributesFromRepository(String repositoryUrl, String[] selectedProducts, boolean connect) {
        if (connect) {
            final AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getKind());
            IRunnableWithProgress updateRunnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            monitor.beginTask("Updating search options...", -1);
                            connector.updateAttributes(BugzillaSearchPage.this.repository, monitor);
                            BugzillaUiPlugin.updateQueryOptions(BugzillaSearchPage.this.repository, monitor);
                        }
                        catch (CoreException ce) {
                            MylarStatusHandler.displayStatus((String)"Update failed", (IStatus)ce.getStatus());
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                if (this.getContainer() != null) {
                    this.getContainer().run(true, false, updateRunnable);
                } else {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.run(true, false, updateRunnable);
                }
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError(null, (String)"Error updating search options", (String)("Error was : " + e.getCause().getMessage()));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (selectedProducts == null) {
            String[] productsList = BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.product", null, repositoryUrl);
            Arrays.sort(productsList, String.CASE_INSENSITIVE_ORDER);
            this.product.setItems(productsList);
        }
        String[] componentsList = BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.component", selectedProducts, repositoryUrl);
        Arrays.sort(componentsList, String.CASE_INSENSITIVE_ORDER);
        this.component.setItems(componentsList);
        this.version.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.version", selectedProducts, repositoryUrl));
        this.target.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.target", selectedProducts, repositoryUrl));
        if (selectedProducts == null) {
            this.status.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.status", selectedProducts, repositoryUrl));
            this.resolution.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.resolution", selectedProducts, repositoryUrl));
            this.severity.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.severity", selectedProducts, repositoryUrl));
            this.priority.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.priority", selectedProducts, repositoryUrl));
            this.hardware.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.hardware", selectedProducts, repositoryUrl));
            this.os.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylar.bugzilla.values.os", selectedProducts, repositoryUrl));
        }
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public void setRepository(TaskRepository repository) {
        this.repository = repository;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void handleEvent(Event event) {
        String days;
        String message = null;
        if (event.widget == this.daysText && (days = this.daysText.getText()).length() > 0) {
            try {
                if (Integer.parseInt(days) < 0) {
                    message = NUM_DAYS_POSITIVE + days + " is invalid.";
                }
            }
            catch (NumberFormatException numberFormatException) {
                message = NUM_DAYS_POSITIVE + days + " is invalid.";
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
        if (this.getWizard() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void updateDefaults(String startingUrl) throws UnsupportedEncodingException {
        String[] options;
        startingUrl = startingUrl.substring(startingUrl.indexOf("?") + 1);
        String[] stringArray = options = startingUrl.split("&");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            String key = option.substring(0, option.indexOf("="));
            String value = URLDecoder.decode(option.substring(option.indexOf("=") + 1), this.repository.getCharacterEncoding());
            if (key != null) {
                List<String> selList;
                String item;
                int n3;
                int n4;
                String[] stringArray2;
                if (key.equals("short_desc")) {
                    this.summaryPattern.setText(value);
                } else if (key.equals("short_desc_type")) {
                    if (value.equals("allwordssubstr")) {
                        value = "all words";
                    } else if (value.equals("anywordssubstr")) {
                        value = "any word";
                    }
                    int index = 0;
                    stringArray2 = this.summaryOperation.getItems();
                    n4 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.compareTo(value) == 0) break;
                        ++index;
                        ++n3;
                    }
                    if (index < this.summaryOperation.getItemCount()) {
                        this.summaryOperation.select(index);
                    }
                } else if (key.equals("product")) {
                    String[] sel = this.product.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.product.setSelection(selList.toArray(sel));
                    this.updateAttributesFromRepository(this.repository.getUrl(), selList.toArray(sel), false);
                } else if (key.equals("component")) {
                    String[] sel = this.component.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.component.setSelection(selList.toArray(sel));
                } else if (key.equals("version")) {
                    String[] sel = this.version.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.version.setSelection(selList.toArray(sel));
                } else if (key.equals("target_milestone")) {
                    String[] sel = this.target.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.target.setSelection(selList.toArray(sel));
                } else if (key.equals("version")) {
                    String[] sel = this.version.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.version.setSelection(selList.toArray(sel));
                } else if (key.equals("long_desc_type")) {
                    if (value.equals("allwordssubstr")) {
                        value = "all words";
                    } else if (value.equals("anywordssubstr")) {
                        value = "any word";
                    }
                    int index = 0;
                    stringArray2 = this.commentOperation.getItems();
                    n4 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.compareTo(value) == 0) break;
                        ++index;
                        ++n3;
                    }
                    if (index < this.commentOperation.getItemCount()) {
                        this.commentOperation.select(index);
                    }
                } else if (key.equals("long_desc")) {
                    this.commentPattern.setText(value);
                } else if (key.equals("bug_status")) {
                    String[] sel = this.status.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.status.setSelection(selList.toArray(sel));
                } else if (key.equals("resolution")) {
                    String[] sel = this.resolution.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.resolution.setSelection(selList.toArray(sel));
                } else if (key.equals("bug_severity")) {
                    String[] sel = this.severity.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.severity.setSelection(selList.toArray(sel));
                } else if (key.equals("priority")) {
                    String[] sel = this.priority.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.priority.setSelection(selList.toArray(sel));
                } else if (key.equals("ref_platform")) {
                    String[] sel = this.hardware.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.hardware.setSelection(selList.toArray(sel));
                } else if (key.equals("op_sys")) {
                    String[] sel = this.os.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.os.setSelection(selList.toArray(sel));
                } else if (key.equals("emailassigned_to1")) {
                    if (value.equals("1")) {
                        this.emailButtons[0].setSelection(true);
                    } else {
                        this.emailButtons[0].setSelection(false);
                    }
                } else if (key.equals("emailreporter1")) {
                    if (value.equals("1")) {
                        this.emailButtons[1].setSelection(true);
                    } else {
                        this.emailButtons[1].setSelection(false);
                    }
                } else if (key.equals("emailcc1")) {
                    if (value.equals("1")) {
                        this.emailButtons[2].setSelection(true);
                    } else {
                        this.emailButtons[2].setSelection(false);
                    }
                } else if (key.equals("emaillongdesc1")) {
                    if (value.equals("1")) {
                        this.emailButtons[3].setSelection(true);
                    } else {
                        this.emailButtons[3].setSelection(false);
                    }
                } else if (key.equals("emailtype1")) {
                    int index = 0;
                    stringArray2 = this.emailOperation.getItems();
                    n4 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.compareTo(value) == 0) break;
                        ++index;
                        ++n3;
                    }
                    if (index < this.emailOperation.getItemCount()) {
                        this.emailOperation.select(index);
                    }
                } else if (key.equals("email1")) {
                    this.emailPattern.setText(value);
                } else if (key.equals("changedin")) {
                    this.daysText.setText(value);
                }
            }
            ++n2;
        }
    }

    public BugzillaRepositoryQuery getQuery() {
        if (this.originalQuery == null) {
            try {
                this.originalQuery = new BugzillaRepositoryQuery(this.repository.getUrl(), this.getQueryURL(this.repository, this.getQueryParameters()), this.getQueryTitle(), TasksUiPlugin.getTaskListManager().getTaskList());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        try {
            this.originalQuery.setUrl(this.getQueryURL(this.repository, this.getQueryParameters()));
            this.originalQuery.setDescription(this.getQueryTitle());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return this.originalQuery;
    }

    private String[] nonNullArray(IDialogSettings settings, String id) {
        String[] value = settings.getArray(id);
        if (value == null) {
            return new String[0];
        }
        return value;
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        String repoId = "." + this.repository.getUrl();
        if (!this.restoreQueryOptions || settings.getArray(STORE_PRODUCT_ID + repoId) == null || this.product == null) {
            return;
        }
        this.product.setSelection(this.nonNullArray(settings, STORE_PRODUCT_ID + repoId));
        this.component.setSelection(this.nonNullArray(settings, STORE_COMPONENT_ID + repoId));
        this.version.setSelection(this.nonNullArray(settings, STORE_VERSION_ID + repoId));
        this.target.setSelection(this.nonNullArray(settings, STORE_MSTONE_ID + repoId));
        this.status.setSelection(this.nonNullArray(settings, STORE_STATUS_ID + repoId));
        this.resolution.setSelection(this.nonNullArray(settings, STORE_RESOLUTION_ID + repoId));
        this.severity.setSelection(this.nonNullArray(settings, STORE_SEVERITY_ID + repoId));
        this.priority.setSelection(this.nonNullArray(settings, STORE_PRIORITY_ID + repoId));
        this.hardware.setSelection(this.nonNullArray(settings, STORE_HARDWARE_ID + repoId));
        this.os.setSelection(this.nonNullArray(settings, STORE_OS_ID + repoId));
        this.summaryOperation.select(settings.getInt(STORE_SUMMARYMATCH_ID + repoId));
        this.commentOperation.select(settings.getInt(STORE_COMMENTMATCH_ID + repoId));
        this.emailOperation.select(settings.getInt(STORE_EMAILMATCH_ID + repoId));
        int i = 0;
        while (i < this.emailButtons.length) {
            this.emailButtons[i].setSelection(settings.getBoolean(STORE_EMAILBUTTON_ID + i + repoId));
            ++i;
        }
        this.summaryPattern.setText(settings.get(STORE_SUMMARYTEXT_ID + repoId));
        this.commentPattern.setText(settings.get(STORE_COMMENTTEXT_ID + repoId));
        this.emailPattern.setText(settings.get(STORE_EMAILADDRESS_ID + repoId));
    }

    public void saveWidgetValues() {
        String repoId = "." + this.repository.getUrl();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_PRODUCT_ID + repoId, this.product.getSelection());
        settings.put(STORE_COMPONENT_ID + repoId, this.component.getSelection());
        settings.put(STORE_VERSION_ID + repoId, this.version.getSelection());
        settings.put(STORE_MSTONE_ID + repoId, this.target.getSelection());
        settings.put(STORE_STATUS_ID + repoId, this.status.getSelection());
        settings.put(STORE_RESOLUTION_ID + repoId, this.resolution.getSelection());
        settings.put(STORE_SEVERITY_ID + repoId, this.severity.getSelection());
        settings.put(STORE_PRIORITY_ID + repoId, this.priority.getSelection());
        settings.put(STORE_HARDWARE_ID + repoId, this.hardware.getSelection());
        settings.put(STORE_OS_ID + repoId, this.os.getSelection());
        settings.put(STORE_SUMMARYMATCH_ID + repoId, this.summaryOperation.getSelectionIndex());
        settings.put(STORE_COMMENTMATCH_ID + repoId, this.commentOperation.getSelectionIndex());
        settings.put(STORE_EMAILMATCH_ID + repoId, this.emailOperation.getSelectionIndex());
        int i = 0;
        while (i < this.emailButtons.length) {
            settings.put(STORE_EMAILBUTTON_ID + i + repoId, this.emailButtons[i].getSelection());
            ++i;
        }
        settings.put(STORE_SUMMARYTEXT_ID + repoId, this.summaryPattern.getText());
        settings.put(STORE_COMMENTTEXT_ID + repoId, this.commentPattern.getText());
        settings.put(STORE_EMAILADDRESS_ID + repoId, this.emailPattern.getText());
    }

    public int getProductCount() throws Exception {
        return this.product.getItemCount();
    }

    public boolean isRestoreQueryOptions() {
        return this.restoreQueryOptions;
    }

    public void setRestoreQueryOptions(boolean restoreQueryOptions) {
        this.restoreQueryOptions = restoreQueryOptions;
    }

    private static class BugzillaSearchData {
        String pattern;
        int operation;

        BugzillaSearchData(String pattern, int operation) {
            this.pattern = pattern;
            this.operation = operation;
        }
    }
}

