/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.tasklist;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaClientFactory;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylar.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylar.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylar.tasks.core.RepositoryTemplate;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylar.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class BugzillaRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String LABEL_SHORT_LOGINS = "Local users enabled:";
    public static final String LABEL_AUTOMATIC_VERSION = "Automatic (Use Validate Settings)";
    private static final String TITLE = "Bugzilla Repository Settings";
    private static final String DESCRIPTION = "Example: https://bugs.eclipse.org/bugs (do not include index.cgi)";
    protected Combo repositoryVersionCombo;
    private Button cleanQAContact;

    public BugzillaRepositorySettingsPage(AbstractRepositoryConnectorUi repositoryUi) {
        super(TITLE, DESCRIPTION, repositoryUi);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsEncoding(true);
        this.setNeedsTimeZone(false);
        this.setNeedsHttpAuth(true);
    }

    protected void createAdditionalControls(Composite parent) {
        for (RepositoryTemplate template : this.connector.getTemplates()) {
            this.serverUrlCombo.add(template.label);
        }
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = BugzillaRepositorySettingsPage.this.serverUrlCombo.getText();
                RepositoryTemplate template = BugzillaRepositorySettingsPage.this.connector.getTemplate(text);
                if (template != null) {
                    BugzillaRepositorySettingsPage.this.repositoryLabelEditor.setStringValue(template.label);
                    BugzillaRepositorySettingsPage.this.setUrl(template.repositoryUrl);
                    BugzillaRepositorySettingsPage.this.setBugzillaVersion(template.version);
                    if (template.characterEncoding != null) {
                        BugzillaRepositorySettingsPage.this.setEncoding(template.characterEncoding);
                    }
                    BugzillaRepositorySettingsPage.this.getContainer().updateButtons();
                    return;
                }
            }
        });
        Label repositoryVersionLabel = new Label(parent, 0);
        repositoryVersionLabel.setText("Repository Version: ");
        this.repositoryVersionCombo = new Combo(parent, 8);
        this.repositoryVersionCombo.add(LABEL_AUTOMATIC_VERSION);
        IBugzillaConstants.BugzillaServerVersion[] bugzillaServerVersionArray = IBugzillaConstants.BugzillaServerVersion.values();
        int n = bugzillaServerVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBugzillaConstants.BugzillaServerVersion version = bugzillaServerVersionArray[n2];
            this.repositoryVersionCombo.add(version.toString());
            ++n2;
        }
        if (this.repository != null && this.repositoryVersionCombo.indexOf(this.repository.getVersion()) >= 0) {
            this.repositoryVersionCombo.select(this.repositoryVersionCombo.indexOf(this.repository.getVersion()));
        } else {
            int defaultIndex = this.repositoryVersionCombo.getItemCount() - 1;
            this.repositoryVersionCombo.select(defaultIndex);
            this.setVersion(this.repositoryVersionCombo.getItem(defaultIndex));
        }
        this.repositoryVersionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BugzillaRepositorySettingsPage.this.repositoryVersionCombo.getSelectionIndex() >= 0) {
                    BugzillaRepositorySettingsPage.this.setVersion(BugzillaRepositorySettingsPage.this.repositoryVersionCombo.getItem(BugzillaRepositorySettingsPage.this.repositoryVersionCombo.getSelectionIndex()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label shortLoginLabel = new Label(parent, 0);
        shortLoginLabel.setText(LABEL_SHORT_LOGINS);
        this.cleanQAContact = new Button(parent, 16416);
        if (this.repository != null) {
            boolean shortLogin = Boolean.parseBoolean(this.repository.getProperty("bugzilla.shortLoginEnabled"));
            this.cleanQAContact.setSelection(shortLogin);
        }
    }

    public void setBugzillaVersion(String version) {
        if (version == null) {
            this.repositoryVersionCombo.select(0);
        } else {
            int i = this.repositoryVersionCombo.indexOf(version.toString());
            if (i != -1) {
                this.repositoryVersionCombo.select(i);
                this.setVersion(version);
            } else {
                IBugzillaConstants.BugzillaServerVersion[] bugzillaServerVersionArray = IBugzillaConstants.BugzillaServerVersion.values();
                int n = bugzillaServerVersionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBugzillaConstants.BugzillaServerVersion serverVersion = bugzillaServerVersionArray[n2];
                    if (version.startsWith(serverVersion.toString()) && (i = this.repositoryVersionCombo.indexOf(serverVersion.toString())) != -1) {
                        this.repositoryVersionCombo.select(i);
                        this.setVersion(serverVersion.toString());
                        break;
                    }
                    ++n2;
                }
                if (i == -1) {
                    MylarStatusHandler.log((String)("Could not resolve repository version: " + version), (Object)((Object)this));
                    this.setVersion(IBugzillaConstants.BugzillaServerVersion.SERVER_218.toString());
                }
            }
        }
    }

    public void updateProperties(TaskRepository repository) {
        repository.setProperty("bugzilla.shortLoginEnabled", String.valueOf(this.cleanQAContact.getSelection()));
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    protected boolean isValidUrl(String name) {
        if (name.startsWith("https://") || name.startsWith("http://")) {
            try {
                new URL(name);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        if (this.repositoryVersionCombo.getSelectionIndex() != 0) {
            return new BugzillaValidator(repository, this.repositoryVersionCombo.getItem(this.repositoryVersionCombo.getSelectionIndex()));
        }
        return new BugzillaValidator(repository, null);
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        super.applyValidatorResult(validator);
        if (((BugzillaValidator)validator).getResult() != null && ((BugzillaValidator)validator).getResult() != null) {
            this.setBugzillaVersion(((BugzillaValidator)validator).getResult());
        }
    }

    public class BugzillaValidator
    extends AbstractRepositorySettingsPage.Validator {
        final String serverUrl;
        final String newUserId;
        final String newPassword;
        final boolean isAnonymous;
        final String newEncoding;
        final String httpAuthUser;
        final String httpAuthPass;
        final Proxy proxy;
        private String[] versions;

        public BugzillaValidator(TaskRepository repository, String version) {
            super((AbstractRepositorySettingsPage)BugzillaRepositorySettingsPage.this);
            this.versions = new String[1];
            this.serverUrl = BugzillaRepositorySettingsPage.this.getServerUrl();
            this.newUserId = BugzillaRepositorySettingsPage.this.getUserName();
            this.newPassword = BugzillaRepositorySettingsPage.this.getPassword();
            this.isAnonymous = BugzillaRepositorySettingsPage.this.isAnonymousAccess();
            this.newEncoding = BugzillaRepositorySettingsPage.this.getCharacterEncoding();
            this.httpAuthUser = BugzillaRepositorySettingsPage.this.getHttpAuthUserId();
            this.httpAuthPass = BugzillaRepositorySettingsPage.this.getHttpAuthPassword();
            this.proxy = repository.getProxy();
            this.versions[0] = version;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                this.validate(monitor);
            }
            catch (Exception e) {
                this.displayError(this.serverUrl, e);
            }
        }

        private void displayError(String serverUrl, Throwable e) {
            Object status = e instanceof MalformedURLException ? new BugzillaStatus(2, "org.eclipse.mylar.bugzilla", 11, "Server URL is invalid.") : (e instanceof CoreException ? ((CoreException)e).getStatus() : (e instanceof IOException ? new BugzillaStatus(2, "org.eclipse.mylar.bugzilla", 5, serverUrl, e.getMessage()) : new BugzillaStatus(2, "org.eclipse.mylar.bugzilla", 11, serverUrl, e.getMessage())));
            MylarStatusHandler.displayStatus((String)"Validation failed", (IStatus)status);
            this.setStatus((IStatus)status);
        }

        public void validate(IProgressMonitor monitor) throws IOException, CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                RepositoryConfiguration config;
                boolean checkVersion;
                monitor.beginTask("Validating server settings", -1);
                BugzillaClient client = null;
                boolean bl = checkVersion = this.versions[0] == null;
                if (this.isAnonymous) {
                    client = BugzillaClientFactory.createClient((String)this.serverUrl, (String)this.newUserId, (String)this.newPassword, (String)this.httpAuthUser, (String)this.httpAuthPass, (Proxy)this.proxy, (String)this.newEncoding);
                    client.logout();
                } else if (this.versions != null) {
                    client = BugzillaClientFactory.createClient((String)this.serverUrl, (String)this.newUserId, (String)this.newPassword, (String)this.httpAuthUser, (String)this.httpAuthPass, (Proxy)this.proxy, (String)this.newEncoding);
                    client.validate();
                }
                if (checkVersion && client != null && (config = client.getRepositoryConfiguration()) != null) {
                    this.versions[0] = config.getInstallVersion();
                }
            }
            finally {
                monitor.done();
            }
        }

        public String getResult() {
            return this.versions[0];
        }
    }
}

