/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.tasklist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylar.internal.bugzilla.ui.BugzillaImages;
import org.eclipse.mylar.internal.bugzilla.ui.search.BugzillaSearchPage;
import org.eclipse.mylar.internal.bugzilla.ui.tasklist.BugzillaRepositorySettingsPage;
import org.eclipse.mylar.internal.bugzilla.ui.tasklist.EditBugzillaQueryWizard;
import org.eclipse.mylar.internal.bugzilla.ui.tasklist.NewBugzillaQueryWizard;
import org.eclipse.mylar.internal.bugzilla.ui.wizard.NewBugzillaTaskWizard;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.RepositoryTaskData;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylar.tasks.ui.TaskHyperlink;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.search.AbstractRepositoryQueryPage;
import org.eclipse.mylar.tasks.ui.wizards.AbstractRepositorySettingsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaRepositoryUi
extends AbstractRepositoryConnectorUi {
    private static final int TASK_NUM_GROUP = 3;
    private static final String regexp = "(duplicate of|bug|task)(\\s#|#|#\\s|\\s|)(\\s\\d+|\\d+)";
    private static final Pattern PATTERN = Pattern.compile("(duplicate of|bug|task)(\\s#|#|#\\s|\\s|)(\\s\\d+|\\d+)", 2);

    public List<ITaskListElement> getLegendItems() {
        ArrayList<ITaskListElement> legendItems = new ArrayList<ITaskListElement>();
        BugzillaTask blocker = new BugzillaTask("", "critical", "Critical or Blocker", false);
        blocker.setSeverity("critical");
        legendItems.add((ITaskListElement)blocker);
        BugzillaTask major = new BugzillaTask("", "major", "Major", false);
        major.setSeverity("major");
        legendItems.add((ITaskListElement)major);
        BugzillaTask enhancement = new BugzillaTask("", "enhancement", "Enhancement", false);
        enhancement.setSeverity("enhancement");
        legendItems.add((ITaskListElement)enhancement);
        BugzillaTask trivial = new BugzillaTask("", "trivial", "Trivial or Minor", false);
        trivial.setSeverity("trivial");
        legendItems.add((ITaskListElement)trivial);
        return legendItems;
    }

    public ImageDescriptor getTaskKindOverlay(AbstractRepositoryTask task) {
        BugzillaTask bugzillaTask;
        String severity;
        if (task instanceof BugzillaTask && (severity = (bugzillaTask = (BugzillaTask)task).getSeverity()) != null) {
            if ("blocker".equals(severity) || "critical".equals(severity)) {
                return BugzillaImages.OVERLAY_CRITICAL;
            }
            if ("major".equals(severity)) {
                return BugzillaImages.OVERLAY_MAJOR;
            }
            if ("enhancement".equals(severity)) {
                return BugzillaImages.OVERLAY_ENHANCEMENT;
            }
            if ("trivial".equals(severity) || "minor".equals(severity)) {
                return BugzillaImages.OVERLAY_MINOR;
            }
            return null;
        }
        return super.getTaskKindOverlay(task);
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        ArrayList<IHyperlink> hyperlinksFound = new ArrayList<IHyperlink>();
        Matcher m = PATTERN.matcher(text);
        while (m.find()) {
            IHyperlink link;
            if (lineOffset < m.start() || lineOffset > m.end() || (link = BugzillaRepositoryUi.extractHyperlink(repository, regionOffset, m)) == null) continue;
            hyperlinksFound.add(link);
        }
        if (hyperlinksFound.size() > 0) {
            return hyperlinksFound.toArray(new IHyperlink[1]);
        }
        return null;
    }

    private static IHyperlink extractHyperlink(TaskRepository repository, int regionOffset, Matcher m) {
        int start = -1;
        start = m.group().startsWith("duplicate") ? m.start() + m.group().indexOf(m.group(3)) : m.start();
        int end = m.end();
        if (end == -1) {
            end = m.group().length();
        }
        try {
            String bugId = m.group(3).trim();
            Region sregion = new Region(start += regionOffset, (end += regionOffset) - start);
            return new TaskHyperlink((IRegion)sregion, repository, bugId);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getTaskKindLabel(AbstractRepositoryTask repositoryTask) {
        return "Bug";
    }

    public String getTaskKindLabel(RepositoryTaskData taskData) {
        return "Bug";
    }

    public AbstractRepositorySettingsPage getSettingsPage() {
        return new BugzillaRepositorySettingsPage(this);
    }

    public AbstractRepositoryQueryPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new BugzillaSearchPage(repository);
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository) {
        return new NewBugzillaTaskWizard(taskRepository);
    }

    public IWizard getQueryWizard(TaskRepository repository, AbstractRepositoryQuery query) {
        if (query instanceof BugzillaRepositoryQuery) {
            return new EditBugzillaQueryWizard(repository, (BugzillaRepositoryQuery)query);
        }
        return new NewBugzillaQueryWizard(repository);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public boolean hasRichEditor() {
        return true;
    }

    public String getRepositoryType() {
        return "bugzilla";
    }

    public boolean handlesDueDates(AbstractRepositoryTask task) {
        RepositoryTaskData taskData;
        if (task instanceof BugzillaTask && (taskData = TasksUiPlugin.getDefault().getTaskDataManager().getNewTaskData(task.getHandleIdentifier())) != null && taskData.getAttribute(BugzillaReportElement.ESTIMATED_TIME.getKeyString()) != null) {
            return true;
        }
        return super.handlesDueDates(task);
    }
}

