/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.tasklist;

import org.eclipse.mylar.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylar.internal.bugzilla.ui.editor.BugzillaTaskEditor;
import org.eclipse.mylar.internal.bugzilla.ui.editor.NewBugzillaTaskEditor;
import org.eclipse.mylar.internal.bugzilla.ui.tasklist.BugzillaTaskEditorInput;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.editors.ITaskEditorFactory;
import org.eclipse.mylar.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylar.tasks.ui.editors.TaskEditor;
import org.eclipse.mylar.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.EditorPart;

public class BugzillaTaskEditorFactory
implements ITaskEditorFactory {
    private static final String TITLE = "Bugzilla";

    public EditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        Object editor = null;
        if (editorInput instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput taskInput = (RepositoryTaskEditorInput)editorInput;
            editor = taskInput.getTaskData().isNew() ? new NewBugzillaTaskEditor((FormEditor)parentEditor) : new BugzillaTaskEditor((FormEditor)parentEditor);
        } else if (editorInput instanceof TaskEditorInput) {
            editor = new BugzillaTaskEditor((FormEditor)parentEditor);
        }
        return editor;
    }

    public IEditorInput createEditorInput(ITask task) {
        if (task instanceof BugzillaTask) {
            BugzillaTask bugzillaTask = (BugzillaTask)task;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("bugzilla", bugzillaTask.getRepositoryUrl());
            BugzillaTaskEditorInput input = new BugzillaTaskEditorInput(repository, bugzillaTask, true);
            return input;
        }
        return null;
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean canCreateEditorFor(ITask task) {
        return task instanceof BugzillaTask;
    }

    public boolean providesOutline() {
        return true;
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        if (input instanceof RepositoryTaskEditorInput) {
            return "bugzilla".equals(((RepositoryTaskEditorInput)input).getRepository().getKind());
        }
        return false;
    }
}

