/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.tasklist;

import org.eclipse.mylar.internal.bugzilla.core.BugzillaQueryHit;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylar.tasks.core.AbstractQueryHit;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.DelegatingTaskExternalizer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.TaskExternalizationException;
import org.eclipse.mylar.tasks.core.TaskList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BugzillaTaskExternalizer
extends DelegatingTaskExternalizer {
    private static final String KEY_SEVERITY = "bugzilla.severity";
    private static final String KEY_PRODUCT = "bugzilla.product";
    private static final String STATUS_RESO = "RESO";
    private static final String STATUS_NEW = "NEW";
    private static final String TAG_BUGZILLA = "Bugzilla";
    private static final String TAG_BUGZILLA_QUERY_HIT = "BugzillaQueryHit";
    private static final String TAG_BUGZILLA_QUERY = "BugzillaQuery";
    private static final String TAG_BUGZILLA_CUSTOM_QUERY = "BugzillaCustomQuery";
    private static final String TAG_BUGZILLA_REPORT = "BugzillaReport";

    public String getQueryTagNameForElement(AbstractRepositoryQuery query) {
        if (query instanceof BugzillaRepositoryQuery) {
            if (((BugzillaRepositoryQuery)query).isCustomQuery()) {
                return TAG_BUGZILLA_CUSTOM_QUERY;
            }
            return TAG_BUGZILLA_QUERY;
        }
        return "";
    }

    public boolean canReadQuery(Node node) {
        return node.getNodeName().equals(TAG_BUGZILLA_CUSTOM_QUERY) || node.getNodeName().equals(TAG_BUGZILLA_QUERY);
    }

    public AbstractRepositoryQuery readQuery(Node node, TaskList taskList) throws TaskExternalizationException {
        Element element = (Element)node;
        BugzillaRepositoryQuery query = new BugzillaRepositoryQuery(element.getAttribute("RepositoryUrl"), element.getAttribute("QueryString"), element.getAttribute("Name"), taskList);
        if (node.getNodeName().equals(TAG_BUGZILLA_CUSTOM_QUERY)) {
            query.setCustomQuery(true);
        }
        if (element.getAttribute("LastRefreshTimeStamp") != null && !element.getAttribute("LastRefreshTimeStamp").equals("")) {
            query.setLastRefreshTimeStamp(element.getAttribute("LastRefreshTimeStamp"));
        }
        return query;
    }

    public Element createTaskElement(ITask task, Document doc, Element parent) {
        Element node = super.createTaskElement(task, doc, parent);
        node.setAttribute(KEY_SEVERITY, ((BugzillaTask)task).getSeverity());
        node.setAttribute(KEY_PRODUCT, ((BugzillaTask)task).getProduct());
        return node;
    }

    public boolean canCreateElementFor(AbstractRepositoryQuery category) {
        return category instanceof BugzillaRepositoryQuery;
    }

    public boolean canCreateElementFor(ITask task) {
        return task instanceof BugzillaTask;
    }

    public boolean canReadTask(Node node) {
        return node.getNodeName().equals(this.getTaskTagName());
    }

    public ITask createTask(String repositoryUrl, String taskId, String summary, Element element, TaskList taskList, AbstractTaskContainer category, ITask parent) throws TaskExternalizationException {
        BugzillaTask task = new BugzillaTask(repositoryUrl, taskId, summary, false);
        if (element.hasAttribute(KEY_SEVERITY)) {
            task.setSeverity(element.getAttribute(KEY_SEVERITY));
        }
        if (element.hasAttribute(KEY_PRODUCT)) {
            task.setProduct(element.getAttribute(KEY_PRODUCT));
        }
        return task;
    }

    public boolean canReadQueryHit(Node node) {
        return node.getNodeName().equals(this.getQueryHitTagName());
    }

    public AbstractQueryHit createQueryHit(String repositoryUrl, String taskId, String summary, Element element, TaskList taskList, AbstractRepositoryQuery query) throws TaskExternalizationException {
        String status = STATUS_NEW;
        if (element.hasAttribute("Complete") && (status = element.getAttribute("Complete")).equals("true")) {
            status = STATUS_RESO;
        }
        BugzillaQueryHit hit = new BugzillaQueryHit(taskList, summary, "", repositoryUrl, taskId, null, status);
        return hit;
    }

    public String getTaskTagName() {
        return TAG_BUGZILLA_REPORT;
    }

    public String getQueryHitTagName() {
        return TAG_BUGZILLA_QUERY_HIT;
    }
}

