/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.tasklist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylar.internal.bugzilla.ui.tasklist.BugzillaQueryTypeWizardPage;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.search.AbstractRepositoryQueryPage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewBugzillaQueryWizard
extends Wizard {
    private static final String TITLE = "New Bugzilla Query";
    private final TaskRepository repository;
    BugzillaQueryTypeWizardPage page1;

    public NewBugzillaQueryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.page1 = new BugzillaQueryTypeWizardPage(this.repository);
        this.page1.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        if (this.page1.getNextPage() == null || !(this.page1.getNextPage() instanceof AbstractRepositoryQueryPage)) {
            return false;
        }
        AbstractRepositoryQueryPage page = (AbstractRepositoryQueryPage)this.page1.getNextPage();
        final BugzillaRepositoryQuery queryCategory = (BugzillaRepositoryQuery)page.getQuery();
        TasksUiPlugin.getTaskListManager().getTaskList().addQuery((AbstractRepositoryQuery)queryCategory);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Executing query", 50);
                try {
                    AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector("bugzilla");
                    TasksUiPlugin.getSynchronizationManager().synchronize(connector, (AbstractRepositoryQuery)queryCategory, null, true);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            MylarStatusHandler.log((Throwable)e, (String)"There was a problem executing the query refresh");
        }
        return true;
    }

    public boolean canFinish() {
        return this.page1.getNextPage() != null && this.page1.getNextPage().isPageComplete();
    }
}

