/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.bugzilla.ui.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylar.internal.bugzilla.core.BugzillaAttributeFactory;
import org.eclipse.mylar.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylar.internal.bugzilla.ui.wizard.BugzillaProductPage;
import org.eclipse.mylar.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylar.tasks.core.RepositoryTaskData;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.TasksUiUtil;
import org.eclipse.mylar.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class NewBugzillaTaskWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "New Bugzilla Task";
    private IWorkbench workbenchInstance;
    private final TaskRepository repository;
    private final BugzillaProductPage productPage;
    protected boolean completed = false;
    protected RepositoryTaskData taskData;

    public NewBugzillaTaskWizard(TaskRepository repository) {
        this(false, repository);
        this.taskData = new RepositoryTaskData((AbstractAttributeFactory)new BugzillaAttributeFactory(), "bugzilla", repository.getUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId(), "task");
        this.taskData.setNew(true);
        super.setDefaultPageImageDescriptor(BugzillaUiPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylar.internal.bugzilla.ui", (String)"icons/wizban/bug-wizard.gif"));
        super.setWindowTitle(TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public NewBugzillaTaskWizard(boolean fromDialog, TaskRepository repository) {
        this.repository = repository;
        this.productPage = new BugzillaProductPage(this.workbenchInstance, this, repository);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbenchInstance = workbench;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.productPage);
    }

    public boolean canFinish() {
        return this.completed;
    }

    public boolean performFinish() {
        try {
            this.productPage.saveDataToModel();
            NewTaskEditorInput editorInput = new NewTaskEditorInput(this.repository, this.taskData);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            TasksUiUtil.openEditor((IEditorInput)editorInput, (String)"org.eclipse.mylar.tasklist.ui.taskEditor", (IWorkbenchPage)page);
            return true;
        }
        catch (Exception exception) {
            this.productPage.applyToStatusLine((IStatus)new Status(4, "not_used", 0, "Problem occurred retrieving repository configuration from " + this.repository.getUrl(), null));
            return false;
        }
    }
}

