/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.context.core;

import java.util.List;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IDegreeOfSeparation;
import org.eclipse.mylar.context.core.IMylarContext;
import org.eclipse.mylar.context.core.IMylarContextListener;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.internal.context.core.CompositeContextElement;
import org.eclipse.mylar.internal.context.core.IMylarSearchOperation;
import org.eclipse.mylar.internal.context.core.MylarContextElement;
import org.eclipse.mylar.internal.context.core.MylarContextRelation;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRelationProvider
implements IMylarContextListener {
    protected final String DOS_0_LABEL = "disabled";
    protected final String DOS_1_LABEL = "landmark resources";
    protected final String DOS_2_LABEL = "interesting resources";
    protected final String DOS_3_LABEL = "interesting projects";
    protected final String DOS_4_LABEL = "project dependencies";
    protected final String DOS_5_LABEL = "entire workspace (slow)";
    private boolean enabled = false;
    private String id;
    private String structureKind;
    private int degreeOfSeparation;

    public String getId() {
        return this.id;
    }

    public AbstractRelationProvider(String structureKind, String id) {
        this.id = id;
        this.structureKind = structureKind;
        this.degreeOfSeparation = this.getDefaultDegreeOfSeparation();
    }

    public abstract List<IDegreeOfSeparation> getDegreesOfSeparation();

    protected abstract int getDefaultDegreeOfSeparation();

    protected abstract void findRelated(IMylarElement var1, int var2);

    public abstract IMylarSearchOperation getSearchOperation(IMylarElement var1, int var2, int var3);

    public abstract String getName();

    public boolean acceptResultElement(Object element) {
        return true;
    }

    @Override
    public void contextActivated(IMylarContext taskscape) {
    }

    @Override
    public void contextCleared(IMylarContext context) {
    }

    @Override
    public void landmarkAdded(IMylarElement node) {
        if (this.enabled) {
            this.findRelated(node, this.degreeOfSeparation);
        }
    }

    @Override
    public void landmarkRemoved(IMylarElement node) {
    }

    protected void searchCompleted(IMylarElement landmark) {
        if (landmark.getRelations().size() > 0) {
            ContextCorePlugin.getContextManager().notifyRelationshipsChanged(landmark);
        }
    }

    protected void incrementInterest(IMylarElement node, String elementKind, String elementHandle, int degreeOfSeparation) {
        boolean predictedInterest = true;
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.PREDICTION, elementKind, elementHandle, this.getSourceId(), this.getId(), null, (float)predictedInterest);
        ContextCorePlugin.getContextManager().handleInteractionEvent(event, false, false);
        this.createEdge(node, elementKind, elementHandle);
    }

    public void createEdge(IMylarElement toNode, String elementKind, String targetHandle) {
        CompositeContextElement targetNode = (CompositeContextElement)ContextCorePlugin.getContextManager().getElement(targetHandle);
        if (targetNode == null) {
            return;
        }
        MylarContextElement concreteTargetNode = null;
        if (targetNode.getNodes().size() != 1) {
            return;
        }
        concreteTargetNode = targetNode.getNodes().iterator().next();
        if (concreteTargetNode != null) {
            for (MylarContextElement sourceNode : ((CompositeContextElement)toNode).getNodes()) {
                MylarContextRelation edge = new MylarContextRelation(elementKind, this.getId(), sourceNode, concreteTargetNode, sourceNode.getContext());
                sourceNode.addEdge(edge);
            }
        }
    }

    protected abstract String getSourceId();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getCurrentDegreeOfSeparation() {
        return this.degreeOfSeparation;
    }

    @Override
    public void elementDeleted(IMylarElement node) {
    }

    @Override
    public void contextDeactivated(IMylarContext taskscape) {
    }

    @Override
    public void interestChanged(List<IMylarElement> nodes) {
    }

    @Override
    public void relationsChanged(IMylarElement node) {
    }

    public String toString() {
        return "(provider for: " + this.id + ")";
    }

    public String getStructureKind() {
        return this.structureKind;
    }

    public void setDegreeOfSeparation(int degreeOfSeparation) {
        this.degreeOfSeparation = degreeOfSeparation;
    }

    public abstract String getGenericId();

    public abstract void stopAllRunningJobs();
}

