/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.context.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.mylar.context.core.AbstractContextStore;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.AbstractRelationProvider;
import org.eclipse.mylar.core.IStatusHandler;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.ContextManager;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.mylar.core";
    public static final String CONTENT_TYPE_ANY = "*";
    private Map<String, AbstractContextStructureBridge> bridges = new HashMap<String, AbstractContextStructureBridge>();
    private Map<String, List<String>> childContentTypeMap = new HashMap<String, List<String>>();
    private AbstractContextStructureBridge defaultBridge = null;
    private static ContextCorePlugin INSTANCE;
    private static ContextManager contextManager;
    private static AbstractContextStore contextStore;
    private boolean extensionsLoaded = false;
    private Map<String, Set<AbstractRelationProvider>> relationProviders = new HashMap<String, Set<AbstractRelationProvider>>();
    private static final AbstractContextStructureBridge DEFAULT_BRIDGE;

    static {
        DEFAULT_BRIDGE = new AbstractContextStructureBridge(){

            @Override
            public String getContentType() {
                return null;
            }

            @Override
            public String getHandleIdentifier(Object object) {
                return null;
            }

            @Override
            public Object getObjectForHandle(String handle) {
                return null;
            }

            @Override
            public String getParentHandle(String handle) {
                return null;
            }

            @Override
            public String getName(Object object) {
                return "";
            }

            @Override
            public boolean canBeLandmark(String handle) {
                return false;
            }

            @Override
            public boolean acceptsObject(Object object) {
                return false;
            }

            @Override
            public boolean canFilter(Object element) {
                return true;
            }

            @Override
            public boolean isDocument(String handle) {
                return false;
            }

            @Override
            public String getContentType(String elementHandle) {
                return this.getContentType();
            }

            @Override
            public String getHandleForOffsetInObject(Object resource, int offset) {
                return null;
            }

            @Override
            public List<String> getChildHandles(String handle) {
                return Collections.emptyList();
            }
        };
    }

    public ContextCorePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        contextManager = new ContextManager();
        this.lazyLoadExtensions();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            INSTANCE = null;
            for (AbstractRelationProvider provider : this.getRelationProviders()) {
                provider.stopAllRunningJobs();
            }
        }
        catch (Exception e) {
            MylarStatusHandler.fail((Throwable)e, (String)"Mylar Core stop failed", (boolean)false);
        }
    }

    private void lazyLoadExtensions() {
        if (!this.extensionsLoaded) {
            ContextStoreExtensionReader.initExtensions();
            HandlersExtensionPointReader.initExtensions();
            for (AbstractRelationProvider provider : this.getRelationProviders()) {
                ContextCorePlugin.getContextManager().addListener(provider);
            }
            this.extensionsLoaded = true;
        }
    }

    private void addRelationProvider(String contentType, AbstractRelationProvider provider) {
        Set<AbstractRelationProvider> providers = this.relationProviders.get(contentType);
        if (providers == null) {
            providers = new HashSet<AbstractRelationProvider>();
            this.relationProviders.put(contentType, providers);
        }
        providers.add(provider);
    }

    public Set<AbstractRelationProvider> getRelationProviders() {
        HashSet<AbstractRelationProvider> allProviders = new HashSet<AbstractRelationProvider>();
        for (Set<AbstractRelationProvider> providers : this.relationProviders.values()) {
            allProviders.addAll(providers);
        }
        return allProviders;
    }

    public Set<AbstractRelationProvider> getRelationProviders(String contentType) {
        return this.relationProviders.get(contentType);
    }

    public static ContextCorePlugin getDefault() {
        return INSTANCE;
    }

    public static ContextManager getContextManager() {
        return contextManager;
    }

    public Map<String, AbstractContextStructureBridge> getStructureBridges() {
        BridgesExtensionPointReader.initExtensions();
        return this.bridges;
    }

    public AbstractContextStructureBridge getStructureBridge(String contentType) {
        BridgesExtensionPointReader.initExtensions();
        AbstractContextStructureBridge bridge = this.bridges.get(contentType);
        if (bridge != null) {
            return bridge;
        }
        return this.defaultBridge == null ? DEFAULT_BRIDGE : this.defaultBridge;
    }

    public Set<String> getKnownContentTypes() {
        BridgesExtensionPointReader.initExtensions();
        return this.bridges.keySet();
    }

    public AbstractContextStructureBridge getStructureBridge(Object object) {
        BridgesExtensionPointReader.initExtensions();
        for (AbstractContextStructureBridge structureBridge : this.bridges.values()) {
            if (!structureBridge.acceptsObject(object)) continue;
            return structureBridge;
        }
        return this.defaultBridge != null && this.defaultBridge.acceptsObject(object) ? this.defaultBridge : DEFAULT_BRIDGE;
    }

    private void internalAddBridge(AbstractContextStructureBridge bridge) {
        if (bridge.getContentType().equals(CONTENT_TYPE_ANY)) {
            this.defaultBridge = bridge;
        } else {
            this.bridges.put(bridge.getContentType(), bridge);
        }
        if (bridge.getParentContentType() != null) {
            List<String> childContentTypes = this.childContentTypeMap.get(bridge.getParentContentType());
            if (childContentTypes == null) {
                childContentTypes = new ArrayList<String>();
            }
            childContentTypes.add(bridge.getContentType());
            this.childContentTypeMap.put(bridge.getParentContentType(), childContentTypes);
        }
    }

    public AbstractContextStore getContextStore() {
        return contextStore;
    }

    public static void setContextStore(AbstractContextStore contextStore) {
        ContextCorePlugin.contextStore = contextStore;
    }

    public boolean suppressWizardsOnStartup() {
        List<String> commandLineArgs = Arrays.asList(Platform.getCommandLineArgs());
        if (commandLineArgs.contains("-showmylarwizards")) {
            return false;
        }
        return commandLineArgs.contains("-pdelaunch");
    }

    public void setDefaultBridge(AbstractContextStructureBridge defaultBridge) {
        this.defaultBridge = defaultBridge;
    }

    public List<String> getChildContentTypes(String contentType) {
        List<String> contentTypes = this.childContentTypeMap.get(contentType);
        if (contentTypes != null) {
            return contentTypes;
        }
        return Collections.emptyList();
    }

    static class BridgesExtensionPointReader {
        private static final String EXTENSION_ID_CONTEXT = "org.eclipse.mylar.context.core.bridges";
        private static final String ELEMENT_STRUCTURE_BRIDGE = "structureBridge";
        private static final String ELEMENT_RELATION_PROVIDER = "relationProvider";
        private static final String ATTR_CLASS = "class";
        private static final String ATTR_CONTENT_TYPE = "contentType";
        private static final String ATTR_PARENT_CONTENT_TYPE = "parentContentType";
        private static boolean extensionsRead = false;

        BridgesExtensionPointReader() {
        }

        public static void initExtensions() {
            if (!extensionsRead) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_CONTEXT);
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j].getName().compareTo(ELEMENT_STRUCTURE_BRIDGE) == 0) {
                            BridgesExtensionPointReader.readBridge(elements[j]);
                        } else if (elements[j].getName().compareTo(ELEMENT_RELATION_PROVIDER) == 0) {
                            BridgesExtensionPointReader.readRelationProvider(elements[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                extensionsRead = true;
            }
        }

        private static void readBridge(IConfigurationElement element) {
            try {
                String parentContentType;
                Object object = element.createExecutableExtension(ATTR_CLASS);
                if (!(object instanceof AbstractContextStructureBridge)) {
                    MylarStatusHandler.log((String)("Could not load bridge: " + object.getClass().getCanonicalName() + " must implement " + AbstractContextStructureBridge.class.getCanonicalName()), null);
                    return;
                }
                AbstractContextStructureBridge bridge = (AbstractContextStructureBridge)object;
                if (element.getAttribute(ATTR_PARENT_CONTENT_TYPE) != null && (parentContentType = element.getAttribute(ATTR_PARENT_CONTENT_TYPE)) instanceof String) {
                    bridge.setParentContentType(parentContentType);
                }
                ContextCorePlugin.getDefault().internalAddBridge(bridge);
            }
            catch (CoreException e) {
                MylarStatusHandler.log((Throwable)e, (String)"Could not load bridge extension");
            }
        }

        private static void readRelationProvider(IConfigurationElement element) {
            try {
                String contentType = element.getAttribute(ATTR_CONTENT_TYPE);
                AbstractRelationProvider relationProvider = (AbstractRelationProvider)element.createExecutableExtension(ATTR_CLASS);
                if (contentType != null) {
                    ContextCorePlugin.getDefault().addRelationProvider(contentType, relationProvider);
                }
            }
            catch (Exception e) {
                MylarStatusHandler.log((Throwable)e, (String)"Could not load relation provider");
            }
        }
    }

    static class ContextStoreExtensionReader {
        private static final String ELEMENT_CONTEXT_STORE = "contextStore";
        private static boolean extensionsRead = false;

        ContextStoreExtensionReader() {
        }

        public static void initExtensions() {
            if (!extensionsRead) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.mylar.context.core.bridges");
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j].getName().compareTo(ELEMENT_CONTEXT_STORE) == 0) {
                            ContextStoreExtensionReader.readStore(elements[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                extensionsRead = true;
            }
        }

        private static void readStore(IConfigurationElement element) {
        }
    }

    static class HandlersExtensionPointReader {
        private static final String EXTENSION_ID_HANDLERS = "org.eclipse.mylar.context.core.handlers";
        private static final String ELEMENT_STATUS = "status";
        private static final String ELEMENT_CLASS = "class";
        private static boolean extensionsRead = false;

        HandlersExtensionPointReader() {
        }

        public static void initExtensions() {
            if (!extensionsRead) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_HANDLERS);
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j].getName().compareTo(ELEMENT_STATUS) == 0) {
                            HandlersExtensionPointReader.readHandler(elements[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                extensionsRead = true;
            }
        }

        private static void readHandler(IConfigurationElement element) {
            try {
                Object object = element.createExecutableExtension(ELEMENT_CLASS);
                if (!(object instanceof IStatusHandler)) {
                    MylarStatusHandler.log((String)("Could not load handler: " + object.getClass().getCanonicalName() + " must implement " + AbstractContextStructureBridge.class.getCanonicalName()), null);
                    return;
                }
                IStatusHandler handler = (IStatusHandler)object;
                MylarStatusHandler.addStatusHandler((IStatusHandler)handler);
            }
            catch (CoreException coreException) {}
        }
    }
}

