/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.mylar.context.core.IMylarContext;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.internal.context.core.CompositeContextElement;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.MylarContextElement;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeContext
implements IMylarContext {
    protected Map<String, MylarContext> contexts = new HashMap<String, MylarContext>();
    protected IMylarElement activeNode = null;

    public IMylarElement addEvent(InteractionEvent event) {
        HashSet<MylarContextElement> nodes = new HashSet<MylarContextElement>();
        for (MylarContext context : this.contexts.values()) {
            MylarContextElement info = (MylarContextElement)context.parseEvent(event);
            nodes.add(info);
        }
        CompositeContextElement compositeNode = new CompositeContextElement(event.getStructureHandle(), nodes);
        return compositeNode;
    }

    @Override
    public IMylarElement get(String handle) {
        if (this.contexts.values().size() == 0) {
            return null;
        }
        HashSet<MylarContextElement> nodes = new HashSet<MylarContextElement>();
        for (MylarContext taskscape : this.contexts.values()) {
            MylarContextElement node = (MylarContextElement)taskscape.get(handle);
            if (node == null) continue;
            nodes.add(node);
        }
        CompositeContextElement composite = new CompositeContextElement(handle, nodes);
        return composite;
    }

    public List<IMylarElement> getLandmarks() {
        HashSet<IMylarElement> landmarks = new HashSet<IMylarElement>();
        for (MylarContext taskscape : this.contexts.values()) {
            for (IMylarElement concreteNode : taskscape.getLandmarkMap()) {
                if (concreteNode == null) continue;
                landmarks.add(this.get(concreteNode.getHandleIdentifier()));
            }
        }
        return new ArrayList<IMylarElement>(landmarks);
    }

    @Override
    public List<IMylarElement> getInteresting() {
        HashSet<IMylarElement> landmarks = new HashSet<IMylarElement>();
        for (MylarContext context : this.contexts.values()) {
            for (IMylarElement concreteNode : context.getInteresting()) {
                if (concreteNode == null) continue;
                landmarks.add(this.get(concreteNode.getHandleIdentifier()));
            }
        }
        return new ArrayList<IMylarElement>(landmarks);
    }

    public void setActiveElement(IMylarElement activeElement) {
        this.activeNode = activeElement;
    }

    @Override
    public IMylarElement getActiveNode() {
        return this.activeNode;
    }

    @Override
    public void delete(IMylarElement node) {
        for (MylarContext taskscape : this.contexts.values()) {
            taskscape.delete(node);
        }
    }

    public void clear() {
        for (MylarContext taskscape : this.contexts.values()) {
            taskscape.reset();
        }
    }

    Map<String, MylarContext> getContextMap() {
        return this.contexts;
    }

    @Override
    public List<IMylarElement> getAllElements() {
        HashSet<IMylarElement> nodes = new HashSet<IMylarElement>();
        for (MylarContext context : this.contexts.values()) {
            for (IMylarElement concreteNode : context.getAllElements()) {
                nodes.add(this.get(concreteNode.getHandleIdentifier()));
            }
        }
        return new ArrayList<IMylarElement>(nodes);
    }

    @Override
    public List<InteractionEvent> getInteractionHistory() {
        HashSet<InteractionEvent> events = new HashSet<InteractionEvent>();
        for (MylarContext taskscape : this.contexts.values()) {
            events.addAll(taskscape.getInteractionHistory());
        }
        return new ArrayList<InteractionEvent>(events);
    }

    @Override
    public void updateElementHandle(IMylarElement element, String newHandle) {
        for (MylarContext context : this.contexts.values()) {
            context.updateElementHandle(element, newHandle);
        }
        element.setHandleIdentifier(newHandle);
    }

    @Override
    public String getHandleIdentifier() {
        if (this.contexts.values().size() == 1) {
            return this.contexts.keySet().iterator().next();
        }
        return null;
    }
}

