/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylar.context.core.IDegreeOfInterest;
import org.eclipse.mylar.context.core.IMylarContext;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.CompositeDegreeOfInterest;
import org.eclipse.mylar.internal.context.core.MylarContextElement;
import org.eclipse.mylar.internal.context.core.MylarContextRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeContextElement
implements IMylarElement {
    private Set<MylarContextElement> nodes = null;
    private String handle = "<no handle>";

    public CompositeContextElement(String handle, Set<MylarContextElement> nodes) {
        this.nodes = nodes;
        this.handle = handle;
    }

    @Override
    public IMylarContext getContext() {
        IMylarElement highestValueNode = null;
        for (IMylarElement iMylarElement : this.nodes) {
            if (highestValueNode != null && !(iMylarElement.getInterest().getValue() < highestValueNode.getInterest().getValue())) continue;
            highestValueNode = iMylarElement;
        }
        if (highestValueNode != null) {
            return highestValueNode.getContext();
        }
        return null;
    }

    @Override
    public IDegreeOfInterest getInterest() {
        CompositeDegreeOfInterest degreeOfInterest = new CompositeDegreeOfInterest();
        for (IMylarElement iMylarElement : this.nodes) {
            degreeOfInterest.getComposedDegreesOfInterest().add(iMylarElement.getInterest());
        }
        return degreeOfInterest;
    }

    @Override
    public String getHandleIdentifier() {
        return this.handle;
    }

    @Override
    public void setHandleIdentifier(String handle) {
        this.handle = handle;
        for (IMylarElement iMylarElement : this.nodes) {
            iMylarElement.setHandleIdentifier(handle);
        }
    }

    public Set<MylarContextElement> getNodes() {
        return this.nodes;
    }

    @Override
    public String getContentType() {
        HashSet<String> kinds = new HashSet<String>();
        String lastKind = null;
        for (IMylarElement iMylarElement : this.nodes) {
            lastKind = iMylarElement.getContentType();
            kinds.add(lastKind);
        }
        if (kinds.size() == 1) {
            return lastKind;
        }
        return null;
    }

    @Override
    public MylarContextRelation getRelation(String targetHandle) {
        HashSet<MylarContextRelation> edges = new HashSet<MylarContextRelation>();
        for (IMylarElement iMylarElement : this.nodes) {
            edges.add(iMylarElement.getRelation(targetHandle));
        }
        if (edges.size() == 0) {
            return null;
        }
        if (edges.size() > 1) {
            MylarStatusHandler.log((String)"Multiple edges found in composite, not supported", (Object)this);
        }
        return (MylarContextRelation)edges.iterator().next();
    }

    @Override
    public Collection<MylarContextRelation> getRelations() {
        HashSet<MylarContextRelation> edges = new HashSet<MylarContextRelation>();
        for (MylarContextElement node : this.nodes) {
            edges.addAll(node.getRelations());
        }
        return edges;
    }

    @Override
    public void clearRelations() {
        for (MylarContextElement node : this.nodes) {
            node.clearRelations();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CompositeContextElement) {
            CompositeContextElement node = (CompositeContextElement)obj;
            return this.getHandleIdentifier().equals(node.getHandleIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "composite" + this.nodes;
    }
}

