/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylar.context.core.IDegreeOfInterest;
import org.eclipse.mylar.internal.context.core.ContextManager;
import org.eclipse.mylar.internal.context.core.DegreeOfInterest;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDegreeOfInterest
implements IDegreeOfInterest {
    private Set<IDegreeOfInterest> composed = new HashSet<IDegreeOfInterest>();

    public void addEvent(InteractionEvent event) {
        for (IDegreeOfInterest info : this.composed) {
            ((DegreeOfInterest)info).addEvent(event);
        }
    }

    @Override
    public List<InteractionEvent> getEvents() {
        HashSet<InteractionEvent> events = new HashSet<InteractionEvent>();
        for (IDegreeOfInterest info : this.composed) {
            events.addAll(info.getEvents());
        }
        return new ArrayList<InteractionEvent>(events);
    }

    @Override
    public float getValue() {
        float value = 0.0f;
        for (IDegreeOfInterest info : this.composed) {
            value += info.getValue();
        }
        return value;
    }

    @Override
    public float getDecayValue() {
        float value = 0.0f;
        for (IDegreeOfInterest info : this.composed) {
            value += info.getDecayValue();
        }
        return value;
    }

    @Override
    public float getEncodedValue() {
        float value = 0.0f;
        for (IDegreeOfInterest info : this.composed) {
            value += info.getEncodedValue();
        }
        return value;
    }

    @Override
    public boolean isInteresting() {
        boolean isInteresting = false;
        for (IDegreeOfInterest info : this.composed) {
            if (!info.isInteresting()) continue;
            isInteresting = true;
        }
        return isInteresting;
    }

    @Override
    public boolean isPropagated() {
        if (this.composed.isEmpty()) {
            return false;
        }
        boolean allPropagated = true;
        for (IDegreeOfInterest info : this.composed) {
            if (info.isPropagated()) continue;
            allPropagated = false;
        }
        return allPropagated;
    }

    @Override
    public boolean isPredicted() {
        if (this.composed.isEmpty()) {
            return false;
        }
        boolean allPredicted = true;
        for (IDegreeOfInterest info : this.composed) {
            if (info.isPredicted()) continue;
            allPredicted = false;
        }
        return allPredicted;
    }

    @Override
    public boolean isLandmark() {
        return this.getValue() >= ContextManager.getScalingFactors().getLandmark();
    }

    public Set<IDegreeOfInterest> getComposedDegreesOfInterest() {
        return this.composed;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("composite(");
        for (IDegreeOfInterest info : this.composed) {
            result.append(info.toString());
        }
        result.append(")");
        return result.toString();
    }
}

