/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.AbstractRelationProvider;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarContext;
import org.eclipse.mylar.context.core.IMylarContextListener;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.core.IMylarRelation;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.CompositeContext;
import org.eclipse.mylar.internal.context.core.CompositeContextElement;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.MylarContextElement;
import org.eclipse.mylar.internal.context.core.MylarContextExternalizer;
import org.eclipse.mylar.internal.context.core.ScalingFactors;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextManager {
    public static final String CONTEXT_FILENAME_ENCODING = "UTF-8";
    public static final String ACTIVITY_DELTA_DEACTIVATED = "deactivated";
    public static final String ACTIVITY_DELTA_ACTIVATED = "activated";
    public static final String ACTIVITY_DELTA_PULSE = "pulse";
    public static final String ACTIVITY_ORIGIN_ID = "org.eclipse.mylar.core";
    public static final String ACTIVITY_HANDLE_ATTENTION = "attention";
    public static final String ACTIVITY_HANDLE_LIFECYCLE = "lifecycle";
    public static final String ACTIVITY_DELTA_STARTED = "started";
    public static final String ACTIVITY_DELTA_STOPPED = "stopped";
    public static final String ACTIVITY_STRUCTURE_KIND = "context";
    public static final String CONTEXT_HISTORY_FILE_NAME = "activity";
    public static final String OLD_CONTEXT_HISTORY_FILE_NAME = "context-history";
    public static final String SOURCE_ID_MODEL_PROPAGATION = "org.eclipse.mylar.core.model.interest.propagation";
    public static final String SOURCE_ID_DECAY = "org.eclipse.mylar.core.model.interest.decay";
    public static final String SOURCE_ID_DECAY_CORRECTION = "org.eclipse.mylar.core.model.interest.decay.correction";
    public static final String SOURCE_ID_MODEL_ERROR = "org.eclipse.mylar.core.model.interest.propagation";
    public static final String CONTAINMENT_PROPAGATION_ID = "org.eclipse.mylar.core.model.edges.containment";
    public static final String CONTEXT_FILE_EXTENSION = ".xml.zip";
    public static final String CONTEXT_FILE_EXTENSION_OLD = ".xml";
    private static final int MAX_PROPAGATION = 17;
    private int numInterestingErrors = 0;
    private List<String> errorElementHandles = new ArrayList<String>();
    private Set<File> contextFiles = null;
    private boolean contextCapturePaused = false;
    private CompositeContext currentContext = new CompositeContext();
    private MylarContext activityMetaContext = null;
    private List<IMylarContextListener> activityMetaContextListeners = new ArrayList<IMylarContextListener>();
    private List<IMylarContextListener> listeners = new ArrayList<IMylarContextListener>();
    private List<IMylarContextListener> waitingListeners = new ArrayList<IMylarContextListener>();
    private boolean suppressListenerNotification = false;
    private MylarContextExternalizer externalizer = new MylarContextExternalizer();
    private boolean activationHistorySuppressed = false;
    private static ScalingFactors scalingFactors = new ScalingFactors();

    public MylarContext getActivityHistoryMetaContext() {
        if (this.activityMetaContext == null) {
            this.loadActivityMetaContext();
        }
        return this.activityMetaContext;
    }

    public void loadActivityMetaContext() {
        if (ContextCorePlugin.getDefault().getContextStore() != null) {
            File contextActivityFile = this.getFileForContext(CONTEXT_HISTORY_FILE_NAME);
            this.activityMetaContext = this.externalizer.readContextFromXML(CONTEXT_HISTORY_FILE_NAME, contextActivityFile);
            if (this.activityMetaContext == null) {
                this.resetActivityHistory();
            }
            for (IMylarContextListener listener : this.activityMetaContextListeners) {
                listener.contextActivated(this.activityMetaContext);
            }
        } else {
            this.resetActivityHistory();
            MylarStatusHandler.log((String)"No context store installed, not restoring activity context.", (Object)this);
        }
    }

    public void handleActivityMetaContextEvent(InteractionEvent event) {
        IMylarElement element = this.getActivityHistoryMetaContext().parseEvent(event);
        for (IMylarContextListener listener : this.activityMetaContextListeners) {
            try {
                ArrayList<IMylarElement> changed = new ArrayList<IMylarElement>();
                changed.add(element);
                listener.interestChanged(changed);
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)"context listener failed", (boolean)false);
            }
        }
    }

    public void resetActivityHistory() {
        this.activityMetaContext = new MylarContext(CONTEXT_HISTORY_FILE_NAME, ContextManager.getScalingFactors());
        this.saveActivityHistoryContext();
    }

    public IMylarElement getActiveElement() {
        if (this.currentContext != null) {
            return this.currentContext.getActiveNode();
        }
        return null;
    }

    public void addErrorPredictedInterest(String handle, String kind, boolean notify) {
        if (this.numInterestingErrors > scalingFactors.getMaxNumInterestingErrors() || this.currentContext.getContextMap().isEmpty()) {
            return;
        }
        InteractionEvent errorEvent = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, kind, handle, "org.eclipse.mylar.core.model.interest.propagation", scalingFactors.getErrorInterest());
        this.handleInteractionEvent(errorEvent, true);
        this.errorElementHandles.add(handle);
        ++this.numInterestingErrors;
    }

    public void removeErrorPredictedInterest(String handle, String kind, boolean notify) {
        if (this.currentContext.getContextMap().isEmpty()) {
            return;
        }
        if (handle == null) {
            return;
        }
        IMylarElement element = this.currentContext.get(handle);
        if (element != null && element.getInterest().isInteresting() && this.errorElementHandles.contains(handle)) {
            InteractionEvent errorEvent = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, kind, handle, "org.eclipse.mylar.core.model.interest.propagation", -scalingFactors.getErrorInterest());
            this.handleInteractionEvent(errorEvent, true);
            --this.numInterestingErrors;
            this.errorElementHandles.remove(handle);
            if (notify) {
                for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                    ArrayList<IMylarElement> changed = new ArrayList<IMylarElement>();
                    changed.add(element);
                    listener.interestChanged(changed);
                }
            }
        }
    }

    public IMylarElement getElement(String elementHandle) {
        if (this.currentContext != null && elementHandle != null) {
            return this.currentContext.get(elementHandle);
        }
        return null;
    }

    public IMylarElement handleInteractionEvent(InteractionEvent event) {
        return this.handleInteractionEvent(event, true);
    }

    public IMylarElement handleInteractionEvent(InteractionEvent event, boolean propagateToParents) {
        return this.handleInteractionEvent(event, propagateToParents, true);
    }

    public void handleInteractionEvents(List<InteractionEvent> events, boolean propagateToParents) {
        HashSet<IMylarElement> compositeDelta = new HashSet<IMylarElement>();
        for (InteractionEvent event : events) {
            compositeDelta.addAll(this.internalHandleInteractionEvent(event, propagateToParents));
        }
        this.notifyInterestDelta(new ArrayList<IMylarElement>(compositeDelta));
    }

    public IMylarElement handleInteractionEvent(InteractionEvent event, boolean propagateToParents, boolean notifyListeners) {
        List<IMylarElement> interestDelta = this.internalHandleInteractionEvent(event, propagateToParents);
        if (notifyListeners) {
            this.notifyInterestDelta(interestDelta);
        }
        return this.currentContext.get(event.getStructureHandle());
    }

    private List<IMylarElement> internalHandleInteractionEvent(InteractionEvent event, boolean propagateToParents) {
        if (this.contextCapturePaused || InteractionEvent.Kind.COMMAND.equals((Object)event.getKind()) || !this.isContextActive() || this.suppressListenerNotification) {
            return Collections.emptyList();
        }
        IMylarElement previous = this.currentContext.get(event.getStructureHandle());
        float previousInterest = 0.0f;
        boolean previouslyPredicted = false;
        boolean previouslyPropagated = false;
        float decayOffset = 0.0f;
        if (previous != null) {
            previousInterest = previous.getInterest().getValue();
            previouslyPredicted = previous.getInterest().isPredicted();
            previouslyPropagated = previous.getInterest().isPropagated();
        }
        if (event.getKind().isUserEvent()) {
            decayOffset = this.ensureIsInteresting(event.getStructureKind(), event.getStructureHandle(), previous, previousInterest);
        }
        IMylarElement element = this.currentContext.addEvent(event);
        ArrayList<IMylarElement> interestDelta = new ArrayList<IMylarElement>();
        if (propagateToParents && !event.getKind().equals((Object)InteractionEvent.Kind.MANIPULATION)) {
            this.propegateInterestToParents(event.getKind(), element, previousInterest, decayOffset, 1, interestDelta);
        }
        if (event.getKind().isUserEvent()) {
            this.currentContext.setActiveElement(element);
        }
        if (this.isInterestDelta(previousInterest, previouslyPredicted, previouslyPropagated, element)) {
            interestDelta.add(element);
        }
        this.checkForLandmarkDeltaAndNotify(previousInterest, element);
        return interestDelta;
    }

    private float ensureIsInteresting(String contentType, String handle, IMylarElement previous, float previousInterest) {
        float decayOffset = 0.0f;
        if (previousInterest < 0.0f) {
            decayOffset = -1.0f * previous.getInterest().getValue();
            this.currentContext.addEvent(new InteractionEvent(InteractionEvent.Kind.MANIPULATION, contentType, handle, SOURCE_ID_DECAY_CORRECTION, decayOffset));
        }
        return decayOffset;
    }

    private void notifyInterestDelta(List<IMylarElement> interestDelta) {
        if (!interestDelta.isEmpty()) {
            for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                listener.interestChanged(interestDelta);
            }
        }
    }

    protected boolean isInterestDelta(float previousInterest, boolean previouslyPredicted, boolean previouslyPropagated, IMylarElement node) {
        float currentInterest = node.getInterest().getValue();
        if (previousInterest <= 0.0f && currentInterest > 0.0f) {
            return true;
        }
        if (previousInterest > 0.0f && currentInterest <= 0.0f) {
            return true;
        }
        if (currentInterest > 0.0f && previouslyPredicted && !node.getInterest().isPredicted()) {
            return true;
        }
        return currentInterest > 0.0f && previouslyPropagated && !node.getInterest().isPropagated();
    }

    protected void checkForLandmarkDeltaAndNotify(float previousInterest, IMylarElement node) {
        block2: {
            block3: {
                AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                if (!bridge.canBeLandmark(node.getHandleIdentifier())) break block2;
                if (!(previousInterest >= scalingFactors.getLandmark()) || node.getInterest().isLandmark()) break block3;
                for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                    listener.landmarkRemoved(node);
                }
                break block2;
            }
            if (!(previousInterest < scalingFactors.getLandmark()) || !node.getInterest().isLandmark()) break block2;
            for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                listener.landmarkAdded(node);
            }
        }
    }

    private void propegateInterestToParents(InteractionEvent.Kind kind, IMylarElement node, float previousInterest, float decayOffset, int level, List<IMylarElement> interestDelta) {
        if (level > 17 || node == null || node.getHandleIdentifier() == null || node.getInterest().getValue() <= 0.0f) {
            return;
        }
        this.checkForLandmarkDeltaAndNotify(previousInterest, node);
        ++level;
        float propagatedIncrement = node.getInterest().getValue() - previousInterest + decayOffset;
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
        String parentHandle = bridge.getParentHandle(node.getHandleIdentifier());
        for (String contentType : ContextCorePlugin.getDefault().getChildContentTypes(bridge.getContentType())) {
            AbstractContextStructureBridge canonicalBridge;
            AbstractContextStructureBridge childBridge = ContextCorePlugin.getDefault().getStructureBridge(contentType);
            Object resolved = childBridge.getObjectForHandle(parentHandle);
            if (resolved == null || (canonicalBridge = ContextCorePlugin.getDefault().getStructureBridge(resolved)).getContentType().equals("*")) continue;
            bridge = canonicalBridge;
        }
        if (parentHandle != null) {
            InteractionEvent propagationEvent = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, bridge.getContentType(node.getHandleIdentifier()), parentHandle, "org.eclipse.mylar.core.model.interest.propagation", CONTAINMENT_PROPAGATION_ID, propagatedIncrement);
            IMylarElement previous = this.currentContext.get(propagationEvent.getStructureHandle());
            if (previous != null && previous.getInterest() != null) {
                previousInterest = previous.getInterest().getValue();
            }
            CompositeContextElement parentNode = (CompositeContextElement)this.currentContext.addEvent(propagationEvent);
            if (kind.isUserEvent() && parentNode.getInterest().getEncodedValue() < scalingFactors.getInteresting()) {
                float parentOffset = -1.0f * parentNode.getInterest().getEncodedValue() + 1.0f;
                this.currentContext.addEvent(new InteractionEvent(InteractionEvent.Kind.MANIPULATION, parentNode.getContentType(), parentNode.getHandleIdentifier(), SOURCE_ID_DECAY_CORRECTION, parentOffset));
            }
            if (this.isInterestDelta(previousInterest, previous.getInterest().isPredicted(), previous.getInterest().isPropagated(), parentNode)) {
                interestDelta.add(0, parentNode);
            }
            this.propegateInterestToParents(kind, parentNode, previousInterest, decayOffset, level, interestDelta);
        }
    }

    public List<IMylarElement> findCompositesForNodes(List<MylarContextElement> nodes) {
        ArrayList<IMylarElement> composites = new ArrayList<IMylarElement>();
        for (MylarContextElement node : nodes) {
            composites.add(this.currentContext.get(node.getHandleIdentifier()));
        }
        return composites;
    }

    public void addListener(IMylarContextListener listener) {
        if (listener != null) {
            if (this.suppressListenerNotification && !this.waitingListeners.contains(listener)) {
                this.waitingListeners.add(listener);
            } else if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        } else {
            MylarStatusHandler.log((String)"attempted to add null lisetener", (Object)this);
        }
    }

    public void removeListener(IMylarContextListener listener) {
        this.listeners.remove(listener);
    }

    public void addActivityMetaContextListener(IMylarContextListener listener) {
        this.activityMetaContextListeners.add(listener);
    }

    public void removeActivityMetaContextListener(IMylarContextListener listener) {
        this.activityMetaContextListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void activateContext(MylarContext context) {
        this.currentContext.getContextMap().put(context.getHandleIdentifier(), context);
        if (this.contextFiles != null) {
            this.contextFiles.add(this.getFileForContext(context.getHandleIdentifier()));
        }
        if (!this.activationHistorySuppressed) {
            this.handleActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.COMMAND, ACTIVITY_STRUCTURE_KIND, context.getHandleIdentifier(), ACTIVITY_ORIGIN_ID, null, ACTIVITY_DELTA_ACTIVATED, 1.0f));
        }
    }

    public List<MylarContext> getActiveContexts() {
        return new ArrayList<MylarContext>(this.currentContext.getContextMap().values());
    }

    public void activateContext(String handleIdentifier) {
        try {
            this.suppressListenerNotification = true;
            MylarContext context = this.currentContext.getContextMap().get(handleIdentifier);
            if (context == null) {
                context = this.loadContext(handleIdentifier);
            }
            if (context != null) {
                this.activateContext(context);
                for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                    try {
                        listener.contextActivated(context);
                    }
                    catch (Exception e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"context listener failed", (boolean)false);
                    }
                }
            } else {
                MylarStatusHandler.log((String)"Could not load context", (Object)this);
            }
            this.suppressListenerNotification = false;
            this.listeners.addAll(this.waitingListeners);
            this.waitingListeners.clear();
        }
        catch (Throwable t) {
            MylarStatusHandler.log((Throwable)t, (String)"Could not activate context");
        }
    }

    public boolean hasContext(String handleIdentifier) {
        if (handleIdentifier == null) {
            return false;
        }
        if (this.contextFiles == null) {
            File[] files;
            this.contextFiles = new HashSet<File>();
            File contextDirectory = ContextCorePlugin.getDefault().getContextStore().getContextDirectory();
            File[] fileArray = files = contextDirectory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.contextFiles.add(file);
                ++n2;
            }
        }
        if (this.getActiveContext() != null && handleIdentifier.equals(this.getActiveContext().getHandleIdentifier())) {
            return !this.getActiveContext().getAllElements().isEmpty();
        }
        File file = this.getFileForContext(handleIdentifier);
        return this.contextFiles.contains(file);
    }

    public void deactivateAllContexts() {
        for (String handleIdentifier : this.currentContext.getContextMap().keySet()) {
            this.deactivateContext(handleIdentifier);
        }
    }

    public void deactivateContext(String handleIdentifier) {
        try {
            IMylarContext context = this.currentContext.getContextMap().get(handleIdentifier);
            if (context != null) {
                this.saveContext(handleIdentifier);
                this.currentContext.getContextMap().remove(handleIdentifier);
                this.setContextCapturePaused(true);
                for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                    try {
                        listener.contextDeactivated(context);
                    }
                    catch (Exception e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"context listener failed", (boolean)false);
                    }
                }
                if (context.getAllElements().size() == 0) {
                    this.contextFiles.remove(this.getFileForContext(context.getHandleIdentifier()));
                }
                this.setContextCapturePaused(false);
            }
            if (!this.activationHistorySuppressed) {
                this.handleActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.COMMAND, ACTIVITY_STRUCTURE_KIND, handleIdentifier, ACTIVITY_ORIGIN_ID, null, ACTIVITY_DELTA_DEACTIVATED, 1.0f));
            }
            this.saveActivityHistoryContext();
        }
        catch (Throwable t) {
            MylarStatusHandler.log((Throwable)t, (String)"Could not deactivate context");
        }
    }

    public void deleteContext(String handleIdentifier) {
        IMylarContext context = this.currentContext.getContextMap().get(handleIdentifier);
        this.eraseContext(handleIdentifier, false);
        try {
            File file = this.getFileForContext(handleIdentifier);
            if (file.exists()) {
                file.delete();
            }
            this.setContextCapturePaused(true);
            for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                listener.contextCleared(context);
            }
            this.setContextCapturePaused(false);
            if (this.contextFiles != null) {
                this.contextFiles.add(this.getFileForContext(handleIdentifier));
            }
        }
        catch (SecurityException e) {
            MylarStatusHandler.fail((Throwable)e, (String)"Could not delete context file", (boolean)false);
        }
    }

    private void eraseContext(String handleIdentifier, boolean notify) {
        MylarContext context;
        if (this.contextFiles != null) {
            this.contextFiles.remove(this.getFileForContext(handleIdentifier));
        }
        if ((context = this.currentContext.getContextMap().get(handleIdentifier)) == null) {
            return;
        }
        this.currentContext.getContextMap().remove(context);
        context.reset();
    }

    public MylarContext loadContext(String handleIdentifier) {
        MylarContext loadedContext = this.externalizer.readContextFromXML(handleIdentifier, this.getFileForContext(handleIdentifier));
        if (loadedContext == null) {
            return new MylarContext(handleIdentifier, ContextManager.getScalingFactors());
        }
        return loadedContext;
    }

    public synchronized void saveContext(String handleIdentifier) {
        boolean wasPaused = this.contextCapturePaused;
        try {
            MylarContext context;
            if (!wasPaused) {
                this.setContextCapturePaused(true);
            }
            if ((context = this.currentContext.getContextMap().get(handleIdentifier)) == null) {
                return;
            }
            try {
                context.collapse();
                this.externalizer.writeContextToXml(context, this.getFileForContext(handleIdentifier));
                this.contextFiles.add(this.getFileForContext(handleIdentifier));
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)"could not save context", (boolean)false);
            }
        }
        finally {
            if (!wasPaused) {
                this.setContextCapturePaused(false);
            }
        }
    }

    public synchronized void saveActivityHistoryContext() {
        if (ContextCorePlugin.getDefault().getContextStore() == null) {
            return;
        }
        boolean wasPaused = this.contextCapturePaused;
        try {
            try {
                if (!wasPaused) {
                    this.setContextCapturePaused(true);
                }
                ArrayList<InteractionEvent> attention = new ArrayList<InteractionEvent>();
                MylarContext context = this.getActivityHistoryMetaContext();
                MylarContext tempContext = new MylarContext(CONTEXT_HISTORY_FILE_NAME, ContextManager.getScalingFactors());
                for (InteractionEvent event : context.getInteractionHistory()) {
                    if (event.getDelta().equals(ACTIVITY_DELTA_ACTIVATED) && event.getStructureHandle().equals(ACTIVITY_HANDLE_ATTENTION)) {
                        attention.add(event);
                        continue;
                    }
                    this.addAttentionEvents(attention, tempContext);
                    tempContext.parseEvent(event);
                }
                if (!attention.isEmpty()) {
                    this.addAttentionEvents(attention, tempContext);
                }
                this.externalizer.writeContextToXml(tempContext, this.getFileForContext(CONTEXT_HISTORY_FILE_NAME));
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)"could not save activity history", (boolean)false);
                if (!wasPaused) {
                    this.setContextCapturePaused(false);
                }
            }
        }
        finally {
            if (!wasPaused) {
                this.setContextCapturePaused(false);
            }
        }
    }

    private void addAttentionEvents(List<InteractionEvent> attention, MylarContext temp) {
        InteractionEvent aggregateEvent = null;
        try {
            if (attention.size() > 1) {
                InteractionEvent firstEvent = attention.get(0);
                long totalTime = 0L;
                for (InteractionEvent interactionEvent : attention) {
                    totalTime += interactionEvent.getEndDate().getTime() - interactionEvent.getDate().getTime();
                }
                if (totalTime != 0L) {
                    Date newEndDate = new Date(firstEvent.getDate().getTime() + totalTime);
                    aggregateEvent = new InteractionEvent(firstEvent.getKind(), firstEvent.getStructureKind(), firstEvent.getStructureHandle(), firstEvent.getOriginId(), firstEvent.getNavigation(), firstEvent.getDelta(), 1.0f, firstEvent.getDate(), newEndDate);
                }
            } else if (attention.size() == 1 && attention.get(0).getEndDate().getTime() - attention.get(0).getDate().getTime() > 0L) {
                aggregateEvent = attention.get(0);
            }
            if (aggregateEvent != null) {
                temp.parseEvent(aggregateEvent);
            }
            attention.clear();
        }
        catch (Exception e) {
            MylarStatusHandler.fail((Throwable)e, (String)"Error during meta activity collapse", (boolean)false);
        }
    }

    public File getFileForContext(String handleIdentifier) {
        try {
            String encoded = URLEncoder.encode(handleIdentifier, CONTEXT_FILENAME_ENCODING);
            File contextDirectory = ContextCorePlugin.getDefault().getContextStore().getContextDirectory();
            File contextFile = new File(contextDirectory, String.valueOf(encoded) + CONTEXT_FILE_EXTENSION);
            return contextFile;
        }
        catch (UnsupportedEncodingException e) {
            MylarStatusHandler.fail((Throwable)e, (String)"Could not determine path for context", (boolean)false);
            return null;
        }
    }

    public IMylarContext getActiveContext() {
        return this.currentContext;
    }

    public void resetLandmarkRelationshipsOfKind(String reltationKind) {
        for (IMylarElement landmark : this.currentContext.getLandmarks()) {
            for (IMylarRelation iMylarRelation : landmark.getRelations()) {
                if (!iMylarRelation.getRelationshipHandle().equals(reltationKind)) continue;
                landmark.clearRelations();
            }
        }
        for (IMylarContextListener listener : this.listeners) {
            listener.relationsChanged(null);
        }
    }

    public void notifyRelationshipsChanged(IMylarElement node) {
        if (this.suppressListenerNotification) {
            return;
        }
        for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
            listener.relationsChanged(node);
        }
    }

    public static ScalingFactors getScalingFactors() {
        return scalingFactors;
    }

    public boolean isContextActive() {
        return !this.contextCapturePaused && this.currentContext.getContextMap().values().size() > 0;
    }

    public List<IMylarElement> getActiveLandmarks() {
        List<IMylarElement> allLandmarks = this.currentContext.getLandmarks();
        ArrayList<IMylarElement> acceptedLandmarks = new ArrayList<IMylarElement>();
        for (IMylarElement node : allLandmarks) {
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
            if (!bridge.canBeLandmark(node.getHandleIdentifier())) continue;
            acceptedLandmarks.add(node);
        }
        return acceptedLandmarks;
    }

    public Collection<IMylarElement> getInterestingDocuments(IMylarContext context) {
        HashSet<IMylarElement> set = new HashSet<IMylarElement>();
        if (context == null) {
            return set;
        }
        List<IMylarElement> allIntersting = context.getInteresting();
        for (IMylarElement node : allIntersting) {
            if (!ContextCorePlugin.getDefault().getStructureBridge(node.getContentType()).isDocument(node.getHandleIdentifier())) continue;
            set.add(node);
        }
        return set;
    }

    public Collection<IMylarElement> getInterestingDocuments() {
        return this.getInterestingDocuments(this.currentContext);
    }

    public boolean isActivationHistorySuppressed() {
        return this.activationHistorySuppressed;
    }

    public void setActivationHistorySuppressed(boolean activationHistorySuppressed) {
        this.activationHistorySuppressed = activationHistorySuppressed;
    }

    public boolean manipulateInterestForElement(IMylarElement element, boolean increment, boolean forceLandmark, String sourceId) {
        if (element == null) {
            return false;
        }
        float originalValue = element.getInterest().getValue();
        float changeValue = 0.0f;
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
        if (!increment) {
            if (element.getInterest().isLandmark() && bridge.canBeLandmark(element.getHandleIdentifier())) {
                changeValue = -1.0f * originalValue + 1.0f;
            } else {
                if (originalValue >= 0.0f) {
                    changeValue = -1.0f * originalValue - 1.0f;
                }
                for (String childHandle : bridge.getChildHandles(element.getHandleIdentifier())) {
                    IMylarElement childElement = this.getElement(childHandle);
                    if (childElement == null || !childElement.getInterest().isInteresting() || childElement.equals(element)) continue;
                    this.manipulateInterestForElement(childElement, increment, forceLandmark, sourceId);
                }
            }
        } else if (!forceLandmark && originalValue > ContextManager.getScalingFactors().getLandmark()) {
            changeValue = 0.0f;
        } else if (element != null && bridge.canBeLandmark(element.getHandleIdentifier())) {
            changeValue = 2.0f * ContextManager.getScalingFactors().getLandmark() - originalValue + 1.0f;
        } else {
            return false;
        }
        if (changeValue != 0.0f) {
            InteractionEvent interactionEvent = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, element.getContentType(), element.getHandleIdentifier(), sourceId, changeValue);
            this.handleInteractionEvent(interactionEvent);
        }
        return true;
    }

    public void setActiveSearchEnabled(boolean enabled) {
        for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
            provider.setEnabled(enabled);
        }
    }

    public String getDominantContextHandleForElement(IMylarElement node) {
        IMylarElement dominantNode = null;
        if (node instanceof CompositeContextElement) {
            CompositeContextElement compositeNode = (CompositeContextElement)node;
            if (compositeNode.getNodes().isEmpty()) {
                return null;
            }
            dominantNode = (IMylarElement)compositeNode.getNodes().toArray()[0];
            for (IMylarElement iMylarElement : compositeNode.getNodes()) {
                if (dominantNode == null || !(dominantNode.getInterest().getValue() < iMylarElement.getInterest().getValue())) continue;
                dominantNode = iMylarElement;
            }
        } else if (node instanceof MylarContextElement) {
            dominantNode = node;
        }
        if (node != null) {
            return ((MylarContextElement)dominantNode).getContext().getHandleIdentifier();
        }
        return null;
    }

    public void updateHandle(IMylarElement element, String newHandle) {
        if (element == null) {
            return;
        }
        this.getActiveContext().updateElementHandle(element, newHandle);
        for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
            ArrayList<IMylarElement> changed = new ArrayList<IMylarElement>();
            changed.add(element);
            listener.interestChanged(changed);
        }
        if (element.getInterest().isLandmark()) {
            for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
                listener.landmarkAdded(element);
            }
        }
    }

    public void delete(IMylarElement element) {
        if (element == null) {
            return;
        }
        this.getActiveContext().delete(element);
        for (IMylarContextListener listener : new ArrayList<IMylarContextListener>(this.listeners)) {
            listener.elementDeleted(element);
        }
    }

    public void setContextCapturePaused(boolean paused) {
        this.contextCapturePaused = paused;
    }

    public boolean isContextCapturePaused() {
        return this.contextCapturePaused;
    }

    public List<IMylarContextListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public boolean isValidContextFile(File file) {
        if (file.exists() && file.getName().endsWith(CONTEXT_FILE_EXTENSION)) {
            MylarContext context = this.externalizer.readContextFromXML("temp", file);
            return context != null;
        }
        return false;
    }

    public void transferContextAndActivate(String handleIdentifier, File file) {
        File contextFile = this.getFileForContext(handleIdentifier);
        contextFile.delete();
        try {
            this.copy(file, contextFile);
        }
        catch (IOException e) {
            MylarStatusHandler.fail((Throwable)e, (String)"Cold not transfer context", (boolean)false);
        }
    }

    private void copy(File src, File dest) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

